/*
 * Decompiled with CFR 0.152.
 */
package de.kapsi.net.daap.chunks;

import de.kapsi.net.daap.chunks.AbstractChunk;
import de.kapsi.net.daap.chunks.ByteChunk;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class UByteChunk
extends AbstractChunk
implements ByteChunk {
    private static final Log LOG = LogFactory.getLog(UByteChunk.class);
    public static final int MIN_VALUE = 0;
    public static final int MAX_VALUE = 255;
    protected int value = 0;

    public UByteChunk(int type, String name, int value) {
        super(type, name);
        this.setValue(value);
    }

    public UByteChunk(String type, String name, int value) {
        super(type, name);
        this.setValue(value);
    }

    public void setValue(int value) {
        this.value = UByteChunk.checkUByteRange(value);
    }

    public int getValue() {
        return this.value;
    }

    public static int checkUByteRange(int value) throws IllegalArgumentException {
        if ((value < 0 || value > 255) && LOG.isErrorEnabled()) {
            LOG.error((Object)("Value is outside of unsigned byte range: " + value));
        }
        return value;
    }

    public int getType() {
        return 1;
    }

    public String toString(int indent) {
        return UByteChunk.indent(indent) + this.name + "(" + this.getContentCodeString() + "; ubyte)=" + this.getValue();
    }
}

