/*
 * Decompiled with CFR 0.152.
 */
package de.kapsi.net.daap.chunks;

import de.kapsi.net.daap.chunks.AbstractChunk;
import java.io.UnsupportedEncodingException;

public abstract class StringChunk
extends AbstractChunk {
    protected String value;

    public StringChunk(int type, String name, String value) {
        super(type, name);
        this.setValue(value);
    }

    public StringChunk(String type, String name, String value) {
        super(type, name);
        this.setValue(value);
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public byte[] getBytes() {
        String value = this.value;
        if (value == null || value.length() == 0) {
            return new byte[0];
        }
        try {
            return value.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException err) {
            throw new RuntimeException(err);
        }
    }

    public int getType() {
        return 9;
    }

    public String toString(int indent) {
        return StringChunk.indent(indent) + this.name + "(" + this.getContentCodeString() + "; string)=" + this.getValue();
    }
}

