/*
 * Decompiled with CFR 0.152.
 */
package de.kapsi.net.daap.chunks;

import de.kapsi.net.daap.DaapUtil;
import de.kapsi.net.daap.chunks.Chunk;

public abstract class AbstractChunk
implements Chunk {
    protected final int contentCode;
    protected final String name;

    protected AbstractChunk(String contentCode, String name) {
        if (contentCode.length() != 4) {
            throw new IllegalArgumentException("Content Code must be 4 chars");
        }
        this.contentCode = DaapUtil.toContentCodeNumber(contentCode);
        this.name = name;
    }

    protected AbstractChunk(int contentCode, String name) {
        this.contentCode = contentCode;
        this.name = name;
    }

    public int getContentCode() {
        return this.contentCode;
    }

    public String getContentCodeString() {
        return DaapUtil.toContentCodeString(this.contentCode);
    }

    public String getName() {
        return this.name;
    }

    public abstract int getType();

    public String toString() {
        return this.toString(0);
    }

    public String toString(int indent) {
        return AbstractChunk.indent(indent) + this.name + "('" + this.getContentCodeString() + "')";
    }

    protected static String indent(int indent) {
        StringBuffer buffer = new StringBuffer(indent);
        for (int i = 0; i < indent; ++i) {
            buffer.append(' ');
        }
        return buffer.toString();
    }
}

