/*
 * Decompiled with CFR 0.152.
 */
package de.kapsi.net.daap;

import de.kapsi.net.daap.DaapAuthenticator;
import de.kapsi.net.daap.DaapConfig;
import de.kapsi.net.daap.DaapConnection;
import de.kapsi.net.daap.DaapFilter;
import de.kapsi.net.daap.DaapSession;
import de.kapsi.net.daap.DaapStreamSource;
import de.kapsi.net.daap.DaapThreadFactory;
import de.kapsi.net.daap.Library;
import de.kapsi.net.daap.LibraryListener;
import de.kapsi.net.daap.SessionId;
import java.io.IOException;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class DaapServer<T extends DaapConnection>
implements Runnable,
LibraryListener {
    protected static final Log LOG = LogFactory.getLog(DaapServer.class);
    protected final Library library;
    protected final List<Library> libraryQueue = new ArrayList<Library>();
    protected final Set<SessionId> sessionIds = new HashSet<SessionId>();
    protected final List<T> connections = new LinkedList<T>();
    protected DaapConfig config;
    protected DaapFilter filter;
    protected DaapStreamSource streamSource;
    protected DaapAuthenticator authenticator;
    protected boolean running = false;

    public DaapServer(Library library, DaapConfig config) {
        this.library = library;
        this.config = config;
        library.addLibraryListener(this);
    }

    public Library getLibrary() {
        return this.library;
    }

    @Override
    public synchronized void libraryChanged(Library library, Library branch) {
        if (this.isRunning() && this.getNumberOfDaapConnections() > 0) {
            this.libraryQueue.add(branch);
            this.update();
        }
    }

    public DaapConfig getConfig() {
        return this.config;
    }

    public synchronized void setStreamSource(DaapStreamSource streamSource) {
        this.streamSource = streamSource;
    }

    public synchronized DaapStreamSource getStreamSource() {
        return this.streamSource;
    }

    public synchronized void setFilter(DaapFilter filter) {
        this.filter = filter;
    }

    public synchronized DaapFilter getFilter() {
        return this.filter;
    }

    public synchronized void setAuthenticator(DaapAuthenticator authenticator) {
        this.authenticator = authenticator;
    }

    public synchronized DaapAuthenticator getAuthenticator() {
        return this.authenticator;
    }

    public synchronized void setThreadFactory(DaapThreadFactory factory) {
        throw new UnsupportedOperationException();
    }

    public abstract void bind() throws IOException;

    public synchronized boolean isRunning() {
        return this.running;
    }

    public abstract void stop();

    public abstract void disconnectAll();

    protected abstract void update();

    public synchronized int getNumberOfDaapConnections() {
        return this.getDaapConnections().size();
    }

    public synchronized int getNumberOfAudioConnections() {
        return this.getAudioConnections().size();
    }

    public synchronized int getNumberOfPendingConnections() {
        return this.getPendingConnections().size();
    }

    protected synchronized boolean isSessionIdValid(SessionId sessionId) {
        return !SessionId.INVALID.equals(sessionId) && this.sessionIds.contains(sessionId);
    }

    protected synchronized SessionId createSessionId() {
        SessionId sid = SessionId.createSessionId(this.sessionIds);
        this.sessionIds.add(sid);
        return sid;
    }

    protected synchronized void destroySessionId(SessionId sessionId) {
        this.sessionIds.remove(sessionId);
    }

    protected synchronized boolean accept(InetAddress addr) {
        if (this.filter != null && !this.filter.accept(addr)) {
            if (LOG.isInfoEnabled()) {
                LOG.info((Object)("DaapFilter refused connection from " + addr));
            }
            return false;
        }
        return true;
    }

    protected synchronized void addPendingConnection(T connection) throws IllegalArgumentException {
        if (!((DaapConnection)connection).isUndef()) {
            throw new IllegalArgumentException();
        }
        this.connections.add(connection);
    }

    protected synchronized List<T> getPendingConnections() {
        ArrayList<DaapConnection> list = new ArrayList<DaapConnection>();
        for (DaapConnection connection : this.connections) {
            if (!connection.isUndef()) continue;
            list.add(connection);
        }
        return Collections.unmodifiableList(list);
    }

    protected synchronized List<T> getConnections() {
        return Collections.unmodifiableList(new ArrayList<T>(this.connections));
    }

    protected synchronized List<T> getDaapConnections() {
        ArrayList<DaapConnection> list = new ArrayList<DaapConnection>();
        for (DaapConnection connection : this.connections) {
            if (!connection.isDaapConnection()) continue;
            list.add(connection);
        }
        return Collections.unmodifiableList(list);
    }

    protected synchronized List<T> getAudioConnections() {
        ArrayList<DaapConnection> list = new ArrayList<DaapConnection>();
        for (DaapConnection connection : this.connections) {
            if (!connection.isAudioStream()) continue;
            list.add(connection);
        }
        return Collections.unmodifiableList(list);
    }

    protected synchronized boolean updateConnection(T connection) {
        if (((DaapConnection)connection).isDaapConnection()) {
            return this.getDaapConnections().size() < this.config.getMaxConnections();
        }
        if (((DaapConnection)connection).isAudioStream()) {
            return this.getAudioConnections().size() < this.config.getMaxConnections();
        }
        return false;
    }

    protected synchronized void removeConnection(DaapConnection connection) throws IllegalStateException {
        if (!this.connections.remove(connection)) {
            throw new IllegalStateException();
        }
    }

    protected synchronized T getDaapConnection(SessionId sessionId) {
        for (DaapConnection connection : this.connections) {
            DaapSession session = connection.getSession(false);
            if (session == null || !connection.isDaapConnection() || !sessionId.equals(session.getSessionId())) continue;
            return (T)connection;
        }
        return null;
    }

    protected synchronized T getAudioConnection(SessionId sessionId) {
        for (DaapConnection connection : this.connections) {
            DaapSession session = connection.getSession(false);
            if (session == null || !connection.isAudioStream() || !sessionId.equals(session.getSessionId())) continue;
            return (T)connection;
        }
        return null;
    }

    protected synchronized void clear() {
        this.connections.clear();
        this.sessionIds.clear();
        this.libraryQueue.clear();
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("Name: ").append(this.config.getServerName()).append("\n");
        buffer.append("Address: ").append(this.config.getInetSocketAddress()).append("\n");
        buffer.append("Backlog: ").append(this.config.getBacklog()).append("\n");
        buffer.append("Max connections: ").append(this.config.getMaxConnections()).append("\n");
        buffer.append("IsRunning: ").append(this.isRunning()).append("\n");
        if (this.isRunning()) {
            buffer.append("Connections: ").append(this.getNumberOfDaapConnections()).append("\n");
            buffer.append("Streams: ").append(this.getNumberOfAudioConnections()).append("\n");
        }
        return buffer.toString();
    }
}

