/*
 * Decompiled with CFR 0.152.
 */
package test.net.sourceforge.pmd.rules;

import net.sourceforge.pmd.cpd.CPD;
import net.sourceforge.pmd.rules.UnusedPrivateMethodRule;
import test.net.sourceforge.pmd.rules.SimpleAggregatorTst;
import test.net.sourceforge.pmd.rules.TestDescriptor;

public class UnusedPrivateMethodRuleTest
extends SimpleAggregatorTst {
    private UnusedPrivateMethodRule rule;
    private static final String TEST1 = "public class Foo {" + CPD.EOL + " public void bar() {" + CPD.EOL + "  foo();" + CPD.EOL + " }" + CPD.EOL + " private void foo() {}" + CPD.EOL + "}";
    private static final String TEST2 = "public class Foo {" + CPD.EOL + " private void foo() {}" + CPD.EOL + "}";
    private static final String TEST3 = "public class Foo {" + CPD.EOL + " public void bar() {" + CPD.EOL + "  new Runnable() {" + CPD.EOL + "   public void run() {" + CPD.EOL + "    foo();" + CPD.EOL + "   }" + CPD.EOL + "  };" + CPD.EOL + " }" + CPD.EOL + "" + CPD.EOL + " private void foo() {}" + CPD.EOL + "}";
    private static final String TEST4 = "public class Foo {" + CPD.EOL + " private void foo() {}" + CPD.EOL + " private void foo(String baz) {}" + CPD.EOL + " public void bar() {" + CPD.EOL + "  foo();" + CPD.EOL + " }" + CPD.EOL + "}";
    private static final String TEST5 = "public class Foo {" + CPD.EOL + " private void foo(String[] args) {}" + CPD.EOL + " public static void main(String[] args) {" + CPD.EOL + "  Foo u = new Foo();" + CPD.EOL + "  u.foo(args); " + CPD.EOL + " }" + CPD.EOL + "}";
    private static final String TEST6 = "public class Foo {" + CPD.EOL + " public void bar() {" + CPD.EOL + "  this.foo();" + CPD.EOL + " }" + CPD.EOL + " private void foo() {}" + CPD.EOL + "}";
    private static final String TEST7 = "public class Foo {" + CPD.EOL + " private static void foo() {}" + CPD.EOL + "}";

    public void setUp() {
        this.rule = new UnusedPrivateMethodRule();
        this.rule.setMessage("Avoid this stuff -> ''{0}''");
    }

    public void testAll() {
        this.runTests(new TestDescriptor[]{new TestDescriptor(TEST1, "private method called by public method", 0, this.rule), new TestDescriptor(TEST2, "simple unused private method", 1, this.rule), new TestDescriptor(TEST3, "anonymous inner class calls private method", 0, this.rule), new TestDescriptor(TEST4, "two private methods with same name but different parameters", 1, this.rule), new TestDescriptor(TEST5, "calling private method after instantiating new copy of myself", 0, this.rule), new TestDescriptor(TEST6, "calling private method using 'this' modifier", 0, this.rule), new TestDescriptor(TEST7, "simple unused private static method", 1, this.rule)});
    }
}

