/*
 * Decompiled with CFR 0.152.
 */
package test.net.sourceforge.pmd.rules;

import net.sourceforge.pmd.Rule;
import net.sourceforge.pmd.cpd.CPD;
import net.sourceforge.pmd.rules.BeanMembersShouldSerializeRule;
import test.net.sourceforge.pmd.rules.SimpleAggregatorTst;
import test.net.sourceforge.pmd.rules.TestDescriptor;

public class BeanMembersShouldSerializeRuleTest
extends SimpleAggregatorTst {
    private Rule rule;
    private static final String TEST1 = "public class Foo {" + CPD.EOL + " private String foo;" + CPD.EOL + " private String bar = foo;" + CPD.EOL + "}";
    private static final String TEST2 = "public class Foo {" + CPD.EOL + " private static String foo;" + CPD.EOL + " private String bar = Foo.foo;" + CPD.EOL + "}";
    private static final String TEST3 = "public class Foo {" + CPD.EOL + " private transient String foo;" + CPD.EOL + " private String bar = Foo.foo;" + CPD.EOL + "}";
    private static final String TEST4 = "public class Foo {" + CPD.EOL + " private String foo;" + CPD.EOL + " private String bar = Foo.foo;" + CPD.EOL + " public String getFoo() {return foo;}" + CPD.EOL + "}";
    private static final String TEST5 = "public class Foo {" + CPD.EOL + " private String foo;" + CPD.EOL + " private String bar = Foo.foo;" + CPD.EOL + " public void setFoo(Foo foo) {this.foo = foo;}" + CPD.EOL + "}";
    private static final String TEST6 = "public class Foo {" + CPD.EOL + " private String foo;" + CPD.EOL + " private String bar = Foo.foo;" + CPD.EOL + " public void setFoo(Foo foo) {this.foo = foo;}" + CPD.EOL + " public String getFoo() {return foo;}" + CPD.EOL + "}";

    public void setUp() {
        this.rule = new BeanMembersShouldSerializeRule();
        this.rule.setMessage("Don't {0} !");
    }

    public void testAll() {
        this.runTests(new TestDescriptor[]{new TestDescriptor(TEST1, "private String, no accessor", 1, this.rule), new TestDescriptor(TEST2, "private static String", 0, this.rule), new TestDescriptor(TEST3, "private transient String", 0, this.rule), new TestDescriptor(TEST4, "getter, no setter", 1, this.rule), new TestDescriptor(TEST5, "setter, no getter", 1, this.rule), new TestDescriptor(TEST6, "both accessors, yay!", 0, this.rule)});
    }
}

