/*
 * Decompiled with CFR 0.152.
 */
package test.net.sourceforge.pmd.rules;

import net.sourceforge.pmd.cpd.CPD;
import net.sourceforge.pmd.rules.AvoidReassigningParametersRule;
import test.net.sourceforge.pmd.rules.RuleTst;

public class AvoidReassigningParametersRuleTest
extends RuleTst {
    public static final String TEST1 = "public class AvoidReassigningParameters1 {" + CPD.EOL + " private void foo(String bar) {" + CPD.EOL + "  bar = \"something else\";" + CPD.EOL + " }" + CPD.EOL + "}";
    public static final String TEST2 = "public class AvoidReassigningParameters2 {" + CPD.EOL + " private void foo(String bar) {}" + CPD.EOL + "}";
    public static final String TEST3 = "public class AvoidReassigningParameters3 {" + CPD.EOL + " private int bar;" + CPD.EOL + " private void foo(String bar) {" + CPD.EOL + "  bar = \"hi\";" + CPD.EOL + " }" + CPD.EOL + "}";
    public static final String TEST4 = "public class AvoidReassigningParameters4 {" + CPD.EOL + " private int bar;" + CPD.EOL + " private void foo(String bar) {" + CPD.EOL + "  this.bar = \"hi\";" + CPD.EOL + " }" + CPD.EOL + "}";
    public static final String TEST5 = "public class AvoidReassigningParameters5 {" + CPD.EOL + "" + CPD.EOL + " private class Foo {" + CPD.EOL + "  public String bar;" + CPD.EOL + " }" + CPD.EOL + "" + CPD.EOL + " private void foo(String bar) {" + CPD.EOL + "  Foo f = new Foo();" + CPD.EOL + "  f.bar = bar;" + CPD.EOL + " }" + CPD.EOL + "}";
    public static final String TEST6 = "import java.awt.*;" + CPD.EOL + "" + CPD.EOL + "public class AvoidReassigningParameters6 {" + CPD.EOL + " private void foo(GridBagConstraints gbc) {" + CPD.EOL + "  gbc.gridx = 2;" + CPD.EOL + " }" + CPD.EOL + "}";
    private AvoidReassigningParametersRule rule;

    public void setUp() {
        this.rule = new AvoidReassigningParametersRule();
        this.rule.setMessage("Avoid this stuff -> ''{0}''");
    }

    public void testSimple() throws Throwable {
        this.runTestFromString(TEST1, 1, this.rule);
    }

    public void testNoUsage() throws Throwable {
        this.runTestFromString(TEST2, 0, this.rule);
    }

    public void testInstanceVarSameNameAsParam() throws Throwable {
        this.runTestFromString(TEST3, 1, this.rule);
    }

    public void testQualifiedNameInstanceVarSameAsParam() throws Throwable {
        this.runTestFromString(TEST4, 0, this.rule);
    }

    public void testQualifiedNameSameAsParam() throws Throwable {
        this.runTestFromString(TEST5, 0, this.rule);
    }

    public void testAssignmentToParametersField() throws Throwable {
        this.runTestFromString(TEST6, 0, this.rule);
    }
}

