/*
 * Decompiled with CFR 0.152.
 */
package test.net.sourceforge.pmd.renderers;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import junit.framework.Assert;
import junit.framework.TestCase;
import net.sourceforge.pmd.Report;
import net.sourceforge.pmd.RuleContext;
import net.sourceforge.pmd.RuleViolation;
import net.sourceforge.pmd.renderers.XMLRenderer;
import test.net.sourceforge.pmd.MockRule;

public class XMLRendererTest
extends TestCase {
    private XMLRenderer IUT = null;
    private MockRule RULE1 = new MockRule("RULE1", "RULE1", "msg");
    private MockRule RULE2 = new MockRule("RULE2", "RULE2", "msg");
    private RuleContext ctx = new RuleContext();

    public XMLRendererTest(String name) {
        super(name);
    }

    public void setUp() {
        this.IUT = new XMLRenderer();
    }

    public void testEmptyReport() throws Throwable {
        String rendered = this.IUT.render(new Report());
        Assert.assertTrue((String)"Expected empty PMD tag.", (rendered.indexOf("violation") < 0 ? 1 : 0) != 0);
    }

    public void testSingleReport() throws Throwable {
        Report report = new Report();
        this.ctx.setSourceCodeFilename("testSingleReport");
        report.addRuleViolation(new RuleViolation(this.RULE1, 1, "Rule1", this.ctx));
        String rendered = this.IUT.render(report);
        ArrayList<String> expectedStrings = new ArrayList<String>();
        expectedStrings.add("<pmd>");
        expectedStrings.add("<file name=\"testSingleReport\">");
        expectedStrings.add("<violation line=\"1\" rule=\"RULE1\">");
        expectedStrings.add("Rule1");
        expectedStrings.add("</violation>");
        expectedStrings.add("</file>");
        expectedStrings.add("</pmd>");
        this.verifyPositions(rendered, expectedStrings);
    }

    public void testDoubleReport() throws Throwable {
        Report report = new Report();
        this.ctx.setSourceCodeFilename("testDoubleReport");
        report.addRuleViolation(new RuleViolation(this.RULE1, 1, "Rule1", this.ctx));
        report.addRuleViolation(new RuleViolation(this.RULE2, 2, "Rule2", this.ctx));
        String rendered = this.IUT.render(report);
        ArrayList<String> expectedStrings = new ArrayList<String>();
        expectedStrings.add("<pmd>");
        expectedStrings.add("<file name=\"testDoubleReport\">");
        expectedStrings.add("<violation line=\"1\" rule=\"RULE1\">");
        expectedStrings.add("Rule1");
        expectedStrings.add("</violation>");
        expectedStrings.add("<violation line=\"2\" rule=\"RULE2\">");
        expectedStrings.add("Rule2");
        expectedStrings.add("</violation>");
        expectedStrings.add("</file>");
        expectedStrings.add("</pmd>");
        this.verifyPositions(rendered, expectedStrings);
    }

    public void testTwoFiles() throws Throwable {
        Report report = new Report();
        this.ctx.setSourceCodeFilename("testTwoFiles_0");
        report.addRuleViolation(new RuleViolation(this.RULE1, 1, "Rule1", this.ctx));
        this.ctx.setSourceCodeFilename("testTwoFiles_1");
        report.addRuleViolation(new RuleViolation(this.RULE1, 1, "Rule1", this.ctx));
        String rendered = this.IUT.render(report);
        ArrayList<String> expectedStrings = new ArrayList<String>();
        expectedStrings.add("<pmd>");
        expectedStrings.add("<file name=\"testTwoFiles_0\">");
        expectedStrings.add("<violation line=\"1\" rule=\"RULE1\">");
        expectedStrings.add("Rule1");
        expectedStrings.add("</violation>");
        expectedStrings.add("</file>");
        expectedStrings.add("<file name=\"testTwoFiles_1\">");
        expectedStrings.add("<violation line=\"1\" rule=\"RULE1\">");
        expectedStrings.add("Rule1");
        expectedStrings.add("</violation>");
        expectedStrings.add("</file>");
        expectedStrings.add("</pmd>");
        this.verifyPositions(rendered, expectedStrings);
    }

    public void testUnorderedFiles() throws Throwable {
        Report report = new Report();
        this.ctx.setSourceCodeFilename("testTwoFiles_0");
        report.addRuleViolation(new RuleViolation(this.RULE1, 1, "Rule1", this.ctx));
        this.ctx.setSourceCodeFilename("testTwoFiles_1");
        report.addRuleViolation(new RuleViolation(this.RULE1, 1, "Rule1", this.ctx));
        this.ctx.setSourceCodeFilename("testTwoFiles_0");
        report.addRuleViolation(new RuleViolation(this.RULE2, 2, "Rule2", this.ctx));
        String rendered = this.IUT.render(report);
        ArrayList<String> expectedStrings = new ArrayList<String>();
        expectedStrings.add("<pmd>");
        expectedStrings.add("<file name=\"testTwoFiles_0\">");
        expectedStrings.add("<violation line=\"1\" rule=\"RULE1\">");
        expectedStrings.add("Rule1");
        expectedStrings.add("</violation>");
        expectedStrings.add("<violation line=\"2\" rule=\"RULE2\">");
        expectedStrings.add("Rule2");
        expectedStrings.add("</violation>");
        expectedStrings.add("</file>");
        expectedStrings.add("<file name=\"testTwoFiles_1\">");
        expectedStrings.add("<violation line=\"1\" rule=\"RULE1\">");
        expectedStrings.add("Rule1");
        expectedStrings.add("</violation>");
        expectedStrings.add("</file>");
        expectedStrings.add("</pmd>");
        this.verifyPositions(rendered, expectedStrings);
    }

    public void verifyPositions(String rendered, List strings) {
        Iterator i = strings.iterator();
        int currPos = 0;
        String lastString = "<?xml version=\"1.0\"?>";
        while (i.hasNext()) {
            String str = (String)i.next();
            int strPos = rendered.indexOf(str, currPos);
            Assert.assertTrue((String)("Expecting: " + str + " after " + lastString), (strPos > currPos ? 1 : 0) != 0);
            currPos = strPos;
            lastString = str;
        }
    }
}

