/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.symboltable;

import java.util.HashSet;
import java.util.Set;
import net.sourceforge.pmd.ast.Node;
import net.sourceforge.pmd.ast.SimpleNode;
import net.sourceforge.pmd.symboltable.ClassScope;
import net.sourceforge.pmd.symboltable.GlobalScope;
import net.sourceforge.pmd.symboltable.LocalScope;
import net.sourceforge.pmd.symboltable.MethodScope;
import net.sourceforge.pmd.symboltable.Scope;

public class ScopeFactory {
    private Set localTriggers = new HashSet();
    private Set methodTriggers = new HashSet();
    private Set classTriggers = new HashSet();
    private Set globalTriggers = new HashSet();
    static /* synthetic */ Class class$net$sourceforge$pmd$ast$ASTBlock;
    static /* synthetic */ Class class$net$sourceforge$pmd$ast$ASTTryStatement;
    static /* synthetic */ Class class$net$sourceforge$pmd$ast$ASTForStatement;
    static /* synthetic */ Class class$net$sourceforge$pmd$ast$ASTSwitchStatement;
    static /* synthetic */ Class class$net$sourceforge$pmd$ast$ASTIfStatement;
    static /* synthetic */ Class class$net$sourceforge$pmd$ast$ASTConstructorDeclaration;
    static /* synthetic */ Class class$net$sourceforge$pmd$ast$ASTMethodDeclaration;
    static /* synthetic */ Class class$net$sourceforge$pmd$ast$ASTUnmodifiedClassDeclaration;
    static /* synthetic */ Class class$net$sourceforge$pmd$ast$ASTUnmodifiedInterfaceDeclaration;
    static /* synthetic */ Class class$net$sourceforge$pmd$ast$ASTCompilationUnit;

    public ScopeFactory() {
        this.initScopeTriggers();
    }

    public Scope createScope(Node node) {
        if (this.localTriggers.contains(node.getClass())) {
            return new LocalScope();
        }
        if (this.methodTriggers.contains(node.getClass())) {
            return new MethodScope();
        }
        if (this.classTriggers.contains(node.getClass())) {
            return new ClassScope(((SimpleNode)node).getImage());
        }
        if (this.globalTriggers.contains(node.getClass())) {
            return new GlobalScope();
        }
        throw new RuntimeException("Can't find an appropriate scope for node of class " + node.getClass());
    }

    private void initScopeTriggers() {
        this.localTriggers.add(class$net$sourceforge$pmd$ast$ASTBlock == null ? (class$net$sourceforge$pmd$ast$ASTBlock = ScopeFactory.class$("net.sourceforge.pmd.ast.ASTBlock")) : class$net$sourceforge$pmd$ast$ASTBlock);
        this.localTriggers.add(class$net$sourceforge$pmd$ast$ASTTryStatement == null ? (class$net$sourceforge$pmd$ast$ASTTryStatement = ScopeFactory.class$("net.sourceforge.pmd.ast.ASTTryStatement")) : class$net$sourceforge$pmd$ast$ASTTryStatement);
        this.localTriggers.add(class$net$sourceforge$pmd$ast$ASTForStatement == null ? (class$net$sourceforge$pmd$ast$ASTForStatement = ScopeFactory.class$("net.sourceforge.pmd.ast.ASTForStatement")) : class$net$sourceforge$pmd$ast$ASTForStatement);
        this.localTriggers.add(class$net$sourceforge$pmd$ast$ASTSwitchStatement == null ? (class$net$sourceforge$pmd$ast$ASTSwitchStatement = ScopeFactory.class$("net.sourceforge.pmd.ast.ASTSwitchStatement")) : class$net$sourceforge$pmd$ast$ASTSwitchStatement);
        this.localTriggers.add(class$net$sourceforge$pmd$ast$ASTIfStatement == null ? (class$net$sourceforge$pmd$ast$ASTIfStatement = ScopeFactory.class$("net.sourceforge.pmd.ast.ASTIfStatement")) : class$net$sourceforge$pmd$ast$ASTIfStatement);
        this.methodTriggers.add(class$net$sourceforge$pmd$ast$ASTConstructorDeclaration == null ? (class$net$sourceforge$pmd$ast$ASTConstructorDeclaration = ScopeFactory.class$("net.sourceforge.pmd.ast.ASTConstructorDeclaration")) : class$net$sourceforge$pmd$ast$ASTConstructorDeclaration);
        this.methodTriggers.add(class$net$sourceforge$pmd$ast$ASTMethodDeclaration == null ? (class$net$sourceforge$pmd$ast$ASTMethodDeclaration = ScopeFactory.class$("net.sourceforge.pmd.ast.ASTMethodDeclaration")) : class$net$sourceforge$pmd$ast$ASTMethodDeclaration);
        this.classTriggers.add(class$net$sourceforge$pmd$ast$ASTUnmodifiedClassDeclaration == null ? (class$net$sourceforge$pmd$ast$ASTUnmodifiedClassDeclaration = ScopeFactory.class$("net.sourceforge.pmd.ast.ASTUnmodifiedClassDeclaration")) : class$net$sourceforge$pmd$ast$ASTUnmodifiedClassDeclaration);
        this.classTriggers.add(class$net$sourceforge$pmd$ast$ASTUnmodifiedInterfaceDeclaration == null ? (class$net$sourceforge$pmd$ast$ASTUnmodifiedInterfaceDeclaration = ScopeFactory.class$("net.sourceforge.pmd.ast.ASTUnmodifiedInterfaceDeclaration")) : class$net$sourceforge$pmd$ast$ASTUnmodifiedInterfaceDeclaration);
        this.globalTriggers.add(class$net$sourceforge$pmd$ast$ASTCompilationUnit == null ? (class$net$sourceforge$pmd$ast$ASTCompilationUnit = ScopeFactory.class$("net.sourceforge.pmd.ast.ASTCompilationUnit")) : class$net$sourceforge$pmd$ast$ASTCompilationUnit);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

