/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.swingui;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.List;
import java.util.Set;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import net.sourceforge.pmd.PMDException;
import net.sourceforge.pmd.Rule;
import net.sourceforge.pmd.RuleProperties;
import net.sourceforge.pmd.RuleSet;
import net.sourceforge.pmd.swingui.RulesTreeNode;
import net.sourceforge.pmd.swingui.event.ListenerList;
import net.sourceforge.pmd.swingui.event.PMDDirectoryRequestEvent;
import net.sourceforge.pmd.swingui.event.PMDDirectoryReturnedEvent;
import net.sourceforge.pmd.swingui.event.PMDDirectoryReturnedEventListener;
import net.sourceforge.pmd.swingui.event.RulesTreeModelEvent;
import net.sourceforge.pmd.swingui.event.RulesTreeModelEventListener;

class RulesTreeModel
extends DefaultTreeModel {
    private PMDDirectoryReturnedEventHandler m_pmdDirectoryReturnedEventHandler = new PMDDirectoryReturnedEventHandler();
    private RulesTreeModelEventHandler m_rulesTreeModelEventHandler = new RulesTreeModelEventHandler();
    private static RulesTreeModel m_rulesTreeModel;

    private RulesTreeModel(RulesTreeNode rootNode) {
        super(rootNode);
        ListenerList.addListener(this.m_pmdDirectoryReturnedEventHandler);
    }

    protected RulesTreeNode getRuleSetNode(String ruleSetName) {
        if (ruleSetName != null) {
            RulesTreeNode rootNode = (RulesTreeNode)this.getRoot();
            Enumeration<TreeNode> ruleSetNodes = rootNode.children();
            while (ruleSetNodes.hasMoreElements()) {
                RulesTreeNode ruleSetNode = (RulesTreeNode)ruleSetNodes.nextElement();
                if (!ruleSetNode.getName().equalsIgnoreCase(ruleSetName)) continue;
                return ruleSetNode;
            }
        }
        return null;
    }

    protected RulesTreeNode getRuleNode(String ruleSetName, String ruleName) {
        if (ruleSetName != null && ruleName != null) {
            RulesTreeNode rootNode = (RulesTreeNode)this.getRoot();
            Enumeration<TreeNode> ruleSetNodes = rootNode.children();
            while (ruleSetNodes.hasMoreElements()) {
                RulesTreeNode ruleSetNode = (RulesTreeNode)ruleSetNodes.nextElement();
                if (!ruleSetNode.getName().equalsIgnoreCase(ruleSetName)) continue;
                Enumeration<TreeNode> ruleNodes = ruleSetNode.children();
                while (ruleNodes.hasMoreElements()) {
                    RulesTreeNode ruleNode = (RulesTreeNode)ruleNodes.nextElement();
                    if (!ruleNode.getName().equalsIgnoreCase(ruleName)) continue;
                    return ruleNode;
                }
            }
        }
        return null;
    }

    protected static final RulesTreeModel get() throws PMDException {
        if (m_rulesTreeModel == null) {
            RulesTreeNode rootNode = new RulesTreeNode("Rules");
            m_rulesTreeModel = new RulesTreeModel(rootNode);
            m_rulesTreeModel.buildTree();
        }
        return m_rulesTreeModel;
    }

    private void buildTree() throws PMDException {
        RuleSet[] ruleSets = this.loadRuleSets();
        RulesTreeNode rootNode = (RulesTreeNode)this.getRoot();
        int n1 = 0;
        while (n1 < ruleSets.length) {
            RulesTreeNode ruleSetNode = new RulesTreeNode(ruleSets[n1]);
            rootNode.add(ruleSetNode);
            this.loadRuleTreeNodes(ruleSetNode);
            ++n1;
        }
    }

    private RuleSet[] loadRuleSets() throws PMDException {
        PMDDirectoryRequestEvent.notifyRequestAllRuleSets(this);
        ArrayList ruleSetList = this.m_pmdDirectoryReturnedEventHandler.getRuleSetList();
        if (ruleSetList == null) {
            ruleSetList = new ArrayList();
        }
        RuleSet[] ruleSets = new RuleSet[ruleSetList.size()];
        ruleSetList.toArray(ruleSets);
        Arrays.sort(ruleSets, new RuleSetNameComparator());
        return ruleSets;
    }

    private void loadRuleTreeNodes(RulesTreeNode ruleSetNode) {
        RuleSet ruleSet = ruleSetNode.getRuleSet();
        Set setOfRules = ruleSet.getRules();
        Rule[] rules = new Rule[setOfRules.size()];
        setOfRules.toArray(rules);
        Arrays.sort(rules, new RuleNameComparator());
        int n = 0;
        while (n < rules.length) {
            RulesTreeNode ruleNode = new RulesTreeNode(ruleSetNode, rules[n]);
            ruleSetNode.add(ruleNode);
            this.loadProperties(ruleNode);
            rules[n] = null;
            ++n;
        }
    }

    private void loadProperties(RulesTreeNode ruleNode) {
        Rule rule = ruleNode.getRule();
        RuleProperties properties = rule.getProperties();
        String[] propertyNames = new String[properties.size()];
        Enumeration keys = properties.keys();
        int index = 0;
        while (keys.hasMoreElements()) {
            propertyNames[index] = (String)keys.nextElement();
            ++index;
        }
        Arrays.sort(propertyNames, new PropertyNameComparator());
        int n = 0;
        while (n < propertyNames.length) {
            String propertyName = propertyNames[n];
            String propertyValue = properties.getValue(propertyName);
            String propertyValueType = properties.getValueType(propertyName);
            RulesTreeNode propertyNode = new RulesTreeNode(ruleNode, propertyName, propertyValue, propertyValueType);
            ruleNode.add(propertyNode);
            propertyNames[n] = null;
            ++n;
        }
    }

    private class PMDDirectoryReturnedEventHandler
    implements PMDDirectoryReturnedEventListener {
        private List m_ruleSetList;
        private String m_ruleSetPath;

        private PMDDirectoryReturnedEventHandler() {
        }

        private String getRuleSetPath() {
            return this.m_ruleSetPath;
        }

        private List getRuleSetList() {
            return this.m_ruleSetList;
        }

        public void returnedRuleSetPath(PMDDirectoryReturnedEvent event) {
            this.m_ruleSetPath = event.getRuleSetPath();
        }

        public void returnedAllRuleSets(PMDDirectoryReturnedEvent event) {
            this.m_ruleSetList = event.getRuleSetList();
        }

        public void returnedDefaultRuleSets(PMDDirectoryReturnedEvent event) {
            this.m_ruleSetList = event.getRuleSetList();
        }

        public void returnedIncludedRules(PMDDirectoryReturnedEvent event) {
            this.m_ruleSetList = event.getRuleSetList();
        }
    }

    private class RuleNameComparator
    implements Comparator {
        private RuleNameComparator() {
        }

        public int compare(Object objectA, Object objectB) {
            String ruleNameA = ((Rule)objectA).getName();
            String ruleNameB = ((Rule)objectB).getName();
            return ruleNameA.compareToIgnoreCase(ruleNameB);
        }
    }

    private class RuleSetNameComparator
    implements Comparator {
        private RuleSetNameComparator() {
        }

        public int compare(Object objectA, Object objectB) {
            String ruleSetNameA = ((RuleSet)objectA).getName();
            String ruleSetNameB = ((RuleSet)objectB).getName();
            return ruleSetNameA.compareToIgnoreCase(ruleSetNameB);
        }
    }

    private class PropertyNameComparator
    implements Comparator {
        private PropertyNameComparator() {
        }

        public int compare(Object objectA, Object objectB) {
            String propertyNameA = (String)objectA;
            String propertyNameB = (String)objectB;
            return propertyNameA.compareToIgnoreCase(propertyNameB);
        }
    }

    private class RulesTreeModelEventHandler
    implements RulesTreeModelEventListener {
        private RulesTreeModelEventHandler() {
            ListenerList.addListener(this);
        }

        public void reload(RulesTreeModelEvent event) {
            RulesTreeNode parentNode = event.getParentNode();
            RulesTreeModel.this.reload(parentNode);
        }

        public void requestSelectedRule(RulesTreeModelEvent event) {
        }

        public void returnedSelectedRule(RulesTreeModelEvent event) {
        }
    }
}

