/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.swingui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.text.MessageFormat;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;
import net.sourceforge.pmd.swingui.ComponentFactory;
import net.sourceforge.pmd.swingui.Constants;
import net.sourceforge.pmd.swingui.MessageDialog;
import net.sourceforge.pmd.swingui.RulesTreeNode;
import net.sourceforge.pmd.swingui.event.ListenerList;
import net.sourceforge.pmd.swingui.event.RulesEditingEvent;
import net.sourceforge.pmd.swingui.event.RulesEditingEventListener;

class RulePropertyEditingPanel
extends JPanel
implements Constants {
    private JLabel m_nameLabel;
    private JTextField m_name;
    private JLabel m_valueLabel;
    private JTextField m_value;
    private JLabel m_valueTypeLabel;
    private JComboBox m_valueType;
    private boolean m_enabled;
    private RulesTreeNode m_currentDataNode;
    private boolean m_isEditing;
    private String m_originalName;
    private String m_originalValue;
    private FocusListener m_focusListener = new PropertyNameFocusListener();

    protected RulePropertyEditingPanel() {
        super(new BorderLayout());
        EmptyBorder emptyBorder = new EmptyBorder(5, 5, 5, 5);
        this.setBorder(emptyBorder);
        int[] columnWidths = new int[]{50, 100, 100};
        GridBagLayout layout = new GridBagLayout();
        layout.columnWidths = columnWidths;
        JPanel panel = new JPanel(layout);
        TitledBorder titledBorder = ComponentFactory.createTitledBorder("  Property  ");
        panel.setBorder(titledBorder);
        this.add((Component)panel, "Center");
        this.m_nameLabel = new JLabel("Name");
        this.m_nameLabel.setFont(UIManager.getFont("labelFont"));
        this.m_nameLabel.setHorizontalAlignment(4);
        GridBagConstraints constraints = layout.getConstraints(this.m_nameLabel);
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.anchor = 12;
        constraints.fill = 0;
        constraints.insets = new Insets(4, 2, 4, 2);
        panel.add((Component)this.m_nameLabel, constraints);
        this.m_name = new JTextField();
        this.m_name.setFont(UIManager.getFont("dataFont"));
        this.m_name.addFocusListener(this.m_focusListener);
        this.m_name.setRequestFocusEnabled(true);
        constraints = layout.getConstraints(this.m_name);
        constraints.gridx = 1;
        constraints.gridy = 0;
        constraints.gridwidth = 0;
        constraints.gridheight = 1;
        constraints.anchor = 18;
        constraints.fill = 1;
        constraints.insets = new Insets(4, 2, 4, 2);
        panel.add((Component)this.m_name, constraints);
        this.m_valueLabel = new JLabel("Value");
        this.m_valueLabel.setFont(UIManager.getFont("labelFont"));
        this.m_valueLabel.setHorizontalAlignment(4);
        constraints = layout.getConstraints(this.m_nameLabel);
        constraints.gridx = 0;
        constraints.gridy = 1;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.anchor = 12;
        constraints.fill = 0;
        constraints.insets = new Insets(4, 2, 4, 2);
        panel.add((Component)this.m_valueLabel, constraints);
        this.m_value = new JTextField();
        this.m_value.setFont(UIManager.getFont("dataFont"));
        this.m_value.setOpaque(true);
        constraints = layout.getConstraints(this.m_name);
        constraints.gridx = 1;
        constraints.gridy = 1;
        constraints.gridwidth = 0;
        constraints.gridheight = 1;
        constraints.anchor = 18;
        constraints.fill = 1;
        constraints.insets = new Insets(4, 2, 4, 2);
        panel.add((Component)this.m_value, constraints);
        this.m_valueTypeLabel = new JLabel("Type");
        this.m_valueTypeLabel.setFont(UIManager.getFont("labelFont"));
        this.m_valueTypeLabel.setHorizontalAlignment(4);
        constraints.gridx = 0;
        constraints.gridy = 2;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.anchor = 12;
        constraints.fill = 0;
        constraints.insets = new Insets(4, 2, 4, 2);
        panel.add((Component)this.m_valueTypeLabel, constraints);
        String[] items = new String[]{"String", "Boolean", "Decimal Number", "Integer"};
        this.m_valueType = new JComboBox<String>(items);
        this.m_valueType.setEditable(false);
        this.m_valueType.setOpaque(true);
        constraints = layout.getConstraints(this.m_name);
        constraints.gridx = 1;
        constraints.gridy = 2;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.anchor = 18;
        constraints.fill = 1;
        constraints.insets = new Insets(4, 2, 4, 2);
        panel.add((Component)this.m_valueType, constraints);
        this.enableData(false);
        ListenerList.addListener(new RulesEditingEventHandler());
    }

    private void saveData(RulesTreeNode dataNode) {
        if (dataNode != null && this.m_isEditing && dataNode.isProperty()) {
            String propertyName = this.m_name.getText();
            if (!propertyName.equalsIgnoreCase(this.m_originalName) && dataNode.getSibling(propertyName) != null) {
                String template = "Another property already has the name \"{0}\".  The change will not be applied.";
                Object[] args = new String[]{propertyName};
                String message = MessageFormat.format(template, args);
                boolean hasFocus = this.m_name.hasFocus();
                this.m_name.removeFocusListener(this.m_focusListener);
                MessageDialog.show(this.getParentWindow(), message);
                this.m_name.addFocusListener(this.m_focusListener);
                if (hasFocus) {
                    this.m_name.requestFocus();
                }
                propertyName = this.m_originalName;
            }
            String valueText = this.m_value.getText();
            String selectedItem = (String)this.m_valueType.getSelectedItem();
            if (selectedItem.equalsIgnoreCase("Boolean")) {
                valueText = this.saveBoolean(valueText);
            } else if (selectedItem.equalsIgnoreCase("Decimal Number")) {
                valueText = this.saveDecimalNumber(valueText);
            } else if (selectedItem.equalsIgnoreCase("Integer")) {
                valueText = this.saveInteger(valueText);
            }
            dataNode.setName(propertyName);
            dataNode.setPropertyValue(valueText);
            dataNode.setPropertyValueType(selectedItem);
        }
    }

    private String saveBoolean(String valueText) {
        boolean originalValue;
        try {
            originalValue = Boolean.getBoolean(this.m_originalValue);
        }
        catch (NumberFormatException exception) {
            originalValue = true;
        }
        try {
            boolean newValue = Boolean.getBoolean(valueText);
            valueText = String.valueOf(newValue);
        }
        catch (NumberFormatException exception) {
            String template = "New property of \"{0}\" is not a boolean.  The change will not be applied.";
            Object[] args = new String[]{valueText};
            String message = MessageFormat.format(template, args);
            this.m_name.removeFocusListener(this.m_focusListener);
            MessageDialog.show(this.getParentWindow(), message);
            this.m_name.addFocusListener(this.m_focusListener);
            boolean newValue = originalValue;
            valueText = this.m_originalValue;
        }
        return valueText;
    }

    private String saveDecimalNumber(String valueText) {
        double originalValue;
        try {
            originalValue = Double.parseDouble(this.m_originalValue);
        }
        catch (NumberFormatException exception) {
            originalValue = 0.0;
        }
        try {
            double newValue = Double.parseDouble(valueText);
            valueText = String.valueOf(newValue);
        }
        catch (NumberFormatException exception) {
            String template = "New property of \"{0}\" is not a decimal number.  The change will not be applied.";
            Object[] args = new String[]{valueText};
            String message = MessageFormat.format(template, args);
            this.m_name.removeFocusListener(this.m_focusListener);
            MessageDialog.show(this.getParentWindow(), message);
            this.m_name.addFocusListener(this.m_focusListener);
            double newValue = originalValue;
            valueText = this.m_originalValue;
        }
        return valueText;
    }

    private String saveInteger(String valueText) {
        int originalValue;
        try {
            originalValue = Integer.parseInt(this.m_originalValue);
        }
        catch (NumberFormatException exception) {
            originalValue = 0;
        }
        try {
            int newValue = Integer.parseInt(valueText);
            valueText = String.valueOf(newValue);
        }
        catch (NumberFormatException exception) {
            String template = "New property of \"{0}\" is not an integer.  The change will not be applied.";
            Object[] args = new String[]{valueText};
            String message = MessageFormat.format(template, args);
            this.m_name.removeFocusListener(this.m_focusListener);
            MessageDialog.show(this.getParentWindow(), message);
            this.m_name.addFocusListener(this.m_focusListener);
            int newValue = originalValue;
            valueText = this.m_originalValue;
        }
        return valueText;
    }

    protected void setIsEditing(boolean isEditing) {
        this.m_isEditing = isEditing;
    }

    private void loadData(RulesTreeNode dataNode) {
        if (dataNode == null) {
            this.enableData(false);
        } else if (dataNode.isRuleSet()) {
            this.enableData(false);
        } else if (dataNode.isRule()) {
            this.enableData(false);
        } else if (dataNode.isProperty()) {
            this.loadData_(dataNode);
        } else {
            this.enableData(false);
        }
    }

    private void loadData_(RulesTreeNode dataNode) {
        if (!this.m_enabled) {
            this.enableData(true);
        }
        String name = dataNode.getName();
        String valueType = dataNode.getPropertyValueType();
        this.m_name.setText(name);
        this.m_value.setText(dataNode.getPropertyValue());
        this.m_valueType.setSelectedItem(valueType);
        this.m_originalName = name;
        this.m_originalValue = valueType;
        this.m_currentDataNode = dataNode;
    }

    private void enableData(boolean enable) {
        if (enable) {
            this.m_name.removeFocusListener(this.m_focusListener);
            this.m_name.addFocusListener(this.m_focusListener);
            this.m_nameLabel.setEnabled(true);
            this.m_name.setEnabled(true);
            this.m_name.setBackground(Color.white);
            this.m_valueLabel.setEnabled(true);
            this.m_value.setEnabled(true);
            this.m_value.setBackground(Color.white);
            this.m_valueTypeLabel.setEnabled(true);
            this.m_valueType.setEnabled(true);
            this.m_valueType.setBackground(Color.white);
        } else {
            this.m_name.removeFocusListener(this.m_focusListener);
            Color background = UIManager.getColor("disabledTextBackground");
            this.m_nameLabel.setEnabled(false);
            this.m_name.setText("");
            this.m_name.setEnabled(false);
            this.m_name.setBackground(background);
            this.m_valueLabel.setEnabled(false);
            this.m_value.setText("");
            this.m_value.setEnabled(false);
            this.m_value.setBackground(background);
            this.m_valueTypeLabel.setEnabled(false);
            this.m_valueType.setSelectedIndex(0);
            this.m_valueType.setEnabled(false);
            this.m_valueType.setBackground(background);
            this.m_currentDataNode = null;
        }
        this.m_enabled = enable;
    }

    private Window getParentWindow() {
        Container component = this.getParent();
        while (component != null && !(component instanceof Window)) {
            component = component.getParent();
        }
        return (Window)component;
    }

    private class RulesEditingEventHandler
    implements RulesEditingEventListener {
        private RulesEditingEventHandler() {
        }

        public void loadData(RulesEditingEvent event) {
            RulePropertyEditingPanel.this.loadData(event.getDataNode());
        }

        public void saveData(RulesEditingEvent event) {
            RulePropertyEditingPanel.this.saveData(event.getDataNode());
        }
    }

    private class PropertyNameFocusListener
    implements FocusListener {
        private PropertyNameFocusListener() {
        }

        public void focusGained(FocusEvent event) {
        }

        public void focusLost(FocusEvent event) {
            String propertyName = RulePropertyEditingPanel.this.m_name.getText().trim();
            if (propertyName.length() == 0) {
                String message = "The property name is missing.";
                RulePropertyEditingPanel.this.m_name.removeFocusListener(this);
                MessageDialog.show(RulePropertyEditingPanel.this.getParentWindow(), message);
                RulePropertyEditingPanel.this.m_name.addFocusListener(this);
                RulePropertyEditingPanel.this.m_name.requestFocus();
            } else if (!propertyName.equalsIgnoreCase(RulePropertyEditingPanel.this.m_originalName) && RulePropertyEditingPanel.this.m_currentDataNode.getSibling(propertyName) != null) {
                String template = "Another property already has the name \"{0}\".";
                Object[] args = new String[]{propertyName};
                String message = MessageFormat.format(template, args);
                RulePropertyEditingPanel.this.m_name.removeFocusListener(this);
                MessageDialog.show(RulePropertyEditingPanel.this.getParentWindow(), message);
                RulePropertyEditingPanel.this.m_name.addFocusListener(this);
                RulePropertyEditingPanel.this.m_name.requestFocus();
            }
        }
    }
}

