/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.swingui;

import java.io.File;
import java.io.FileFilter;
import java.util.Enumeration;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeWillExpandListener;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import net.sourceforge.pmd.swingui.DirectoryTree;
import net.sourceforge.pmd.swingui.DirectoryTreeNode;

class DirectoryTreeModel
extends DefaultTreeModel
implements TreeWillExpandListener {
    private DirectoryTree m_directoryTree;

    protected DirectoryTreeModel(String rootName) {
        super(DirectoryTreeNode.createRootNode(rootName));
    }

    protected void setupFiles(File[] rootFiles) {
        DirectoryTreeNode rootNode = (DirectoryTreeNode)this.getRoot();
        FilesFilter filesFilter = new FilesFilter();
        if (rootFiles != null) {
            int n1 = 0;
            while (n1 < rootFiles.length) {
                File rootFile = rootFiles[n1];
                DirectoryTreeNode fileNode = new DirectoryTreeNode(rootFile);
                rootNode.add(fileNode);
                File[] files = rootFile.listFiles(filesFilter);
                if (files != null) {
                    int n2 = 0;
                    while (n2 < files.length) {
                        fileNode.add(new DirectoryTreeNode(files[n2]));
                        ++n2;
                    }
                }
                ++n1;
            }
        }
    }

    protected void setDirectoryTree(DirectoryTree directoryTree) {
        this.m_directoryTree = directoryTree;
        this.m_directoryTree.addTreeWillExpandListener(this);
    }

    public void treeWillExpand(TreeExpansionEvent event) {
        TreePath treePath = event.getPath();
        DirectoryTreeNode treeNode = (DirectoryTreeNode)treePath.getLastPathComponent();
        Enumeration<TreeNode> children = treeNode.children();
        while (children.hasMoreElements()) {
            DirectoryTreeNode childTreeNode = (DirectoryTreeNode)children.nextElement();
            File directory = (File)childTreeNode.getUserObject();
            File[] files = directory.listFiles(new FilesFilter());
            childTreeNode.removeAllChildren();
            if (files == null) continue;
            int n = 0;
            while (n < files.length) {
                childTreeNode.add(new DirectoryTreeNode(files[n]));
                ++n;
            }
        }
    }

    public void treeWillCollapse(TreeExpansionEvent event) {
        TreePath treePath = event.getPath();
        DirectoryTreeNode treeNode = (DirectoryTreeNode)treePath.getLastPathComponent();
        Enumeration<TreeNode> children = treeNode.children();
        while (children.hasMoreElements()) {
            DirectoryTreeNode childTreeNode = (DirectoryTreeNode)children.nextElement();
            childTreeNode.removeAllChildren();
        }
    }

    private class FilesFilter
    implements FileFilter {
        private FilesFilter() {
        }

        public boolean accept(File file) {
            return file.isDirectory() && !file.isHidden();
        }
    }
}

