/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.swingui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import javax.swing.Icon;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JSplitPane;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import javax.swing.filechooser.FileFilter;
import net.sourceforge.pmd.PMDException;
import net.sourceforge.pmd.swingui.AnalysisResultsViewer;
import net.sourceforge.pmd.swingui.ComponentFactory;
import net.sourceforge.pmd.swingui.DirectoryTable;
import net.sourceforge.pmd.swingui.DirectoryTree;
import net.sourceforge.pmd.swingui.HelpMenu;
import net.sourceforge.pmd.swingui.MessageDialog;
import net.sourceforge.pmd.swingui.PMDViewer;
import net.sourceforge.pmd.swingui.Preferences;
import net.sourceforge.pmd.swingui.PrintAnalysisResults;
import net.sourceforge.pmd.swingui.StatusBar;
import net.sourceforge.pmd.swingui.event.DirectoryTableEvent;
import net.sourceforge.pmd.swingui.event.DirectoryTableEventListener;
import net.sourceforge.pmd.swingui.event.HTMLAnalysisResultsEvent;
import net.sourceforge.pmd.swingui.event.HTMLAnalysisResultsEventListener;
import net.sourceforge.pmd.swingui.event.ListenerList;
import net.sourceforge.pmd.swingui.event.TextAnalysisResultsEvent;
import net.sourceforge.pmd.swingui.event.TextAnalysisResultsEventListener;

class AnalysisViewer
extends JPanel {
    private DirectoryTree m_directoryTree;
    private JLabel m_message;
    private StatusBar m_statusBar;
    private JPanel m_directoryTreePanel;
    private DirectoryTable m_directoryTable;
    private JPanel m_directoryTablePanel;
    private JSplitPane m_directorySplitPane;
    private AnalysisResultsViewer m_resultsViewer;
    private JPanel m_resultsViewerPanel;
    private JSplitPane m_mainSplitPane;
    private JMenuBar m_menuBar;
    private PMDClipboard m_clipboardOwner = new PMDClipboard();
    private JMenuItem m_saveMenuItem;
    private JMenuItem m_saveAsMenuItem;
    private JMenuItem m_printAnalysisMenuItem;
    private JMenuItem m_copyHTMLResultsMenuItem;
    private JMenuItem m_copyTextResultsMenuItem;

    protected AnalysisViewer() {
        super(new BorderLayout());
        this.createStatusBar();
        this.createDirectoryTreePanel();
        this.createDirectoryTablePanel();
        this.createDirectorySplitPane();
        this.createResultsViewer();
        this.createResultsViewerScrollPane();
        this.createMainSplitPane();
        this.createMenuBar();
        this.setMenuBar();
        this.add(this.createContentPanel(10));
    }

    private void createStatusBar() {
        String defaultMessage = "Select a source file to view its analysis below.";
        this.m_statusBar = new StatusBar(defaultMessage);
        EmptyBorder emptyBorder = new EmptyBorder(0, 0, 5, 0);
        CompoundBorder compoundBorder = new CompoundBorder(emptyBorder, this.m_statusBar.getBorder());
        this.m_statusBar.setBorder(compoundBorder);
    }

    private void createDirectoryTreePanel() {
        this.m_directoryTree = new DirectoryTree("File Directories");
        JScrollPane scrollPane = ComponentFactory.createScrollPane(this.m_directoryTree);
        Color background = UIManager.getColor("pmdTreeBackground");
        scrollPane.getViewport().setBackground(background);
        this.m_directoryTreePanel = new JPanel(new BorderLayout());
        this.m_directoryTreePanel.setBorder(this.createTitledBorder(" Directory "));
        this.m_directoryTreePanel.add((Component)scrollPane, "Center");
    }

    private void createDirectoryTablePanel() {
        this.m_directoryTable = new DirectoryTable(this.m_directoryTree, ".java");
        JScrollPane scrollPane = ComponentFactory.createScrollPane(this.m_directoryTable);
        Color background = UIManager.getColor("pmdTableBackground");
        scrollPane.getViewport().setBackground(background);
        this.m_directoryTablePanel = new JPanel(new BorderLayout());
        this.m_directoryTablePanel.setBorder(this.createTitledBorder(" Java Source Code "));
        this.m_directoryTablePanel.add((Component)scrollPane, "Center");
    }

    private void createDirectorySplitPane() {
        this.m_directorySplitPane = ComponentFactory.createHorizontalSplitPane(this.m_directoryTreePanel, this.m_directoryTablePanel);
    }

    private void createResultsViewer() {
        this.m_resultsViewer = new AnalysisResultsViewer();
        this.m_resultsViewer.setSelectionColor(Color.blue);
    }

    private void createResultsViewerScrollPane() {
        JScrollPane scrollPane = ComponentFactory.createScrollPane(this.m_resultsViewer);
        this.m_resultsViewerPanel = new JPanel(new BorderLayout());
        this.m_resultsViewerPanel.setBorder(this.createTitledBorder(" Analysis Results "));
        this.m_resultsViewerPanel.add((Component)scrollPane, "Center");
    }

    private void createMainSplitPane() {
        this.m_mainSplitPane = ComponentFactory.createVerticalSplitPane(this.m_directorySplitPane, this.m_resultsViewerPanel);
    }

    private JPanel createContentPanel(int margin) {
        JPanel contentPanel = new JPanel(new BorderLayout());
        EtchedBorder outsideBorder = new EtchedBorder(0);
        EmptyBorder insideBorder = new EmptyBorder(margin, margin, margin, margin);
        CompoundBorder compoundBorder = new CompoundBorder(outsideBorder, insideBorder);
        contentPanel.setBorder(compoundBorder);
        contentPanel.add((Component)this.m_statusBar, "North");
        contentPanel.add((Component)this.m_mainSplitPane, "Center");
        return contentPanel;
    }

    private TitledBorder createTitledBorder(String title) {
        EtchedBorder etchedBorder = new EtchedBorder(0);
        TitledBorder titledBorder = new TitledBorder(etchedBorder, title);
        Font font = titledBorder.getTitleFont();
        font = new Font(font.getName(), 1, font.getSize());
        titledBorder.setTitleFont(font);
        return titledBorder;
    }

    protected void setDefaultMessage() {
        this.setMessage("Select a source file to view its analysis below.");
    }

    protected void setMessage(String message) {
        if (message == null) {
            message = "";
        }
        this.m_message.setText(message);
    }

    protected void adjustSplitPaneDividerLocation() {
        this.m_mainSplitPane.setDividerLocation(0.4);
        this.m_directorySplitPane.setDividerLocation(0.4);
    }

    private void createMenuBar() {
        this.m_menuBar = new JMenuBar();
        this.m_menuBar.add(new FileMenu());
        this.m_menuBar.add(new EditMenu());
        this.m_menuBar.add(new HelpMenu());
    }

    protected void setMenuBar() {
        PMDViewer.getViewer().setJMenuBar(this.m_menuBar);
    }

    protected void analyze() {
        this.m_resultsViewer.analyze();
    }

    private class PMDClipboard
    implements ClipboardOwner {
        private PMDClipboard() {
        }

        public void lostOwnership(Clipboard clipboard, Transferable contents) {
        }
    }

    private class HTMLFileFilter
    extends FileFilter {
        private HTMLFileFilter() {
        }

        public boolean accept(File file) {
            String fileName = file.getName();
            return fileName.endsWith(".html") || fileName.endsWith(".htm");
        }

        public String getDescription() {
            return "HTML Anaysis Result File (*.html, *.htm)";
        }
    }

    private class SaveAsActionListener
    implements ActionListener,
    DirectoryTableEventListener {
        private File m_selectedFile;

        private SaveAsActionListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void actionPerformed(ActionEvent event) {
            try {
                block5: {
                    try {
                        ListenerList.addListener(this);
                        DirectoryTableEvent.notifyRequestFileSelected(this);
                        if (this.m_selectedFile == null) break block5;
                        String fileName = this.m_selectedFile.getName();
                        int index = fileName.lastIndexOf(46);
                        if (index >= 0) {
                            fileName = fileName.substring(0, index);
                        }
                        String path = Preferences.getPreferences().getAnalysisResultsPath();
                        File lastSavedDirectory = new File(path);
                        File selectedFile = new File(path + File.separator + fileName + ".html");
                        JFileChooser fileChooser = new JFileChooser(lastSavedDirectory);
                        fileChooser.addChoosableFileFilter(new HTMLFileFilter());
                        fileChooser.setSelectedFile(selectedFile);
                        int result = fileChooser.showSaveDialog(PMDViewer.getViewer());
                        if (result != 0) break block5;
                        new SaveSaveAs().perform(fileChooser.getSelectedFile());
                    }
                    catch (PMDException pmdException) {
                        String message = pmdException.getMessage();
                        Exception exception = pmdException.getReason();
                        MessageDialog.show(PMDViewer.getViewer(), message, exception);
                        Object var10_13 = null;
                        ListenerList.removeListener(this);
                        return;
                    }
                }
                Object var10_12 = null;
                ListenerList.removeListener(this);
                return;
            }
            catch (Throwable throwable) {
                Object var10_14 = null;
                ListenerList.removeListener(this);
                throw throwable;
            }
        }

        public void requestSelectedFile(DirectoryTableEvent event) {
        }

        public void fileSelectionChanged(DirectoryTableEvent event) {
        }

        public void fileSelected(DirectoryTableEvent event) {
            this.m_selectedFile = event.getSelectedFile();
        }
    }

    private class SaveActionListener
    implements ActionListener,
    DirectoryTableEventListener {
        private File m_selectedFile;

        private SaveActionListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void actionPerformed(ActionEvent event) {
            try {
                block5: {
                    try {
                        ListenerList.addListener(this);
                        DirectoryTableEvent.notifyRequestFileSelected(this);
                        if (this.m_selectedFile == null) break block5;
                        String fileName = this.m_selectedFile.getName();
                        int index = fileName.lastIndexOf(46);
                        if (index >= 0) {
                            fileName = fileName.substring(0, index);
                        }
                        String directory = Preferences.getPreferences().getAnalysisResultsPath();
                        String path = directory + File.separator + fileName + ".html";
                        File outputFile = new File(path);
                        new SaveSaveAs().perform(outputFile);
                    }
                    catch (PMDException pmdException) {
                        String message = pmdException.getMessage();
                        Exception exception = pmdException.getReason();
                        MessageDialog.show(PMDViewer.getViewer(), message, exception);
                        Object var8_11 = null;
                        ListenerList.removeListener(this);
                        return;
                    }
                }
                Object var8_10 = null;
                ListenerList.removeListener(this);
                return;
            }
            catch (Throwable throwable) {
                Object var8_12 = null;
                ListenerList.removeListener(this);
                throw throwable;
            }
        }

        public void requestSelectedFile(DirectoryTableEvent event) {
        }

        public void fileSelectionChanged(DirectoryTableEvent event) {
        }

        public void fileSelected(DirectoryTableEvent event) {
            this.m_selectedFile = event.getSelectedFile();
        }
    }

    private class SaveSaveAs
    implements HTMLAnalysisResultsEventListener {
        private String m_htmlText;

        private SaveSaveAs() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private void perform(File outputFile) {
            if (outputFile == null) return;
            try {
                try {
                    ListenerList.addListener(this);
                    HTMLAnalysisResultsEvent.notifyRequestHTMLText(this);
                    FileWriter writer = null;
                    if (outputFile.exists()) {
                        outputFile.delete();
                    }
                    try {
                        try {
                            writer = new FileWriter(outputFile);
                            writer.write(this.m_htmlText);
                            String message = "Saved Analysis results to file \"" + outputFile.getPath() + "\".";
                            MessageDialog.show(PMDViewer.getViewer(), message);
                        }
                        catch (IOException ioException) {
                            String message2 = "Could not save Analysis results to a file.";
                            PMDException pmdException = new PMDException(message2, ioException);
                            pmdException.fillInStackTrace();
                            throw pmdException;
                        }
                        Object var7_7 = null;
                        {
                        }
                    }
                    catch (Throwable throwable) {
                        Object var7_8 = null;
                        try {
                            writer.close();
                            throw throwable;
                        }
                        catch (IOException exception) {
                            // empty catch block
                        }
                        throw throwable;
                    }
                    try {}
                    catch (IOException exception) {}
                    writer.close();
                    Object var10_15 = null;
                }
                catch (PMDException pmdException) {
                    String message = pmdException.getMessage();
                    Exception exception = pmdException.getReason();
                    MessageDialog.show(PMDViewer.getViewer(), message, exception);
                    Object var10_16 = null;
                    ListenerList.removeListener(this);
                    return;
                }
            }
            catch (Throwable throwable) {
                Object var10_17 = null;
                ListenerList.removeListener(this);
                throw throwable;
            }
            ListenerList.removeListener(this);
        }

        public void requestHTMLAnalysisResults(HTMLAnalysisResultsEvent event) {
        }

        public void returnedHTMLAnalysisResults(HTMLAnalysisResultsEvent event) {
            this.m_htmlText = event.getHTMLText();
        }
    }

    private class EditMenu
    extends JMenu {
        private EditMenu() {
            super("Edit");
            this.setMnemonic('E');
            Icon icon = UIManager.getIcon("copy");
            AnalysisViewer.this.m_copyHTMLResultsMenuItem = new JMenuItem("Copy Analysis Results as HTML", icon);
            AnalysisViewer.this.m_copyHTMLResultsMenuItem.addActionListener(new CopyHTMLResultsActionListener());
            AnalysisViewer.this.m_copyHTMLResultsMenuItem.setMnemonic('C');
            AnalysisViewer.this.m_copyHTMLResultsMenuItem.setAccelerator(KeyStroke.getKeyStroke(67, 2));
            AnalysisViewer.this.m_copyHTMLResultsMenuItem.setEnabled(false);
            AnalysisViewer.this.m_copyHTMLResultsMenuItem.setDisabledIcon(icon);
            this.add(AnalysisViewer.this.m_copyHTMLResultsMenuItem);
            icon = UIManager.getIcon("copy");
            AnalysisViewer.this.m_copyTextResultsMenuItem = new JMenuItem("Copy Analysis Results as Text", icon);
            AnalysisViewer.this.m_copyTextResultsMenuItem.addActionListener(new CopyTextResultsActionListener());
            AnalysisViewer.this.m_copyTextResultsMenuItem.setMnemonic('Y');
            AnalysisViewer.this.m_copyTextResultsMenuItem.setAccelerator(KeyStroke.getKeyStroke(89, 2));
            AnalysisViewer.this.m_copyTextResultsMenuItem.setEnabled(false);
            AnalysisViewer.this.m_copyTextResultsMenuItem.setDisabledIcon(icon);
            this.add(AnalysisViewer.this.m_copyTextResultsMenuItem);
            this.addMouseListener(new EditMenuMouseListener());
        }
    }

    private class FileMenu
    extends JMenu {
        private FileMenu() {
            super("File");
            this.setMnemonic('F');
            Icon icon = UIManager.getIcon("save");
            AnalysisViewer.this.m_saveMenuItem = new JMenuItem("Save Analysis Results", icon);
            AnalysisViewer.this.m_saveMenuItem.addActionListener(new SaveActionListener());
            AnalysisViewer.this.m_saveMenuItem.setMnemonic('S');
            AnalysisViewer.this.m_saveMenuItem.setAccelerator(KeyStroke.getKeyStroke(83, 2));
            AnalysisViewer.this.m_saveMenuItem.setDisabledIcon(icon);
            this.add(AnalysisViewer.this.m_saveMenuItem);
            icon = UIManager.getIcon("saveAs");
            AnalysisViewer.this.m_saveAsMenuItem = new JMenuItem("Save Analysis Results As...", icon);
            AnalysisViewer.this.m_saveAsMenuItem.addActionListener(new SaveAsActionListener());
            AnalysisViewer.this.m_saveAsMenuItem.setMnemonic('A');
            AnalysisViewer.this.m_saveAsMenuItem.setAccelerator(KeyStroke.getKeyStroke(65, 2));
            AnalysisViewer.this.m_saveAsMenuItem.setDisabledIcon(icon);
            this.add(AnalysisViewer.this.m_saveAsMenuItem);
            this.add(new JSeparator());
            icon = UIManager.getIcon("print");
            AnalysisViewer.this.m_printAnalysisMenuItem = new JMenuItem("Print Analysis Results...", icon);
            AnalysisViewer.this.m_printAnalysisMenuItem.addActionListener(new PrintAnalysisActionListener());
            AnalysisViewer.this.m_printAnalysisMenuItem.setMnemonic('P');
            AnalysisViewer.this.m_printAnalysisMenuItem.setAccelerator(KeyStroke.getKeyStroke(80, 2));
            AnalysisViewer.this.m_printAnalysisMenuItem.setDisabledIcon(icon);
            this.add(AnalysisViewer.this.m_printAnalysisMenuItem);
            this.add(new JSeparator());
            JMenuItem menuItem = new JMenuItem("Exit...");
            menuItem.addActionListener(new ExitActionListener());
            menuItem.setMnemonic('X');
            this.add(menuItem);
            this.addMouseListener(new FileMenuMouseListener());
        }
    }

    private class EditMenuMouseListener
    extends MouseAdapter
    implements HTMLAnalysisResultsEventListener {
        String m_htmlText;

        private EditMenuMouseListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void mouseEntered(MouseEvent event) {
            try {
                ListenerList.addListener(this);
                HTMLAnalysisResultsEvent.notifyRequestHTMLText(this);
                boolean enable = this.m_htmlText.length() > 0;
                AnalysisViewer.this.m_copyHTMLResultsMenuItem.setEnabled(enable);
                AnalysisViewer.this.m_copyTextResultsMenuItem.setEnabled(enable);
                Object var4_3 = null;
            }
            catch (Throwable throwable) {
                Object var4_4 = null;
                ListenerList.removeListener(this);
                throw throwable;
            }
            ListenerList.removeListener(this);
        }

        public void requestHTMLAnalysisResults(HTMLAnalysisResultsEvent event) {
        }

        public void returnedHTMLAnalysisResults(HTMLAnalysisResultsEvent event) {
            this.m_htmlText = event.getHTMLText();
        }
    }

    private class FileMenuMouseListener
    extends MouseAdapter
    implements HTMLAnalysisResultsEventListener {
        private String m_htmlText;

        private FileMenuMouseListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void mouseEntered(MouseEvent event) {
            try {
                ListenerList.addListener(this);
                HTMLAnalysisResultsEvent.notifyRequestHTMLText(this);
                boolean enable = this.m_htmlText.length() > 0;
                AnalysisViewer.this.m_saveMenuItem.setEnabled(enable);
                AnalysisViewer.this.m_saveAsMenuItem.setEnabled(enable);
                AnalysisViewer.this.m_printAnalysisMenuItem.setEnabled(enable);
                Object var4_3 = null;
            }
            catch (Throwable throwable) {
                Object var4_4 = null;
                ListenerList.removeListener(this);
                throw throwable;
            }
            ListenerList.removeListener(this);
        }

        public void requestHTMLAnalysisResults(HTMLAnalysisResultsEvent event) {
        }

        public void returnedHTMLAnalysisResults(HTMLAnalysisResultsEvent event) {
            this.m_htmlText = event.getHTMLText();
        }
    }

    private class CopyTextResultsActionListener
    implements ActionListener,
    TextAnalysisResultsEventListener {
        private String m_text;

        private CopyTextResultsActionListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void actionPerformed(ActionEvent event) {
            try {
                ListenerList.addListener(this);
                TextAnalysisResultsEvent.notifyRequestText(this);
                if (this.m_text != null && this.m_text.length() > 0) {
                    Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
                    StringSelection contents = new StringSelection(this.m_text);
                    clipboard.setContents(contents, AnalysisViewer.this.m_clipboardOwner);
                }
                Object var5_4 = null;
            }
            catch (Throwable throwable) {
                Object var5_5 = null;
                ListenerList.removeListener(this);
                throw throwable;
            }
            ListenerList.removeListener(this);
        }

        public void requestTextAnalysisResults(TextAnalysisResultsEvent event) {
        }

        public void returnedTextAnalysisResults(TextAnalysisResultsEvent event) {
            this.m_text = event.getText();
        }
    }

    private class CopyHTMLResultsActionListener
    implements ActionListener,
    HTMLAnalysisResultsEventListener {
        private String m_htmlText;

        private CopyHTMLResultsActionListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void actionPerformed(ActionEvent event) {
            try {
                ListenerList.addListener(this);
                HTMLAnalysisResultsEvent.notifyRequestHTMLText(this);
                if (this.m_htmlText != null && this.m_htmlText.length() > 0) {
                    Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
                    StringSelection contents = new StringSelection(this.m_htmlText);
                    clipboard.setContents(contents, AnalysisViewer.this.m_clipboardOwner);
                }
                Object var5_4 = null;
            }
            catch (Throwable throwable) {
                Object var5_5 = null;
                ListenerList.removeListener(this);
                throw throwable;
            }
            ListenerList.removeListener(this);
        }

        public void requestHTMLAnalysisResults(HTMLAnalysisResultsEvent event) {
        }

        public void returnedHTMLAnalysisResults(HTMLAnalysisResultsEvent event) {
            this.m_htmlText = event.getHTMLText();
        }
    }

    private class ExitActionListener
    implements ActionListener {
        private ExitActionListener() {
        }

        public void actionPerformed(ActionEvent event) {
            System.exit(0);
        }
    }

    private class PrintAnalysisActionListener
    implements ActionListener {
        private PrintAnalysisActionListener() {
        }

        public void actionPerformed(ActionEvent event) {
            new PrintAnalysisResults().print();
        }
    }
}

