/*
 * Decompiled with CFR 0.152.
 */
package org.jaudiotagger.audio.asf.data;

import java.math.BigInteger;
import java.util.ArrayList;
import org.jaudiotagger.audio.asf.data.Chunk;
import org.jaudiotagger.audio.asf.data.GUID;
import org.jaudiotagger.audio.asf.util.Utils;

public class StreamBitratePropertiesChunk
extends Chunk {
    private final ArrayList bitRates = new ArrayList();
    private final ArrayList streamNumbers = new ArrayList();

    public StreamBitratePropertiesChunk(long pos, BigInteger chunkSize) {
        super(GUID.GUID_STREAM_BITRATE_PROPERTIES, pos, chunkSize);
    }

    public void addBitrateRecord(int streamNum, long averageBitrate) {
        this.streamNumbers.add(new Integer(streamNum));
        this.bitRates.add(new Long(averageBitrate));
    }

    public long getAvgBitrate(int streamNumber) {
        Integer seach = new Integer(streamNumber);
        int index = this.streamNumbers.indexOf(seach);
        if (index != -1) {
            return (Long)this.bitRates.get(index);
        }
        return -1L;
    }

    public String prettyPrint() {
        StringBuffer result = new StringBuffer(super.prettyPrint());
        result.insert(0, String.valueOf(Utils.LINE_SEPARATOR) + "Stream Bitrate Properties:" + Utils.LINE_SEPARATOR);
        int i = 0;
        while (i < this.bitRates.size()) {
            result.append("   Stream no. \"" + this.streamNumbers.get(i) + "\" has an average bitrate of \"" + this.bitRates.get(i) + "\"" + Utils.LINE_SEPARATOR);
            ++i;
        }
        result.append(Utils.LINE_SEPARATOR);
        return result.toString();
    }
}

