/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jarbundler;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.sourceforge.jarbundler.AppBundleProperties;
import net.sourceforge.jarbundler.DocumentType;
import net.sourceforge.jarbundler.HelpBook;
import net.sourceforge.jarbundler.JavaProperty;
import net.sourceforge.jarbundler.PropertyListWriter;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.FileScanner;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.taskdefs.MatchingTask;
import org.apache.tools.ant.types.FileList;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.types.PatternSet;
import org.apache.tools.ant.util.FileUtils;

public class JarBundler
extends MatchingTask {
    private static final String DEFAULT_STUB = "/System/Library/Frameworks/JavaVM.framework/Versions/Current/Resources/MacOS/JavaApplicationStub";
    private static final String DEFAULT_CHMOD = "/bin/chmod";
    private static final String ABOUTMENU_KEY = "com.apple.mrj.application.apple.menu.about.name";
    private File mAppIcon;
    private File mRootDir;
    private final List mJavaFileLists = new ArrayList();
    private final List mJarFileSets = new ArrayList();
    private final List mExecFileLists = new ArrayList();
    private final List mExecFileSets = new ArrayList();
    private final List mResourceFileLists = new ArrayList();
    private final List mResourceFileSets = new ArrayList();
    private final List mJarFileLists = new ArrayList();
    private final List mJavaFileSets = new ArrayList();
    private final List mExtraClassPathFileLists = new ArrayList();
    private final List mExtraClassPathFileSets = new ArrayList();
    private final List mJarAttrs = new ArrayList();
    private final List mExecAttrs = new ArrayList();
    private final List mExtraClassPathAttrs = new ArrayList();
    private final List mHelpBooks = new ArrayList();
    private boolean mVerbose = false;
    private boolean mShowPlist = false;
    private File mStubFile = new File("/System/Library/Frameworks/JavaVM.framework/Versions/Current/Resources/MacOS/JavaApplicationStub");
    private Boolean mAntiAliasedGraphics = null;
    private Boolean mAntiAliasedText = null;
    private Boolean mLiveResize = null;
    private Boolean mScreenMenuBar = null;
    private Boolean mGrowbox = null;
    private Boolean mGrowboxIntrudes = null;
    private File bundleDir;
    private File mContentsDir;
    private File mMacOsDir;
    private File mResourcesDir;
    private File mJavaDir;
    private String mChmodCommand = "/bin/chmod";
    private AppBundleProperties bundleProperties = new AppBundleProperties();
    private FileUtils mFileUtils = FileUtils.newFileUtils();

    public void setArguments(String string) {
        this.bundleProperties.setArguments(string);
    }

    public void setStubFile(File file) {
        this.mStubFile = file.exists() ? file : new File(DEFAULT_STUB);
        this.bundleProperties.setCFBundleExecutable(file.getName());
    }

    public void setDir(File file) {
        this.mRootDir = file;
    }

    public void setName(String string) {
        this.bundleProperties.setApplicationName(string);
    }

    public void setShortName(String string) {
        this.bundleProperties.setCFBundleName(string);
    }

    public void setMainClass(String string) {
        this.bundleProperties.setMainClass(string);
    }

    public void setWorkingDirectory(String string) {
        this.bundleProperties.setWorkingDirectory(string);
    }

    public void setIcon(File file) {
        this.mAppIcon = file;
        this.bundleProperties.setCFBundleIconFile(file.getName());
    }

    public void setBundleid(String string) {
        this.bundleProperties.setCFBundleIdentifier(string);
    }

    public void setDevelopmentregion(String string) {
        this.bundleProperties.setCFBundleDevelopmentRegion(string);
    }

    public void setAboutmenuname(String string) {
        this.bundleProperties.setCFBundleName(string);
    }

    public void setSmallTabs(boolean bl) {
        this.bundleProperties.addJavaProperty("com.apple.smallTabs", new Boolean(bl).toString());
    }

    public void setVmoptions(String string) {
        this.bundleProperties.setVMOptions(string);
    }

    public void setAntialiasedgraphics(boolean bl) {
        this.mAntiAliasedGraphics = new Boolean(bl);
    }

    public void setAntialiasedtext(boolean bl) {
        this.mAntiAliasedText = new Boolean(bl);
    }

    public void setScreenmenu(boolean bl) {
        this.mScreenMenuBar = new Boolean(bl);
    }

    public void setGrowbox(boolean bl) {
        this.mGrowbox = new Boolean(bl);
    }

    public void setGrowboxintrudes(boolean bl) {
        this.mGrowboxIntrudes = new Boolean(bl);
    }

    public void setLiveresize(boolean bl) {
        this.mLiveResize = new Boolean(bl);
    }

    public void setType(String string) {
        this.bundleProperties.setCFBundlePackageType(string);
    }

    public void setSignature(String string) {
        this.bundleProperties.setCFBundleSignature(string);
    }

    public void setJvmversion(String string) {
        this.bundleProperties.setJVMVersion(string);
    }

    public void setInfoString(String string) {
        this.bundleProperties.setCFBundleGetInfoString(string);
    }

    public void setShortInfoString(String string) {
        this.setVersion(string);
    }

    public void setVerbose(boolean bl) {
        this.mVerbose = bl;
    }

    public void setShowPlist(boolean bl) {
        this.mShowPlist = bl;
    }

    public void setBuild(String string) {
        this.bundleProperties.setCFBundleVersion(string);
    }

    public void setVersion(String string) {
        this.bundleProperties.setCFBundleShortVersionString(string);
    }

    public void setHelpBookFolder(String string) {
        this.bundleProperties.setCFBundleHelpBookFolder(string);
    }

    public void setHelpBookName(String string) {
        this.bundleProperties.setCFBundleHelpBookName(string);
    }

    public void setJars(String string) {
        PatternSet patternSet = new PatternSet();
        patternSet.setIncludes(string);
        String[] stringArray = patternSet.getIncludePatterns(this.getProject());
        for (int i = 0; i < stringArray.length; ++i) {
            this.mJarAttrs.add(this.getProject().resolveFile(stringArray[i]));
        }
    }

    public void setJar(File file) {
        this.mJarAttrs.add(file);
    }

    public void setExecs(String string) {
        PatternSet patternSet = new PatternSet();
        patternSet.setIncludes(string);
        String[] stringArray = patternSet.getIncludePatterns(this.getProject());
        for (int i = 0; i < stringArray.length; ++i) {
            File file = new File(stringArray[i]);
            this.mExecAttrs.add(file);
        }
    }

    public void setExtraclasspath(String string) {
        PatternSet patternSet = new PatternSet();
        patternSet.setIncludes(string);
        String[] stringArray = patternSet.getIncludePatterns(this.getProject());
        for (int i = 0; i < stringArray.length; ++i) {
            File file = new File(stringArray[i]);
            this.mExtraClassPathAttrs.add(file);
        }
    }

    public void setChmod(String string) {
        this.mChmodCommand = string;
    }

    public void addJarfileset(FileSet fileSet) {
        this.mJarFileSets.add(fileSet);
    }

    public void addJarfilelist(FileList fileList) {
        this.mJarFileLists.add(fileList);
    }

    public void addExecfileset(FileSet fileSet) {
        this.mExecFileSets.add(fileSet);
    }

    public void addExecfilelist(FileList fileList) {
        this.mExecFileLists.add(fileList);
    }

    public void addResourcefileset(FileSet fileSet) {
        this.mResourceFileSets.add(fileSet);
    }

    public void addResourcefilelist(FileList fileList) {
        this.mResourceFileLists.add(fileList);
    }

    public void addJavafileset(FileSet fileSet) {
        this.mJavaFileSets.add(fileSet);
    }

    public void addJavafilelist(FileList fileList) {
        this.mJavaFileLists.add(fileList);
    }

    public void addExtraclasspathfileset(FileSet fileSet) {
        this.mExtraClassPathFileSets.add(fileSet);
    }

    public void addExtraclasspathfilelist(FileList fileList) {
        this.mExtraClassPathFileLists.add(fileList);
    }

    public void addConfiguredJavaProperty(JavaProperty javaProperty) throws BuildException {
        String string = javaProperty.getName();
        String string2 = javaProperty.getValue();
        if (string == null || string2 == null) {
            throw new BuildException("'<javaproperty>' must have both 'name' and 'value' attibutes");
        }
        this.bundleProperties.addJavaProperty(string, string2);
    }

    public void addConfiguredDocumentType(DocumentType documentType) throws BuildException {
        String string = documentType.getName();
        String string2 = documentType.getRole();
        List list = documentType.getOSTypes();
        List list2 = documentType.getExtensions();
        List list3 = documentType.getMimeTypes();
        if (string == null || string2 == null) {
            throw new BuildException("'<documenttype>' must have both a 'name' and a 'role' attibute");
        }
        if (list.isEmpty() && list2.isEmpty() && list3.isEmpty()) {
            throw new BuildException("'<documenttype>' of \"" + string + "\" must have 'osTypes' or 'extensions' or 'mimeTypes'");
        }
        this.bundleProperties.addDocumentType(documentType);
    }

    public void addConfiguredHelpBook(HelpBook helpBook) throws BuildException {
        String string = helpBook.getFolderName();
        String string2 = helpBook.getName();
        String string3 = helpBook.getLocale();
        if (string == null && this.bundleProperties.getCFBundleHelpBookFolder() == null) {
            throw new BuildException("Either the '<helpbook>' attribute 'foldername' or the '<jarbundler>' attribute 'helpbookfolder' must be defined");
        }
        if (string == null) {
            helpBook.setFolderName(this.bundleProperties.getCFBundleHelpBookFolder());
        }
        if (string2 == null && this.bundleProperties.getCFBundleHelpBookName() == null) {
            throw new BuildException("Either the '<helpbook>' attribute 'name' or the '<jarbundler>' attribute 'helpbookname' must be defined");
        }
        if (string2 == null) {
            helpBook.setName(this.bundleProperties.getCFBundleHelpBookName());
        }
        List list = helpBook.getFileLists();
        List list2 = helpBook.getFileSets();
        if (list.isEmpty() && list2.isEmpty()) {
            throw new BuildException("The '<helpbook>' task must have either '<fileset>' or  '<filelist>' nested tags");
        }
        this.mHelpBooks.add(helpBook);
    }

    public void execute() throws BuildException {
        Object object;
        String string;
        String string2;
        String string3;
        this.bundleDir = new File(this.mRootDir, this.bundleProperties.getApplicationName() + ".app");
        if (this.bundleDir.exists()) {
            this.removeDir(this.bundleDir);
        }
        if (this.mRootDir == null) {
            throw new BuildException("Required attribute \"dir\" is not set.");
        }
        if (this.mJarAttrs.isEmpty() && this.mJarFileSets.isEmpty() && this.mJarFileLists.isEmpty()) {
            throw new BuildException("Either the attribute \"jar\" must be set, or one or more jarfilelists or jarfilesets must be added.");
        }
        if (!(this.mJarAttrs.isEmpty() || this.mJarFileSets.isEmpty() && this.mJarFileLists.isEmpty())) {
            throw new BuildException("Cannot set both the attribute \"jars\" and use jar filesets/filelists.  Use only one or the other.");
        }
        if (this.bundleProperties.getApplicationName() == null) {
            throw new BuildException("Required attribute \"name\" is not set.");
        }
        if (this.bundleProperties.getMainClass() == null) {
            throw new BuildException("Required attribute \"mainclass\" is not set.");
        }
        if (this.useOldPropertyNames()) {
            this.bundleProperties.addJavaProperty(ABOUTMENU_KEY, this.bundleProperties.getCFBundleName());
        }
        String string4 = string3 = this.useOldPropertyNames() ? "com.apple.macosx.AntiAliasedGraphicsOn" : "apple.awt.antialiasing";
        if (this.mAntiAliasedGraphics != null) {
            this.bundleProperties.addJavaProperty(string3, this.mAntiAliasedGraphics.toString());
        }
        String string5 = string2 = this.useOldPropertyNames() ? "com.apple.macosx.AntiAliasedTextOn" : "apple.awt.textantialiasing";
        if (this.mAntiAliasedText != null) {
            this.bundleProperties.addJavaProperty(string2, this.mAntiAliasedText.toString());
        }
        if (this.useOldPropertyNames() && this.mLiveResize != null) {
            this.bundleProperties.addJavaProperty("com.apple.mrj.application.live-resize", this.mLiveResize.toString());
        }
        String string6 = string = this.useOldPropertyNames() ? "com.apple.macos.useScreenMenuBar" : "apple.laf.useScreenMenuBar";
        if (this.mScreenMenuBar != null) {
            this.bundleProperties.addJavaProperty(string, this.mScreenMenuBar.toString());
        }
        if (!this.useOldPropertyNames() && this.mGrowbox != null) {
            this.bundleProperties.addJavaProperty("apple.awt.showGrowBox", this.mGrowbox.toString());
        }
        if (this.useOldPropertyNames() && this.mGrowboxIntrudes != null) {
            this.bundleProperties.addJavaProperty("com.apple.mrj.application.growbox.intrudes", this.mGrowboxIntrudes.toString());
        }
        if (!this.mRootDir.exists() || this.mRootDir.exists() && !this.mRootDir.isDirectory()) {
            throw new BuildException("Destination directory specified by \"dir\" attribute must already exist.");
        }
        if (this.bundleDir.exists()) {
            throw new BuildException("The directory/bundle \"" + this.bundleDir.getName() + "\" already exists, cannot continue.");
        }
        System.out.println("Creating application bundle: " + this.bundleDir);
        if (!this.bundleDir.mkdir()) {
            throw new BuildException("Unable to create bundle: " + this.bundleDir);
        }
        this.mContentsDir = new File(this.bundleDir, "Contents");
        if (!this.mContentsDir.mkdir()) {
            throw new BuildException("Unable to create directory " + this.mContentsDir);
        }
        this.mMacOsDir = new File(this.mContentsDir, "MacOS");
        if (!this.mMacOsDir.mkdir()) {
            throw new BuildException("Unable to create directory " + this.mMacOsDir);
        }
        this.mResourcesDir = new File(this.mContentsDir, "Resources");
        if (!this.mResourcesDir.mkdir()) {
            throw new BuildException("Unable to create directory " + this.mResourcesDir);
        }
        this.mJavaDir = new File(this.mResourcesDir, "Java");
        if (!this.mJavaDir.mkdir()) {
            throw new BuildException("Unable to create directory " + this.mJavaDir);
        }
        if (this.mAppIcon != null) {
            try {
                object = new File(this.mResourcesDir, this.mAppIcon.getName());
                if (this.mVerbose) {
                    System.out.println("Copying application icon file to \"" + this.bundlePath((File)object) + "\"");
                }
                this.mFileUtils.copyFile(this.mAppIcon, (File)object);
            }
            catch (IOException iOException) {
                throw new BuildException("Cannot copy icon file: " + iOException);
            }
        }
        try {
            object = this.bundleProperties.getDocumentTypes().iterator();
            while (object.hasNext()) {
                DocumentType documentType = (DocumentType)object.next();
                File file = documentType.getIconFile();
                if (file == null) continue;
                File file2 = new File(this.mResourcesDir, file.getName());
                if (this.mVerbose) {
                    System.out.println("Copying document icon file to \"" + this.bundlePath(file2) + "\"");
                }
                this.mFileUtils.copyFile(file, file2);
            }
        }
        catch (IOException iOException) {
            throw new BuildException("Cannot copy document icon file: " + iOException);
        }
        this.processJarAttrs();
        this.processJarFileSets();
        this.processJarFileLists();
        this.processExecAttrs();
        this.processExecFileSets();
        this.processExecFileLists();
        this.processResourceFileSets();
        this.processJavaFileSets();
        this.processResourceFileLists();
        this.processJavaFileLists();
        this.processExtraClassPathAttrs();
        this.processExtraClassPathFileSets();
        this.processExtraClassPathFileLists();
        this.copyHelpBooks();
        this.copyApplicationStub();
        this.writeInfoPlist();
        this.writePkgInfo();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setExecutable(File file) throws IOException {
        String string = file.getAbsolutePath();
        File file2 = new File(this.mChmodCommand);
        if (!file2.exists()) {
            return;
        }
        if (this.mVerbose) {
            System.out.println("Setting \"" + this.bundlePath(file) + "\" to executable");
        }
        Process process = Runtime.getRuntime().exec(new String[]{this.mChmodCommand, "a+x", string});
        InputStream inputStream = null;
        InputStream inputStream2 = null;
        try {
            inputStream = process.getInputStream();
            inputStream2 = process.getErrorStream();
            byte[] byArray = new byte[1024];
            int n = 0;
            while ((n = inputStream.read(byArray)) != -1) {
                System.out.write(byArray, 0, n);
            }
            while ((n = inputStream2.read(byArray)) != -1) {
                System.out.write(byArray, 0, n);
            }
        }
        finally {
            if (inputStream != null) {
                inputStream.close();
            }
            if (inputStream2 != null) {
                inputStream2.close();
            }
        }
    }

    private boolean useOldPropertyNames() {
        return this.bundleProperties.getJVMVersion().startsWith("1.3");
    }

    private void processJarAttrs() throws BuildException {
        try {
            Iterator iterator = this.mJarAttrs.iterator();
            while (iterator.hasNext()) {
                File file = (File)iterator.next();
                File file2 = new File(this.mJavaDir, file.getName());
                if (this.mVerbose) {
                    System.out.println("Copying JAR file to \"" + this.bundlePath(file2) + "\"");
                }
                this.mFileUtils.copyFile(file, file2);
                this.bundleProperties.addToClassPath(file2.getName());
            }
        }
        catch (IOException iOException) {
            throw new BuildException("Cannot copy jar file: " + iOException);
        }
    }

    private void processJarFileSets() throws BuildException {
        Iterator iterator = this.mJarFileSets.iterator();
        while (iterator.hasNext()) {
            FileSet fileSet = (FileSet)iterator.next();
            Project project = fileSet.getProject();
            File file = fileSet.getDir(project);
            DirectoryScanner directoryScanner = fileSet.getDirectoryScanner(project);
            fileSet.setupDirectoryScanner((FileScanner)directoryScanner, project);
            directoryScanner.scan();
            String[] stringArray = directoryScanner.getIncludedFiles();
            try {
                for (int i = 0; i < stringArray.length; ++i) {
                    String string = stringArray[i];
                    File file2 = new File(file, string);
                    File file3 = new File(this.mJavaDir, string);
                    if (this.mVerbose) {
                        System.out.println("Copying JAR file to \"" + this.bundlePath(file3) + "\"");
                    }
                    this.mFileUtils.copyFile(file2, file3);
                    this.bundleProperties.addToClassPath(string);
                }
            }
            catch (IOException iOException) {
                throw new BuildException("Cannot copy jar file: " + iOException);
            }
        }
    }

    private void processJarFileLists() throws BuildException {
        Iterator iterator = this.mJarFileLists.iterator();
        while (iterator.hasNext()) {
            FileList fileList = (FileList)iterator.next();
            Project project = fileList.getProject();
            File file = fileList.getDir(project);
            String[] stringArray = fileList.getFiles(project);
            try {
                for (int i = 0; i < stringArray.length; ++i) {
                    String string = stringArray[i];
                    File file2 = new File(file, string);
                    File file3 = new File(this.mJavaDir, string);
                    if (this.mVerbose) {
                        System.out.println("Copying JAR file to \"" + this.bundlePath(file3) + "\"");
                    }
                    this.mFileUtils.copyFile(file2, file3);
                    this.bundleProperties.addToClassPath(string);
                }
            }
            catch (IOException iOException) {
                throw new BuildException("Cannot copy jar file: " + iOException);
            }
        }
    }

    private void processExtraClassPathAttrs() throws BuildException {
        Iterator iterator = this.mExtraClassPathAttrs.iterator();
        while (iterator.hasNext()) {
            File file = (File)iterator.next();
            this.bundleProperties.addToExtraClassPath(file.getPath());
        }
    }

    private void processExtraClassPathFileSets() throws BuildException {
        Iterator iterator = this.mExtraClassPathFileSets.iterator();
        while (iterator.hasNext()) {
            FileSet fileSet = (FileSet)iterator.next();
            Project project = fileSet.getProject();
            File file = fileSet.getDir(project);
            DirectoryScanner directoryScanner = fileSet.getDirectoryScanner(project);
            fileSet.setupDirectoryScanner((FileScanner)directoryScanner, project);
            directoryScanner.scan();
            String[] stringArray = directoryScanner.getIncludedFiles();
            for (int i = 0; i < stringArray.length; ++i) {
                File file2 = new File(file, stringArray[i]);
                this.bundleProperties.addToExtraClassPath(file2.getPath());
            }
        }
    }

    private void processExtraClassPathFileLists() throws BuildException {
        Iterator iterator = this.mExtraClassPathFileLists.iterator();
        while (iterator.hasNext()) {
            FileList fileList = (FileList)iterator.next();
            Project project = fileList.getProject();
            File file = fileList.getDir(project);
            String[] stringArray = fileList.getFiles(project);
            for (int i = 0; i < stringArray.length; ++i) {
                File file2 = new File(file, stringArray[i]);
                this.bundleProperties.addToExtraClassPath(file2.getPath());
            }
        }
    }

    private void processExecAttrs() throws BuildException {
        try {
            Iterator iterator = this.mExecAttrs.iterator();
            while (iterator.hasNext()) {
                File file = (File)iterator.next();
                File file2 = new File(this.mMacOsDir, file.getName());
                if (this.mVerbose) {
                    System.out.println("Copying exec file to \"" + this.bundlePath(file2) + "\"");
                }
                this.mFileUtils.copyFile(file, file2);
                this.setExecutable(file2);
            }
        }
        catch (IOException iOException) {
            throw new BuildException("Cannot copy exec file: " + iOException);
        }
    }

    private void processExecFileSets() {
        this.processCopyingFileSets(this.mExecFileSets, this.mMacOsDir, true);
    }

    private void processResourceFileSets() {
        this.processCopyingFileSets(this.mResourceFileSets, this.mResourcesDir, false);
    }

    private void processJavaFileSets() {
        this.processCopyingFileSets(this.mJavaFileSets, this.mJavaDir, false);
    }

    private void processCopyingFileSets(List list, File file, boolean bl) {
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            FileSet fileSet = (FileSet)iterator.next();
            Project project = fileSet.getProject();
            File file2 = fileSet.getDir(project);
            DirectoryScanner directoryScanner = fileSet.getDirectoryScanner(project);
            fileSet.setupDirectoryScanner((FileScanner)directoryScanner, project);
            directoryScanner.scan();
            String[] stringArray = directoryScanner.getIncludedFiles();
            if (stringArray.length == 0) {
                System.err.println("WARNING: fileset for copying from directory " + file2 + ": no files found");
                continue;
            }
            try {
                for (int i = 0; i < stringArray.length; ++i) {
                    String string = stringArray[i];
                    File file3 = new File(file2, string);
                    File file4 = new File(file, string);
                    if (this.mVerbose) {
                        System.out.println("Copying " + (bl ? "exec" : "resource") + " file to \"" + this.bundlePath(file4) + "\"");
                    }
                    this.mFileUtils.copyFile(file3, file4);
                    if (!bl) continue;
                    this.setExecutable(file4);
                }
            }
            catch (IOException iOException) {
                throw new BuildException("Cannot copy file: " + iOException);
            }
        }
    }

    private void processExecFileLists() throws BuildException {
        this.processCopyingFileLists(this.mExecFileLists, this.mMacOsDir, true);
    }

    private void processResourceFileLists() throws BuildException {
        this.processCopyingFileLists(this.mResourceFileLists, this.mResourcesDir, false);
    }

    private void processJavaFileLists() throws BuildException {
        this.processCopyingFileLists(this.mJavaFileLists, this.mJavaDir, false);
    }

    private void processCopyingFileLists(List list, File file, boolean bl) throws BuildException {
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            FileList fileList = (FileList)iterator.next();
            Project project = fileList.getProject();
            File file2 = fileList.getDir(project);
            String[] stringArray = fileList.getFiles(project);
            if (stringArray.length == 0) {
                System.err.println("WARNING: filelist for copying from directory " + file2 + ": no files found");
                continue;
            }
            try {
                for (int i = 0; i < stringArray.length; ++i) {
                    String string = stringArray[i];
                    File file3 = new File(file2, string);
                    File file4 = new File(file, string);
                    if (this.mVerbose) {
                        System.out.println("Copying " + (bl ? "exec" : "resource") + " file to \"" + this.bundlePath(file4) + "\"");
                    }
                    this.mFileUtils.copyFile(file3, file4);
                    if (!bl) continue;
                    this.setExecutable(file4);
                }
            }
            catch (IOException iOException) {
                throw new BuildException("Cannot copy jar file: " + iOException);
            }
        }
    }

    private void copyHelpBooks() {
        Iterator iterator = this.mHelpBooks.iterator();
        while (iterator.hasNext()) {
            HelpBook helpBook = (HelpBook)((Object)iterator.next());
            String string = helpBook.getFolderName();
            String string2 = helpBook.getName();
            String string3 = helpBook.getLocale();
            List list = helpBook.getFileLists();
            List list2 = helpBook.getFileSets();
            File file = null;
            if (string3 == null) {
                if (string != null) {
                    this.bundleProperties.setCFBundleHelpBookFolder(string);
                }
                if (string2 != null) {
                    this.bundleProperties.setCFBundleHelpBookName(string2);
                }
                file = new File(this.mResourcesDir, string);
                file.mkdir();
                if (this.mVerbose) {
                    System.out.println("Creating Help Book at \"" + this.bundlePath(file) + "\"");
                }
            } else {
                File file2 = new File(this.mResourcesDir, string3 + ".lproj");
                file2.mkdir();
                file = new File(file2, string);
                file.mkdir();
                if (this.mVerbose) {
                    System.out.println("Creating Help Book for \"" + string3 + "\" at \"" + this.bundlePath(file) + "\"");
                }
                File file3 = new File(file2, "InfoPlist.strings");
                PrintWriter printWriter = null;
                try {
                    printWriter = new PrintWriter(new FileWriter(file3));
                    printWriter.println("CFBundleHelpBookFolder = \"" + string + "\";");
                    printWriter.println("CFBundleHelpBookName = \"" + string2 + "\";");
                    printWriter.println("CFBundleName = \"" + this.bundleProperties.getCFBundleName() + "\";");
                }
                catch (IOException iOException) {
                    throw new BuildException("IOException in writing Help Book locale: " + string3);
                }
                finally {
                    if (printWriter != null) {
                        printWriter.close();
                    }
                }
            }
            this.processCopyingFileSets(list2, file, false);
            this.processCopyingFileLists(list, file, false);
        }
    }

    private void copyApplicationStub() throws BuildException {
        File file = new File(this.mMacOsDir, this.bundleProperties.getCFBundleExecutable());
        if (this.mVerbose) {
            System.out.println("Copying Java application stub to \"" + this.bundlePath(file) + "\"");
        }
        try {
            this.mFileUtils.copyFile(this.mStubFile, file);
        }
        catch (IOException iOException) {
            throw new BuildException("Cannot copy Java Application Stub: " + iOException);
        }
        try {
            this.setExecutable(file);
        }
        catch (IOException iOException) {
            throw new BuildException("Cannot set executable bit: " + iOException);
        }
    }

    private void writeInfoPlist() throws BuildException {
        PropertyListWriter propertyListWriter = new PropertyListWriter(this.bundleProperties);
        File file = new File(this.mContentsDir, "Info.plist");
        propertyListWriter.writeFile(file);
        if (this.mVerbose) {
            System.out.println("Creating \"" + this.bundlePath(file) + "\" file");
        }
        if (this.mShowPlist) {
            try {
                String string;
                BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
                while ((string = bufferedReader.readLine()) != null) {
                    System.out.println(string);
                }
                bufferedReader.close();
            }
            catch (IOException iOException) {
                throw new BuildException((Throwable)iOException);
            }
        }
    }

    private void writePkgInfo() throws BuildException {
        File file = new File(this.mContentsDir, "PkgInfo");
        PrintWriter printWriter = null;
        try {
            printWriter = new PrintWriter(new BufferedWriter(new FileWriter(file)));
            printWriter.println(this.bundleProperties.getCFBundlePackageType() + this.bundleProperties.getCFBundleSignature());
            printWriter.flush();
        }
        catch (IOException iOException) {
            throw new BuildException("Cannot create PkgInfo file: " + iOException);
        }
        finally {
            if (printWriter != null) {
                printWriter.close();
            }
        }
    }

    private void removeDir(File file) {
        String[] stringArray = file.list();
        if (stringArray == null) {
            stringArray = new String[]{};
        }
        for (int i = 0; i < stringArray.length; ++i) {
            File file2 = new File(file, stringArray[i]);
            if (file2.isDirectory()) {
                this.removeDir(file2);
                continue;
            }
            if (file2.delete()) continue;
            String string = "Unable to delete file \"" + file2.getAbsolutePath() + "\"";
            throw new BuildException(string);
        }
        if (!file.delete()) {
            String string = "Unable to delete directory \"" + file.getAbsolutePath() + "\"";
            throw new BuildException(string);
        }
    }

    private String bundlePath(File file) {
        String string = this.bundleDir.getAbsolutePath();
        String string2 = file.getAbsolutePath();
        return string2.substring(string.length());
    }
}

