/*
 * Decompiled with CFR 0.152.
 */
package com.onionnetworks.util;

import com.onionnetworks.util.Buffer;
import com.onionnetworks.util.IntIterator;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Iterator;
import java.util.Random;

public class Util {
    private static final int MAX_ZERO_COPY = 16384;
    private static byte[] zeroBytes;
    private static char[] zeroChars;
    private static char[] hexDigit;
    public static final Random rand;

    public static final byte[] getBytes(int i) {
        byte[] b = new byte[]{(byte)(i >>> 24 & 0xFF), (byte)(i >>> 16 & 0xFF), (byte)(i >>> 8 & 0xFF), (byte)(i & 0xFF)};
        return b;
    }

    public static final int getInt(byte[] b) {
        return (b[0] & 0xFF) << 24 | (b[1] & 0xFF) << 16 | (b[2] & 0xFF) << 8 | b[3] & 0xFF;
    }

    public static final void bzero(byte[] b, int off, int len) {
        int copyLength;
        if (zeroBytes == null) {
            zeroBytes = new byte[64];
        }
        if (len < zeroBytes.length) {
            System.arraycopy(zeroBytes, 0, b, off, len);
            return;
        }
        System.arraycopy(zeroBytes, 0, b, off, zeroBytes.length);
        int zeroLength = zeroBytes.length;
        do {
            int delta;
            int n = copyLength = zeroLength > (delta = len - zeroLength) ? delta : zeroLength;
            if (copyLength > 16384) {
                copyLength = 16384;
            }
            System.arraycopy(b, off + zeroLength - copyLength, b, off + zeroLength, copyLength);
        } while ((zeroLength += copyLength) < len);
    }

    public static final void bzero(char[] b, int off, int len) {
        int copyLength;
        if (zeroChars == null) {
            zeroChars = new char[64];
        }
        if (len < zeroChars.length) {
            System.arraycopy(zeroChars, 0, b, off, len);
            return;
        }
        System.arraycopy(zeroChars, 0, b, off, zeroChars.length);
        int zeroLength = zeroChars.length;
        do {
            int delta;
            int n = copyLength = zeroLength > (delta = len - zeroLength) ? delta : zeroLength;
            if (copyLength > 16384) {
                copyLength = 16384;
            }
            System.arraycopy(b, off + zeroLength - copyLength, b, off + zeroLength, copyLength);
        } while ((zeroLength += copyLength) < len);
    }

    public static final String getSpaces(int num) {
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < num) {
            sb.append(" ");
            ++i;
        }
        return sb.toString();
    }

    public static boolean arraysEqual(int[] arr1, int start1, int[] arr2, int start2, int len) {
        if (arr1 == arr2 && start1 == start2) {
            return true;
        }
        int i = len - 1;
        while (i >= 0) {
            if (arr1[start1 + i] != arr2[start2 + i]) {
                return false;
            }
            --i;
        }
        return true;
    }

    public static boolean arraysEqual(long[] arr1, int start1, long[] arr2, int start2, int len) {
        if (arr1 == arr2 && start1 == start2) {
            return true;
        }
        int i = len - 1;
        while (i >= 0) {
            if (arr1[start1 + i] != arr2[start2 + i]) {
                return false;
            }
            --i;
        }
        return true;
    }

    public static boolean arraysEqual(char[] arr1, int start1, char[] arr2, int start2, int len) {
        if (arr1 == arr2 && start1 == start2) {
            return true;
        }
        int i = len - 1;
        while (i >= 0) {
            if (arr1[start1 + i] != arr2[start2 + i]) {
                return false;
            }
            --i;
        }
        return true;
    }

    public static boolean arraysEqual(byte[] arr1, int start1, byte[] arr2, int start2, int len) {
        if (arr1 == arr2 && start1 == start2) {
            return true;
        }
        int i = len - 1;
        while (i >= 0) {
            if (arr1[start1 + i] != arr2[start2 + i]) {
                return false;
            }
            --i;
        }
        return true;
    }

    public static final void shuffle(int[] list) {
        int i = list.length - 1;
        while (i >= 0) {
            int j = rand.nextInt(i + 1);
            if (i != j) {
                int tmp = list[i];
                list[i] = list[j];
                list[j] = tmp;
            }
            --i;
        }
    }

    public static final void shuffle(boolean[] list) {
        int i = list.length - 1;
        while (i >= 0) {
            int j = rand.nextInt(i + 1);
            if (i != j) {
                boolean tmp = list[i];
                list[i] = list[j];
                list[j] = tmp;
            }
            --i;
        }
    }

    public static final void shuffle(Object[] list) {
        int i = list.length - 1;
        while (i >= 0) {
            int j = rand.nextInt(i + 1);
            if (i != j) {
                Object tmp = list[i];
                list[i] = list[j];
                list[j] = tmp;
            }
            --i;
        }
    }

    public static final byte[] getBytes(char[] chars) {
        byte[] retval = new byte[chars.length * 2];
        Util.arraycopy(chars, 0, retval, 0, retval.length);
        return retval;
    }

    public static final char[] getChars(byte[] bytes) {
        int len = bytes.length;
        if (len % 2 != 0) {
            throw new IllegalArgumentException("Input array.length non-even.");
        }
        char[] retval = new char[len / 2];
        Util.arraycopy(bytes, 0, retval, 0, len);
        return retval;
    }

    public static final void arraycopy(char[] chars, int charOff, byte[] bytes, int byteOff, int numBytes) {
        int indexCounter = byteOff;
        int loopMax = numBytes / 2 + charOff;
        int i = charOff;
        while (i < loopMax) {
            bytes[indexCounter++] = (byte)((chars[i] & 0xFF00) >> 8);
            bytes[indexCounter++] = (byte)(chars[i] & 0xFF);
            ++i;
        }
        if (numBytes % 2 != 0) {
            bytes[indexCounter] = (byte)((chars[loopMax] & 0xFF00) >> 8);
        }
    }

    public static String getHexDump(byte[] b) {
        int pos = 0;
        int INDEX_WIDTH = 7;
        String ZEROS = "0000000";
        StringBuffer sb = new StringBuffer();
        while (pos < b.length) {
            if (pos % 16 == 0) {
                if (pos > 0) {
                    sb.append("\n");
                }
                String index = Integer.toOctalString(pos);
                sb.append("0000000".substring(0, 7 - index.length()));
                sb.append(index).append(" ");
            } else if (pos % 4 == 0) {
                sb.append(" ");
            }
            String val = Integer.toHexString(b[pos] & 0xFF);
            if (val.length() == 1) {
                sb.append("0");
            }
            sb.append(val);
            ++pos;
        }
        return sb.toString();
    }

    public static final void arraycopy(byte[] bytes, int byteOff, char[] chars, int charOff, int numBytes) {
        int indexCounter = byteOff;
        int loopMax = numBytes / 2 + charOff;
        int i = charOff;
        while (i < loopMax) {
            chars[i] = (char)((bytes[indexCounter++] & 0xFF) << 8 | bytes[indexCounter++] & 0xFF);
            ++i;
        }
        if (numBytes % 2 != 0) {
            chars[loopMax] = (char)((bytes[indexCounter] & 0xFF) << 8);
        }
    }

    public static int divideCeil(int num, int denom) {
        return num / denom + (num % denom == 0 ? 0 : 1);
    }

    public static int divideCeil(long num, long denom) {
        return (int)(num / denom + (long)(num % denom == 0L ? 0 : 1));
    }

    public static double log2(double a) {
        return Math.log(a) / Math.log(2.0);
    }

    public static String bytesToHex(Buffer b) {
        return Util.bytesToHex(b.b, b.off, b.len);
    }

    public static String bytesToHex(byte[] in) {
        return Util.bytesToHex(in, 0, in.length);
    }

    public static String bytesToHex(byte[] in, int off, int len) {
        char[] out = new char[in.length * 2];
        int i = 0;
        while (i < len) {
            out[i * 2] = hexDigit[(0xF0 & in[i + off]) >> 4];
            out[i * 2 + 1] = hexDigit[0xF & in[i + off]];
            ++i;
        }
        return new String(out);
    }

    public static byte[] hexToBytes(String in) {
        int len = in.length();
        if (len % 2 != 0) {
            throw new IllegalArgumentException("Even length string expected.");
        }
        byte[] out = new byte[len / 2];
        try {
            int i = 0;
            while (i < out.length) {
                out[i] = (byte)Integer.parseInt(in.substring(i * 2, i * 2 + 2), 16);
                ++i;
            }
        }
        catch (NumberFormatException doh) {
            doh.printStackTrace();
            throw new IllegalArgumentException("ParseError");
        }
        return out;
    }

    public static boolean isProbablyNat(byte[] addr) {
        if (addr.length != 4) {
            throw new IllegalArgumentException("Address must be 4 bytes long");
        }
        int a = 0xFF & addr[0];
        int b = 0xFF & addr[1];
        int c = 0xFF & addr[2];
        int d = 0xFF & addr[3];
        return a == 10 || a == 192 && b == 168 || a == 192 && b == 0 && c == 1 || a == 223 && b == 255 && c == 255;
    }

    public static final Method getPublicMethod(Class clazz, String name, Class[] types) throws NoSuchMethodException {
        Class c = clazz;
        while (c != null) {
            Method m;
            if (Modifier.isPublic(c.getModifiers()) && (m = Util.getMethod(c.getMethods(), name, types)) != null) {
                return m;
            }
            Class<?>[] interfs = clazz.getInterfaces();
            int a = 0;
            while (a < interfs.length) {
                Method m2;
                if (Modifier.isPublic(interfs[a].getModifiers()) && (m2 = Util.getMethod(interfs[a].getMethods(), name, types)) != null) {
                    return m2;
                }
                ++a;
            }
            c = c.getSuperclass();
        }
        throw new NoSuchMethodException();
    }

    public static final Method getMethod(Method[] methods, String name, Class[] types) {
        int i = 0;
        while (i < methods.length) {
            if (Modifier.isPublic(methods[i].getModifiers()) && name.equals(methods[i].getName()) && types.length == methods[i].getParameterTypes().length) {
                if (types.length == 0) {
                    return methods[i];
                }
                int j = 0;
                while (j < types.length) {
                    if (!methods[i].getParameterTypes()[j].isAssignableFrom(types[j])) break;
                    if (j == types.length - 1) {
                        return methods[i];
                    }
                    ++j;
                }
            }
            ++i;
        }
        return null;
    }

    public static final IntIterator createIntIterator(Iterator it) {
        return new IntIterator(it){
            private final /* synthetic */ Iterator val$it;

            public final boolean hasNextInt() {
                return this.val$it.hasNext();
            }

            public final int nextInt() {
                return (Integer)this.val$it.next();
            }

            public final void removeInt() {
                this.val$it.remove();
            }
            {
                this.val$it = val$it;
                this.constructor$0();
            }

            private final void constructor$0() {
            }
        };
    }

    static {
        hexDigit = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
        rand = new Random();
    }
}

