/*
 * Decompiled with CFR 0.152.
 */
package org.jaudiotagger.audio.asf.data;

import java.math.BigInteger;
import org.jaudiotagger.audio.asf.data.GUID;

public class Chunk {
    protected final BigInteger chunkLength;
    protected final GUID guid;
    protected final long position;

    public Chunk(GUID headerGuid, long pos, BigInteger chunkLen) {
        if (headerGuid == null) {
            throw new IllegalArgumentException("GUID must not be null nor anything else than 16 entries long.");
        }
        if (pos < 0L) {
            throw new IllegalArgumentException("Position of header can't be negative.");
        }
        if (chunkLen == null || chunkLen.compareTo(BigInteger.ZERO) < 0) {
            throw new IllegalArgumentException("chunkLen must not be null nor negative.");
        }
        this.guid = headerGuid;
        this.position = pos;
        this.chunkLength = chunkLen;
    }

    public long getChunckEnd() {
        return this.position + this.chunkLength.longValue();
    }

    public BigInteger getChunkLength() {
        return this.chunkLength;
    }

    public GUID getGuid() {
        return this.guid;
    }

    public long getPosition() {
        return this.position;
    }

    public String prettyPrint() {
        StringBuffer result = new StringBuffer();
        result.append("GUID: " + GUID.getGuidDescription(this.guid));
        result.append("\n   Starts at position: " + this.getPosition() + "\n");
        result.append("   Last byte at: " + (this.getChunckEnd() - 1L) + "\n\n");
        return result.toString();
    }

    public String toString() {
        return this.prettyPrint();
    }
}

