/*
 * Decompiled with CFR 0.152.
 */
package com.onionnetworks.util;

public class Buffer {
    public byte[] b;
    public int off;
    public int len;

    public byte[] getBytes() {
        byte[] retval = new byte[this.len];
        System.arraycopy(this.b, this.off, retval, 0, this.len);
        return retval;
    }

    public boolean equals(Object o) {
        if (o instanceof Buffer) {
            Buffer buf = (Buffer)o;
            if (buf.len != this.len) {
                return false;
            }
            int i = 0;
            while (i < this.len) {
                if (buf.b[buf.off + i] != this.b[this.off + i]) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        return false;
    }

    public String toString() {
        StringBuffer rep = new StringBuffer("Buffer{length: " + this.len + "; offset: " + this.off + "; ");
        int i = this.off;
        while (i < this.len) {
            rep.append("" + i + ": " + this.b[i]);
            if (i != this.len - 1) {
                rep.append(", ");
            }
            ++i;
        }
        rep.append("}");
        return rep.toString();
    }

    public Buffer(int len) {
        this(new byte[len]);
    }

    public Buffer(byte[] b) {
        this(b, 0, b.length);
    }

    public Buffer(byte[] b, int off, int len) {
        if (len < 0 || off < 0 || off + len > b.length) {
            throw new ArrayIndexOutOfBoundsException("b.length=" + b.length + ",off=" + off + ",len=" + len);
        }
        this.b = b;
        this.off = off;
        this.len = len;
    }
}

