/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.swingui;

import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.TreePath;
import net.sourceforge.pmd.swingui.RuleAllEditingPanel;
import net.sourceforge.pmd.swingui.RuleEditingPanel;
import net.sourceforge.pmd.swingui.RulePropertyEditingPanel;
import net.sourceforge.pmd.swingui.RuleSetEditingPanel;
import net.sourceforge.pmd.swingui.RulesTree;
import net.sourceforge.pmd.swingui.RulesTreeNode;
import net.sourceforge.pmd.swingui.event.RulesEditingEvent;

class RuleEditingTabbedPane
extends JTabbedPane {
    private RulesTree m_rulesTree;
    private RuleAllEditingPanel m_ruleAllPanel;
    private RuleSetEditingPanel m_ruleSetPanel;
    private RuleEditingPanel m_rulePanel;
    private RulePropertyEditingPanel m_rulePropertyPanel;
    private RulesTreeNode m_currentTreeNode;

    protected RuleEditingTabbedPane(RulesTree rulesTree) {
        super(1);
        this.m_rulesTree = rulesTree;
        this.m_ruleAllPanel = new RuleAllEditingPanel();
        this.m_ruleSetPanel = new RuleSetEditingPanel();
        this.m_rulePanel = new RuleEditingPanel();
        this.m_rulePropertyPanel = new RulePropertyEditingPanel();
        this.addTab("All", this.m_ruleAllPanel);
        this.addTab("Rule Set", this.m_ruleSetPanel);
        this.addTab("Rule", this.m_rulePanel);
        this.addTab("Property", this.m_rulePropertyPanel);
        this.setFont(UIManager.getFont("tabFont"));
        this.m_ruleAllPanel.setIsEditing(true);
        rulesTree.addTreeSelectionListener(new RulesTreeSelectionListener());
        this.addChangeListener(new TabChangeListener());
    }

    protected RulesTreeNode getSelectedTreeNode() {
        return this.m_rulesTree.getSelectedNode();
    }

    protected void saveData() {
        if (this.m_currentTreeNode != null) {
            RulesEditingEvent.notifySaveData(this, this.m_currentTreeNode);
        }
    }

    private void loadData(RulesTreeNode treeNode) {
        JPanel editingTab = (JPanel)this.getSelectedComponent();
        if (editingTab == this.m_ruleAllPanel) {
            this.m_ruleAllPanel.setIsEditing(true);
            this.m_rulePanel.setIsEditing(false);
            this.m_rulePropertyPanel.setIsEditing(false);
        } else if (editingTab == this.m_rulePanel) {
            this.m_ruleAllPanel.setIsEditing(false);
            this.m_rulePanel.setIsEditing(true);
            this.m_rulePropertyPanel.setIsEditing(false);
        } else {
            this.m_ruleAllPanel.setIsEditing(false);
            this.m_rulePanel.setIsEditing(false);
            this.m_rulePropertyPanel.setIsEditing(true);
        }
        this.m_currentTreeNode = treeNode;
        RulesEditingEvent.notifyLoadData(this, treeNode);
    }

    private class SortChildren
    implements Runnable {
        private RulesTreeNode m_parentNode;

        private SortChildren(RulesTreeNode parentNode) {
            this.m_parentNode = parentNode;
        }

        public void run() {
            if (this.m_parentNode != null) {
                this.m_parentNode.sortChildren();
            }
        }
    }

    private class RulesTreeSelectionListener
    implements TreeSelectionListener {
        private RulesTreeSelectionListener() {
        }

        public void valueChanged(TreeSelectionEvent event) {
            TreePath treePath = event.getPath();
            Object component = treePath.getLastPathComponent();
            if (component instanceof RulesTreeNode) {
                int pathIndex;
                RuleEditingTabbedPane.this.saveData();
                RulesTreeNode treeNode = (RulesTreeNode)component;
                if (RuleEditingTabbedPane.this.getSelectedComponent() != RuleEditingTabbedPane.this.m_ruleAllPanel) {
                    if (treeNode.isRuleSet()) {
                        RuleEditingTabbedPane.this.setSelectedComponent(RuleEditingTabbedPane.this.m_ruleSetPanel);
                    } else if (treeNode.isRule()) {
                        RuleEditingTabbedPane.this.setSelectedComponent(RuleEditingTabbedPane.this.m_rulePanel);
                    } else if (treeNode.isProperty()) {
                        RuleEditingTabbedPane.this.setSelectedComponent(RuleEditingTabbedPane.this.m_rulePropertyPanel);
                    }
                }
                if (treeNode.getParent() == null && (pathIndex = treePath.getPathCount() - 2) >= 0) {
                    treeNode = (RulesTreeNode)treePath.getPathComponent(pathIndex);
                }
                RuleEditingTabbedPane.this.loadData(treeNode);
                SwingUtilities.invokeLater(new SortChildren(treeNode));
            }
        }
    }

    private class TabChangeListener
    implements ChangeListener {
        private TabChangeListener() {
        }

        public void stateChanged(ChangeEvent event) {
            RulesTreeNode selectedTreeNode = RuleEditingTabbedPane.this.getSelectedTreeNode();
            RuleEditingTabbedPane.this.saveData();
            RuleEditingTabbedPane.this.loadData(selectedTreeNode);
            SwingUtilities.invokeLater(new SortChildren(selectedTreeNode));
        }
    }
}

