/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.rules;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.sourceforge.pmd.AbstractRule;
import net.sourceforge.pmd.RuleContext;
import net.sourceforge.pmd.ast.ASTArgumentList;
import net.sourceforge.pmd.ast.ASTCompilationUnit;
import net.sourceforge.pmd.ast.ASTLiteral;
import net.sourceforge.pmd.ast.Node;
import net.sourceforge.pmd.ast.SimpleNode;

public class AvoidDuplicateLiteralsRule
extends AbstractRule {
    private Map literals = new HashMap();

    public Object visit(ASTCompilationUnit node, Object data) {
        this.literals.clear();
        super.visit(node, data);
        int threshold = this.getIntProperty("threshold");
        Iterator i = this.literals.keySet().iterator();
        while (i.hasNext()) {
            String key = (String)i.next();
            List occurrences = (List)this.literals.get(key);
            if (occurrences.size() < threshold) continue;
            Object[] args = new Object[]{new Integer(occurrences.size()), new Integer(((SimpleNode)occurrences.get(0)).getBeginLine())};
            String msg = MessageFormat.format(this.getMessage(), args);
            RuleContext ctx = (RuleContext)data;
            ctx.getReport().addRuleViolation(this.createRuleViolation(ctx, ((SimpleNode)occurrences.get(0)).getBeginLine(), msg));
        }
        return data;
    }

    public Object visit(ASTLiteral node, Object data) {
        if (!this.hasAtLeastSixParents(node)) {
            return data;
        }
        if (!(node.jjtGetParent().jjtGetParent().jjtGetParent().jjtGetParent().jjtGetParent().jjtGetParent() instanceof ASTArgumentList)) {
            return data;
        }
        if (node.getImage() == null || node.getImage().indexOf(34) == -1) {
            return data;
        }
        if (this.literals.containsKey(node.getImage())) {
            List occurrences = (List)this.literals.get(node.getImage());
            occurrences.add(node);
        } else {
            ArrayList<ASTLiteral> occurrences = new ArrayList<ASTLiteral>();
            occurrences.add(node);
            this.literals.put(node.getImage(), occurrences);
        }
        return data;
    }

    private boolean hasAtLeastSixParents(Node node) {
        Node currentNode = node;
        int i = 0;
        while (i < 6) {
            if (currentNode instanceof ASTCompilationUnit) {
                return false;
            }
            currentNode = currentNode.jjtGetParent();
            ++i;
        }
        return true;
    }
}

