/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.inspection;

import com.google.inject.Injector;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import java.io.File;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.bcel.Repository;
import org.apache.bcel.classfile.AnnotationEntry;
import org.apache.bcel.classfile.ClassParser;
import org.apache.bcel.classfile.Field;
import org.apache.bcel.classfile.JavaClass;
import org.limewire.inspection.Inspectable;
import org.limewire.util.FileUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InspectionTool {
    private final Injector injector;

    public InspectionTool(Injector injector) {
        this.injector = injector;
    }

    public static Map<String, String> generateMappings(File file, Injector injector, String[] stringArray) {
        InspectionTool inspectionTool = new InspectionTool(injector);
        return inspectionTool.go(file, stringArray);
    }

    private Map<String, String> go(File file, String[] stringArray) {
        TreeMap<String, String> treeMap = new TreeMap<String, String>();
        File[] fileArray = FileUtils.getFilesRecursive((File)file, (String[])new String[]{"class"});
        try {
            for (File file2 : fileArray) {
                ClassParser classParser;
                JavaClass javaClass;
                if (this.fileContainsPaths(file2.getPath(), stringArray) || (javaClass = (classParser = new ClassParser(file2.getPath())).parse()).isInterface() || javaClass.isAnnotation()) continue;
                this.scanClass(javaClass, treeMap);
            }
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
        return treeMap;
    }

    private boolean fileContainsPaths(String string, String[] stringArray) {
        for (String string2 : stringArray) {
            if (!string.contains(string2)) continue;
            return true;
        }
        return false;
    }

    private void scanClass(JavaClass javaClass, Map<String, String> map) {
        boolean bl = false;
        ArrayList<FieldAndAnnotation> arrayList = new ArrayList<FieldAndAnnotation>();
        for (Field field : javaClass.getFields()) {
            for (AnnotationEntry annotationEntry : field.getAnnotationEntries()) {
                boolean bl2 = false;
                if (annotationEntry.getAnnotationType().contains("InspectablePrimitive") || annotationEntry.getAnnotationType().contains("InspectableForSize")) {
                    bl2 = true;
                } else if (annotationEntry.getAnnotationType().contains("InspectionPoint")) {
                    bl2 = true;
                    try {
                        if (!Repository.implementationOf((String)field.getType().toString(), (String)Inspectable.class.getName())) {
                            throw new RuntimeException("InspectionPoint on: " + field + ", but does not implement Inspectable");
                        }
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new RuntimeException(classNotFoundException);
                    }
                }
                if (!bl2) continue;
                if (field.isStatic()) {
                    this.map(true, field, null, javaClass, annotationEntry, map);
                    continue;
                }
                arrayList.add(new FieldAndAnnotation(field, annotationEntry));
                bl = true;
            }
        }
        if (bl) {
            this.validateContainer(arrayList, javaClass, map);
        }
    }

    private void validateContainer(List<FieldAndAnnotation> list, JavaClass javaClass, Map<String, String> map) {
        String string;
        boolean bl = false;
        boolean bl2 = false;
        for (AnnotationEntry object : javaClass.getAnnotationEntries()) {
            string = object.getAnnotationType();
            bl |= string.contains("Singleton");
            bl2 |= string.contains("InspectableContainer");
        }
        if (bl && bl2) {
            throw new RuntimeException("Can't be both container && singleton.  Class: " + javaClass.getClassName());
        }
        JavaClass javaClass2 = null;
        JavaClass javaClass3 = null;
        if (bl2) {
            try {
                Class<?> clazz = Class.forName(javaClass.getClassName());
                Class<?> clazz2 = clazz.getEnclosingClass();
                string = Repository.lookupClass(clazz2);
                javaClass2 = this.validateGuice((JavaClass)string);
                if (string == javaClass2) {
                    javaClass2 = null;
                }
                javaClass3 = javaClass;
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new RuntimeException(classNotFoundException);
            }
        } else {
            javaClass3 = this.validateGuice(javaClass);
        }
        if (javaClass3 != null) {
            for (FieldAndAnnotation fieldAndAnnotation : list) {
                this.map(false, fieldAndAnnotation.getField(), javaClass2, javaClass3, fieldAndAnnotation.getAnnotation(), map);
            }
        }
    }

    private JavaClass validateGuice(JavaClass javaClass) {
        try {
            Object object;
            Class<?> clazz;
            ArrayList<ProviderAndBoundClass> arrayList = new ArrayList<ProviderAndBoundClass>();
            for (clazz = Class.forName(javaClass.getClassName()); clazz != null && clazz != Object.class; clazz = clazz.getSuperclass()) {
                object = this.getProvider(this.injector, clazz);
                if (object != null) {
                    arrayList.add(new ProviderAndBoundClass(clazz, (Provider<?>)object));
                }
                for (Class<?> clazz2 : clazz.getInterfaces()) {
                    object = this.getProvider(this.injector, clazz2);
                    if (object == null) continue;
                    arrayList.add(new ProviderAndBoundClass(clazz2, (Provider<?>)object));
                }
            }
            if (arrayList.isEmpty()) {
                throw new RuntimeException("nothing bound to class: " + javaClass.getClassName());
            }
            object = null;
            for (ProviderAndBoundClass providerAndBoundClass : arrayList) {
                Object object2 = providerAndBoundClass.getProvider().get();
                if (object == null) {
                    object = object2;
                }
                if (object == object2) continue;
                throw new RuntimeException("Instances don't match.  Current binding: " + providerAndBoundClass + ".  Prior instance: " + object + ", current instance: " + object2);
            }
            if (!this.verifySingleton(object.getClass())) {
                throw new RuntimeException("Instance class: " + object.getClass() + ", from container: " + javaClass.getClassName() + " is not a singleton!");
            }
            clazz = ((ProviderAndBoundClass)arrayList.get(0)).getBoundClass();
            return Repository.lookupClass(clazz);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new RuntimeException(classNotFoundException);
        }
    }

    private Provider<?> getProvider(Injector injector, Class<?> clazz) {
        try {
            return injector.getProvider(clazz);
        }
        catch (RuntimeException runtimeException) {
            return null;
        }
    }

    private boolean verifySingleton(Class<?> clazz) {
        Annotation[] annotationArray;
        for (Annotation annotation : annotationArray = clazz.getAnnotations()) {
            if (annotation.annotationType() != Singleton.class) continue;
            return true;
        }
        return false;
    }

    private void map(boolean bl, Field field, JavaClass javaClass, JavaClass javaClass2, AnnotationEntry annotationEntry, Map<String, String> map) {
        String string = annotationEntry.getElementValuePairs()[0].getValue().toString();
        String string2 = javaClass2.getClassName() + (bl ? ":" : ",") + field.getName();
        if (javaClass != null) {
            string2 = javaClass.getClassName() + "|" + string2;
        }
        if (string == null || string.trim().length() == 0) {
            throw new RuntimeException("no ID for point: " + field.getName() + ", in: " + javaClass2.getClassName() + ", enclosed in: " + (javaClass == null ? "null" : javaClass.getClassName()));
        }
        map.put(string, string2);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ProviderAndBoundClass {
        private final Class<?> boundClass;
        private final Provider<?> provider;

        public ProviderAndBoundClass(Class<?> clazz, Provider<?> provider) {
            this.boundClass = clazz;
            this.provider = provider;
        }

        public Class<?> getBoundClass() {
            return this.boundClass;
        }

        public Provider<?> getProvider() {
            return this.provider;
        }

        public String toString() {
            return "provider: " + this.provider + ", bound to: " + this.boundClass;
        }
    }

    private static class FieldAndAnnotation {
        private final Field field;
        private final AnnotationEntry annotation;

        public FieldAndAnnotation(Field field, AnnotationEntry annotationEntry) {
            this.field = field;
            this.annotation = annotationEntry;
        }

        public Field getField() {
            return this.field;
        }

        public AnnotationEntry getAnnotation() {
            return this.annotation;
        }
    }
}

