/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.io;

import edu.uci.ics.jung.exceptions.FatalException;
import edu.uci.ics.jung.graph.DirectedEdge;
import edu.uci.ics.jung.graph.Edge;
import edu.uci.ics.jung.graph.Graph;
import edu.uci.ics.jung.graph.UndirectedEdge;
import edu.uci.ics.jung.graph.Vertex;
import edu.uci.ics.jung.graph.decorators.Indexer;
import edu.uci.ics.jung.io.GraphFile;
import edu.uci.ics.jung.io.GraphMLFileHandler;
import edu.uci.ics.jung.utils.Pair;
import edu.uci.ics.jung.utils.PredicateUtils;
import edu.uci.ics.jung.utils.UserData;
import edu.uci.ics.jung.utils.UserDataContainer;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.InputStream;
import java.io.PrintStream;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.InputSource;
import org.xml.sax.helpers.DefaultHandler;

public class GraphMLFile
implements GraphFile {
    private GraphMLFileHandler mFileHandler;
    protected boolean directed;
    protected boolean undirected;

    public GraphMLFile() {
        this.mFileHandler = new GraphMLFileHandler();
    }

    public GraphMLFile(GraphMLFileHandler handler) {
        this.mFileHandler = handler;
    }

    public Graph load(String filename) {
        SAXParserFactory factory = SAXParserFactory.newInstance();
        try {
            SAXParser saxParser = factory.newSAXParser();
            saxParser.parse(new File(filename), (DefaultHandler)this.mFileHandler);
        }
        catch (Exception e) {
            throw new FatalException("Error loading graphml file: " + filename, e);
        }
        return this.mFileHandler.getGraph();
    }

    public Graph load(InputStream stream) {
        SAXParserFactory factory = SAXParserFactory.newInstance();
        try {
            SAXParser saxParser = factory.newSAXParser();
            saxParser.parse(stream, (DefaultHandler)this.mFileHandler);
        }
        catch (Exception e) {
            throw new FatalException("Error loading graphml file", e);
        }
        return this.mFileHandler.getGraph();
    }

    public Graph load(Reader reader) {
        SAXParserFactory factory = SAXParserFactory.newInstance();
        try {
            SAXParser saxParser = factory.newSAXParser();
            InputSource is = new InputSource(reader);
            saxParser.parse(is, (DefaultHandler)this.mFileHandler);
        }
        catch (Exception e) {
            throw new FatalException("Error loading graphml file", e);
        }
        return this.mFileHandler.getGraph();
    }

    public List loadGraphCollection(String dirName, FilenameFilter filter) {
        File dir = new File(dirName);
        if (!dir.isDirectory()) {
            throw new FatalException("Parameter dirName must be a directory");
        }
        String[] files = dir.list(filter);
        ArrayList<Graph> graphCollection = new ArrayList<Graph>();
        for (int i = 0; i < files.length; ++i) {
            String currentFile = dirName + File.separatorChar + files[i];
            GraphMLFile graphmlFile = new GraphMLFile(this.mFileHandler);
            Graph graph = graphmlFile.load(currentFile);
            graphCollection.add(graph);
        }
        return graphCollection;
    }

    public void save(Graph g, String filename) {
        PrintStream out;
        try {
            out = new PrintStream(new FileOutputStream(filename, false));
        }
        catch (Exception e) {
            throw new FatalException("Could not open file \"" + filename + "\" for writing. " + e);
        }
        this.save(g, out);
        out.close();
    }

    public void save(Graph g, PrintStream out) {
        out.println("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        out.println("<graphml xmlns=\"http://graphml.graphdrawing.org/xmlns/graphml\"  xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"  ");
        out.println("xsi:schemaLocation=\"http://graphml.graphdrawing.org/xmlns/graphml\">");
        out.print("<graph edgedefault=\"");
        boolean directed = PredicateUtils.enforcesEdgeConstraint(g, Graph.DIRECTED_EDGE);
        boolean undirected = PredicateUtils.enforcesEdgeConstraint(g, Graph.UNDIRECTED_EDGE);
        if (directed) {
            out.print("directed\" ");
        } else if (undirected) {
            out.print("undirected\" ");
        } else {
            directed = true;
            out.print("directed\" ");
        }
        this.saveUserData(g, out);
        out.println(" >");
        this.saveVerticesSection(out, g);
        this.saveEdgesSection(out, g);
        out.println("</graph>");
        out.println("</graphml>");
    }

    private void saveVerticesSection(PrintStream out, Graph g) {
        int numVertices = g.getVertices().size();
        Indexer id = Indexer.getIndexer(g);
        for (int i = 0; i < numVertices; ++i) {
            Vertex v = (Vertex)id.getVertex(i);
            int vId = i + 1;
            out.print("<node id=\"" + vId + "\" ");
            this.saveUserData(v, out);
            out.println("/>");
        }
    }

    private void saveEdgesSection(PrintStream out, Graph g) {
        Indexer id = Indexer.getIndexer(g);
        Iterator edgeIterator = g.getEdges().iterator();
        while (edgeIterator.hasNext()) {
            Edge e = (Edge)edgeIterator.next();
            Pair p = e.getEndpoints();
            Vertex src = (Vertex)p.getFirst();
            Vertex dest = (Vertex)p.getSecond();
            int srcId = id.getIndex(src) + 1;
            out.print("<edge source=\"" + srcId + "\" ");
            int destId = id.getIndex(dest) + 1;
            out.print("target=\"" + destId + "\" ");
            if (this.directed) {
                if (e instanceof UndirectedEdge) {
                    out.print("directed=\"false\" ");
                }
            } else if (e instanceof DirectedEdge) {
                out.print("directed=\"true\" ");
            }
            this.saveUserData(e, out);
            out.println("/>");
        }
    }

    private void saveUserData(UserDataContainer udc, PrintStream out) {
        Iterator udki = udc.getUserDatumKeyIterator();
        while (udki.hasNext()) {
            String datum;
            Object o;
            String key;
            Object key_obj = udki.next();
            if (udc.getUserDatumCopyAction(key_obj) == UserData.REMOVE || this.invalidXMLData(key = key_obj.toString()) || (o = udc.getUserDatum(key)) == null || this.invalidXMLData(datum = o.toString())) continue;
            out.print(key + "=\"" + datum + "\" ");
        }
    }

    private boolean invalidXMLData(String str) {
        if (str.indexOf("&") >= 0) {
            return true;
        }
        if (str.indexOf("<") >= 0) {
            return true;
        }
        if (str.indexOf(">") >= 0) {
            return true;
        }
        if (str.indexOf("'") >= 0) {
            return true;
        }
        return str.indexOf("\"") >= 0;
    }

    public void setGraphMLFileHandler(GraphMLFileHandler fileHandler) {
        this.mFileHandler = fileHandler;
    }
}

