
package com.limegroup.gnutella.bootstrap;

import java.text.ParseException;

/**
 * The list of default GWebCache urls, used the first time LimeWire starts, or
 * if the gnutella.net file is accidentally deleted.  Entries in the list will
 * eventually be replaced by URLs discovered during urlfile=1 requests.  Order
 * does not matter.
 *
 * THIS FILE IS AUTOMATICALLY GENERATED FROM MAKE_DEFAULT.PY.
 */
public class DefaultBootstrapServers {
    /**
     * Adds all the default servers to bman. 
     */
    public static void addDefaults(BootstrapServerManager bman) {
        for (int i=0; i<urls.length; i++) {
            try {
                BootstrapServer server=new BootstrapServer(urls[i]);
                bman.addBootstrapServer(server);
            } catch (ParseException ignore) {
            }                
        }
    }

    //These should NOT be URL encoded.
    static String[] urls=new String[] {
        "http://bbs.robertwoolley.co.uk/gwebcache/gcache.php",
        "http://cache.aiskacang.com/skulls/skulls.php",
        "http://g2.tjtech.org/g2/index.php",
        "http://gwc.dietpac.com:8080/",
        "http://gwc.eod.cc/skulls.php",
        "http://gwc.frodoslair.net.nyud.net/skulls/skulls.php",
        "http://gwc.frodoslair.net/skulls/skulls.php",
        "http://gwc.glucolene.com:8080/",
        "http://gwc.monnsta.net/",
        "http://gwc.nickstallman.net/",
        "http://gwc1c.olden.ch.3557.nyud.net:8080/gwc/",
        "http://sites.matros.cjb.net/p2p/gcache/skulls.php",
        "http://www.dom2porno.info/skulls/skulls.php"
    };
}
