/*
 * Copyright (c) 2002-2004 David Keiichi Watanabe
 * davew@xlife.org
 *
 * Modified by (c) 2004-2008 heavy_baby
 * heavy_baby@users.sourceforge.jp
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */

package jp.sourceforge.cabos;

import java.io.File;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.limegroup.gnutella.ActivityCallback;
import com.limegroup.gnutella.Connection;
import com.limegroup.gnutella.Downloader;
import com.limegroup.gnutella.FileDesc;
import com.limegroup.gnutella.GUID;
import com.limegroup.gnutella.RemoteFileDesc;
import com.limegroup.gnutella.Uploader;
import com.limegroup.gnutella.search.HostData;
import com.sun.java.util.collections.Collections;
import com.sun.java.util.collections.HashMap;
import com.sun.java.util.collections.Map;
import com.sun.java.util.collections.Set;

public class AqEventHandler implements ActivityCallback {
	/* Instances */

	private static final Log LOG = LogFactory.getLog(AqEventHandler.class);

	protected static final Map hosts = Collections.synchronizedMap(new HashMap());

	protected static final Map queries = Collections.synchronizedMap(new HashMap());

	protected static final Map indices = Collections.synchronizedMap(new HashMap());

	protected static final Map responses = Collections.synchronizedMap(new HashMap());

	/* Connections */

	public void connectionInitializing(Connection c) {
	}

	public void connectionInitialized(Connection c) {
		AqEvent.signalEvent(AqEvent.kLWEventConnectionInitialized, c);
	}

	public void connectionClosed(Connection c) {
		AqEvent.signalEvent(AqEvent.kLWEventConnectionClosed, c);
	}

	/* Queries */

	public void handleQueryResult(RemoteFileDesc rfd, HostData data, Set locs) {
        AqEvent.signalEvent(AqEvent.kLWEventQueryResult, new AqResponse(rfd, data, locs));
	}

	public void handleQueryString(String query) {
	}

	/* Downlods */

	public void addDownload(Downloader d) {
		AqEvent.signalEvent(AqEvent.kLWEventAddDownload, d);
	}

	public void removeDownload(Downloader d) {
		AqEvent.signalEvent(AqEvent.kLWEventUpdateDownloadStats, d);
		AqEvent.signalEvent(AqEvent.kLWEventRemoveDownload, d);
	}

	/* Uploads */

	public void addUpload(Uploader u) {
        if (u.getState() == Uploader.CONNECTING ||
            u.getState() == Uploader.UPLOADING ||
            u.getState() == Uploader.QUEUED)
            AqEvent.signalEvent(AqEvent.kLWEventAddUpload, u);
	}

	public void removeUpload(Uploader u) {
		AqEvent.signalEvent(AqEvent.kLWEventUpdateUploadStats, u);
		AqEvent.signalEvent(AqEvent.kLWEventRemoveUpload, u);
	}

	/* Browsing */

	public void browseHostFailed(GUID guid) {
		AqEvent.signalEvent(AqEvent.kLWEventBrowseHostFailed, guid);
	}

	/* Sharing */

	public void fileManagerLoaded() {
	}

	public void addSharedDirectory(final File directory, final File parent) {
	}

	public void addSharedFile(final FileDesc file, final File parent) {
		AqEvent.signalEvent(AqEvent.kLWEventAddSharedFile, file);
	}

	public void handleSharedFileUpdate(File file) {
	}

	public void clearSharedFiles() {
	}

	public void setAnnotateEnabled(boolean enabled) {
	}

	/* GUI */

	public void downloadsComplete() {
	}

	public void uploadsComplete() {
	}

	public void promptAboutCorruptDownload(Downloader dloader) {
		dloader.discardCorruptDownload(false);
	}

	public void restoreApplication() {
	}

	public void showDownloads() {
	}

	public boolean isQueryAlive(GUID guid) {
		return queries.containsKey(guid);
	}

	public String getHostValue(String key) {
		return null;
	}

	public void componentLoading(String component) {
		LOG.info(component);
	}

}