/*
 * Decompiled with CFR 0.152.
 */
package samples.preview_new_graphdraw.staticlayouts;

import edu.uci.ics.jung.graph.Graph;
import edu.uci.ics.jung.graph.Vertex;
import java.awt.Dimension;
import samples.preview_new_graphdraw.StaticLayout;
import samples.preview_new_graphdraw.VisVertex;

public class CircleLayout
extends StaticLayout {
    double radius = 0.0;
    int total_vertices = 0;
    int vertex_number;

    private double getHeight() {
        return this.getScreenSize().getHeight();
    }

    private double getWidth() {
        return this.getScreenSize().getWidth();
    }

    public StaticLayout initializeLocations(Dimension d, Graph g) {
        this.total_vertices = g.getVertices().size();
        this.vertex_number = 0;
        double height = d.getHeight();
        double width = d.getWidth();
        this.radius = 0.45 * Math.min(height, width);
        return super.initializeLocations(d, g);
    }

    protected VisVertex createVisVertex(Vertex v) {
        double angle = Math.PI * 2 * (double)this.vertex_number++ / (double)this.total_vertices;
        double x = Math.cos(angle) * this.radius + this.getWidth() / 2.0;
        double y = Math.sin(angle) * this.radius + this.getHeight() / 2.0;
        return new VisVertex(v, x, y);
    }
}

