/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.utils;

import edu.uci.ics.jung.exceptions.FatalException;
import java.lang.reflect.Method;
import java.util.Iterator;

public interface UserDataContainer
extends Cloneable {
    public Object clone() throws CloneNotSupportedException;

    public void addUserDatum(Object var1, Object var2, CopyAction var3);

    public void importUserData(UserDataContainer var1);

    public Iterator getUserDatumKeyIterator();

    public CopyAction getUserDatumCopyAction(Object var1);

    public Object getUserDatum(Object var1);

    public void setUserDatum(Object var1, Object var2, CopyAction var3);

    public Object removeUserDatum(Object var1);

    public boolean containsUserDatumKey(Object var1);

    public static interface CopyAction {
        public Object onCopy(Object var1, UserDataContainer var2, UserDataContainer var3);

        public static class Remove
        implements CopyAction {
            public Object onCopy(Object value, UserDataContainer source, UserDataContainer target) {
                return null;
            }
        }

        public static class Shared
        implements CopyAction {
            public Object onCopy(Object value, UserDataContainer source, UserDataContainer target) {
                return value;
            }
        }

        public static class Clone
        implements CopyAction {
            public Object onCopy(Object value, UserDataContainer source, UserDataContainer target) {
                try {
                    if (!(value instanceof Cloneable)) {
                        throw new CloneNotSupportedException("Not cloneable interface: This used to just return a shared reference.");
                    }
                    Method cloneMethod = value.getClass().getMethod("clone", null);
                    if (cloneMethod != null) {
                        return cloneMethod.invoke(value, null);
                    }
                    throw new CloneNotSupportedException("No clone method implemented: This used to just return a shared reference.");
                }
                catch (Exception e) {
                    throw new FatalException("Cloning failure", e);
                }
            }
        }
    }
}

