/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.io;

import edu.uci.ics.jung.exceptions.FatalException;
import edu.uci.ics.jung.graph.DirectedEdge;
import edu.uci.ics.jung.graph.Edge;
import edu.uci.ics.jung.graph.Graph;
import edu.uci.ics.jung.graph.UndirectedEdge;
import edu.uci.ics.jung.graph.Vertex;
import edu.uci.ics.jung.graph.decorators.Indexer;
import edu.uci.ics.jung.graph.decorators.StringLabeller;
import edu.uci.ics.jung.graph.impl.DirectedSparseGraph;
import edu.uci.ics.jung.graph.impl.SparseGraph;
import edu.uci.ics.jung.graph.impl.UndirectedSparseGraph;
import edu.uci.ics.jung.io.GraphFile;
import edu.uci.ics.jung.utils.GraphUtils;
import edu.uci.ics.jung.utils.MutableDouble;
import edu.uci.ics.jung.utils.Pair;
import edu.uci.ics.jung.utils.PredicateUtils;
import edu.uci.ics.jung.utils.UserData;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.text.ParseException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.StringTokenizer;

public class PajekNetFile
implements GraphFile {
    public static final String EDGE_WEIGHT = "jung.io.PajekNetFile.EdgeWeight";
    private String[] mEdgeKeys;
    private boolean mCreateDirectedOnly;

    public PajekNetFile() {
        this.mCreateDirectedOnly = false;
    }

    public PajekNetFile(String[] edgeKeys) {
        this.mEdgeKeys = edgeKeys;
        this.mCreateDirectedOnly = false;
    }

    public String[] getEdgeKeys() {
        return this.mEdgeKeys;
    }

    public void setEdgeKeys(String[] edgeKeys) {
        this.mEdgeKeys = edgeKeys;
    }

    public Graph load(String filename) {
        try {
            FileReader reader = new FileReader(filename);
            Graph graph = this.load(reader);
            ((Reader)reader).close();
            return graph;
        }
        catch (IOException ioe) {
            throw new FatalException("Error in loading file " + filename, ioe);
        }
    }

    public void setCreateDirectedOnly(boolean createDirectedOnly) {
        this.mCreateDirectedOnly = createDirectedOnly;
    }

    public Graph load(Reader read) {
        BufferedReader reader = new BufferedReader(read);
        int currentSourceId = -1;
        String currentLine = null;
        try {
            StringTokenizer tokenizer = null;
            currentLine = reader.readLine();
            tokenizer = new StringTokenizer(currentLine);
            if (!tokenizer.nextToken().toLowerCase().startsWith("*vertices")) {
                throw new ParseException("Pajek file parse error: '*vertices' not first token", 0);
            }
            int numVertices = Integer.parseInt(tokenizer.nextToken());
            DirectedSparseGraph directedGraph = new DirectedSparseGraph();
            GraphUtils.addVertices((Graph)directedGraph, numVertices);
            Indexer directedGraphIndexer = Indexer.newIndexer(directedGraph, 1);
            UndirectedSparseGraph undirectedGraph = null;
            Indexer undirectedGraphIndexer = null;
            StringLabeller undirectedLabeler = null;
            if (!this.mCreateDirectedOnly) {
                undirectedGraph = new UndirectedSparseGraph();
                GraphUtils.addVertices((Graph)undirectedGraph, numVertices);
                undirectedGraphIndexer = Indexer.newIndexer(undirectedGraph, 1);
                undirectedLabeler = StringLabeller.getLabeller(undirectedGraph);
            }
            StringLabeller directedLabeler = StringLabeller.getLabeller(directedGraph);
            String currentVertexLabel = null;
            Vertex currentVertex = null;
            while (!(currentLine = reader.readLine().trim()).startsWith("*")) {
                tokenizer = new StringTokenizer(currentLine);
                currentSourceId = Integer.parseInt(tokenizer.nextToken());
                int openQuotePos = currentLine.indexOf("\"");
                int closeQuotePos = currentLine.lastIndexOf("\"");
                if (openQuotePos <= 0 || openQuotePos == closeQuotePos) continue;
                currentVertexLabel = currentLine.substring(openQuotePos + 1, closeQuotePos);
                currentVertex = (Vertex)directedGraphIndexer.getVertex(currentSourceId);
                directedLabeler.setLabel(currentVertex, currentVertexLabel);
                if (this.mCreateDirectedOnly) continue;
                currentVertex = (Vertex)undirectedGraphIndexer.getVertex(currentSourceId);
                undirectedLabeler.setLabel(currentVertex, currentVertexLabel);
            }
            int currentTargetId = -1;
            boolean directed = false;
            boolean isList = false;
            SparseGraph graph = null;
            Indexer id = null;
            if (currentLine.toLowerCase().indexOf("list") >= 0) {
                isList = true;
            }
            if (currentLine.toLowerCase().indexOf("arc") >= 0) {
                directed = true;
                graph = directedGraph;
                undirectedGraph = null;
                undirectedLabeler = null;
                id = directedGraphIndexer;
            } else if (this.mCreateDirectedOnly) {
                graph = directedGraph;
                undirectedGraph = null;
                undirectedGraphIndexer = null;
                directedLabeler = null;
                id = directedGraphIndexer;
            } else {
                graph = undirectedGraph;
                directedGraph = null;
                directedGraphIndexer = null;
                id = undirectedGraphIndexer;
            }
            block5: while ((currentLine = reader.readLine()) != null && (currentLine = currentLine.trim()).length() != 0) {
                if (currentLine.startsWith("*")) continue;
                tokenizer = new StringTokenizer(currentLine);
                currentSourceId = Integer.parseInt(tokenizer.nextToken());
                Edge currentEdge1 = null;
                Edge currentEdge2 = null;
                while (tokenizer.hasMoreTokens() && currentSourceId != (currentTargetId = Integer.parseInt(tokenizer.nextToken()))) {
                    Vertex target;
                    Vertex source = (Vertex)id.getVertex(currentSourceId);
                    if (!source.isPredecessorOf(target = (Vertex)id.getVertex(currentTargetId))) {
                        currentEdge1 = GraphUtils.addEdge(graph, source, target);
                    }
                    if (this.mCreateDirectedOnly && !directed && !target.isPredecessorOf(source)) {
                        currentEdge2 = GraphUtils.addEdge(graph, target, source);
                    }
                    String[] edgeKeys = this.getEdgeKeys();
                    if (!isList && edgeKeys != null) {
                        int numTokens = tokenizer.countTokens();
                        numTokens = Math.min(numTokens, edgeKeys.length);
                        for (int edgeDescIdx = 0; edgeDescIdx < numTokens; ++edgeDescIdx) {
                            double val = Double.parseDouble(tokenizer.nextToken());
                            currentEdge1.setUserDatum(edgeKeys[edgeDescIdx], new MutableDouble(val), UserData.SHARED);
                            if (currentEdge2 == null) continue;
                            currentEdge2.setUserDatum(edgeKeys[edgeDescIdx], new MutableDouble(val), UserData.SHARED);
                        }
                        continue block5;
                    }
                    if (!isList) continue block5;
                }
            }
            return graph;
        }
        catch (IOException ioe) {
            throw new FatalException("I/O error in reading file: ", ioe);
        }
        catch (ParseException pe) {
            throw new FatalException("Parse exception in reading graph", pe);
        }
        catch (StringLabeller.UniqueLabelException sle) {
            throw new FatalException("Repeated vertex label in graph", sle);
        }
    }

    public void save(Graph graph, String filename) {
        try {
            BufferedWriter writer = new BufferedWriter(new FileWriter(filename));
            writer.write("*Vertices " + graph.getVertices().size() + "\n");
            Vertex currentVertex = null;
            Indexer id = Indexer.newIndexer(graph, 1);
            StringLabeller labeller = StringLabeller.getLabeller(graph);
            Iterator i = graph.getVertices().iterator();
            while (i.hasNext()) {
                currentVertex = (Vertex)i.next();
                if (labeller.getLabel(currentVertex) != null) {
                    writer.write(id.getIndex(currentVertex) + " \"" + labeller.getLabel(currentVertex) + "\"\n");
                    continue;
                }
                writer.write(id.getIndex(currentVertex) + "\n");
            }
            Set d_set = new HashSet();
            Set u_set = new HashSet();
            boolean directed = PredicateUtils.enforcesDirected(graph);
            boolean undirected = PredicateUtils.enforcesUndirected(graph);
            if (directed) {
                d_set = graph.getEdges();
            }
            if (undirected) {
                u_set = graph.getEdges();
            }
            if (!directed && !undirected) {
                d_set = PredicateUtils.getEdges(graph, Graph.DIRECTED_EDGE);
                u_set = PredicateUtils.getEdges(graph, Graph.UNDIRECTED_EDGE);
            }
            if (!d_set.isEmpty()) {
                writer.write("*Arcs\n");
            }
            Iterator eIt = d_set.iterator();
            while (eIt.hasNext()) {
                DirectedEdge currentEdge = (DirectedEdge)eIt.next();
                Vertex source = currentEdge.getSource();
                Vertex target = currentEdge.getDest();
                writer.write(id.getIndex(source) + " " + id.getIndex(target) + "\n");
            }
            if (!u_set.isEmpty()) {
                writer.write("*Edges\n");
            }
            eIt = u_set.iterator();
            while (eIt.hasNext()) {
                UndirectedEdge e = (UndirectedEdge)eIt.next();
                Pair endpoints = e.getEndpoints();
                Vertex v1 = (Vertex)endpoints.getFirst();
                Vertex v2 = (Vertex)endpoints.getSecond();
                writer.write(id.getIndex(v1) + " " + id.getIndex(v2) + "\n");
            }
            writer.close();
        }
        catch (Exception e) {
            throw new FatalException("Error saving file: " + filename, e);
        }
    }
}

