/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.graph.impl;

import edu.uci.ics.jung.graph.ArchetypeEdge;
import edu.uci.ics.jung.graph.ArchetypeGraph;
import edu.uci.ics.jung.graph.ArchetypeVertex;
import edu.uci.ics.jung.graph.Edge;
import edu.uci.ics.jung.graph.Graph;
import edu.uci.ics.jung.graph.Vertex;
import edu.uci.ics.jung.graph.impl.AbstractArchetypeVertex;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public abstract class AbstractSparseVertex
extends AbstractArchetypeVertex
implements Vertex,
Cloneable {
    private static int nextGlobalVertexID = 0;

    protected AbstractSparseVertex() {
        this.id = nextGlobalVertexID++;
        this.initialize();
    }

    public Edge findEdge(Vertex v) {
        Iterator iter = this.getOutEdges().iterator();
        while (iter.hasNext()) {
            Edge element = (Edge)iter.next();
            if (!element.getOpposite(this).equals(v)) continue;
            return element;
        }
        return null;
    }

    public ArchetypeEdge findEdge(ArchetypeVertex v) {
        return this.findEdge((Vertex)v);
    }

    public Set findEdgeSet(Vertex v) {
        HashSet<Edge> edgeSet = new HashSet<Edge>();
        Iterator iter = this.getOutEdges().iterator();
        while (iter.hasNext()) {
            Edge element = (Edge)iter.next();
            if (!element.getOpposite(this).equals(v)) continue;
            edgeSet.add(element);
        }
        return edgeSet;
    }

    public Set findEdgeSet(ArchetypeVertex v) {
        return this.findEdgeSet((Vertex)v);
    }

    public ArchetypeVertex copy(ArchetypeGraph newGraph) {
        AbstractSparseVertex v = (AbstractSparseVertex)super.copy(newGraph);
        ((Graph)newGraph).addVertex(v);
        return v;
    }

    protected abstract void addNeighbor_internal(Edge var1, Vertex var2);

    protected abstract void removeNeighbor_internal(Edge var1, Vertex var2);

    public String toString() {
        return "V" + String.valueOf(this.id);
    }
}

