/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.cabos;

import com.limegroup.gnutella.Endpoint;
import com.limegroup.gnutella.GUID;
import com.limegroup.gnutella.ManagedConnection;
import com.limegroup.gnutella.MediaType;
import com.limegroup.gnutella.RemoteFileDesc;
import com.limegroup.gnutella.RouterService;
import com.limegroup.gnutella.Uploader;
import com.limegroup.gnutella.downloader.AlreadyDownloadingException;
import com.limegroup.gnutella.downloader.CantResumeException;
import com.limegroup.gnutella.downloader.FileExistsException;
import com.limegroup.gnutella.downloader.ManagedDownloader;
import com.limegroup.gnutella.search.HostData;
import com.limegroup.gnutella.settings.ApplicationSettings;
import com.limegroup.gnutella.settings.ConnectionSettings;
import com.limegroup.gnutella.settings.DownloadSettings;
import com.limegroup.gnutella.settings.FilterSettings;
import com.limegroup.gnutella.settings.SharingSettings;
import com.limegroup.gnutella.settings.UltrapeerSettings;
import com.limegroup.gnutella.settings.UploadSettings;
import com.limegroup.gnutella.util.FileUtils;
import com.limegroup.gnutella.util.NetworkUtils;
import com.sun.java.util.collections.ArrayList;
import com.sun.java.util.collections.Collection;
import com.sun.java.util.collections.HashSet;
import com.sun.java.util.collections.Iterator;
import com.sun.java.util.collections.LinkedList;
import com.sun.java.util.collections.List;
import com.sun.java.util.collections.Map;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import jp.sourceforge.cabos.AqEventHandler;
import jp.sourceforge.cabos.AqMain;
import jp.sourceforge.cabos.AqResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class AqDispatcher {
    private static final Log LOG = LogFactory.getLog((Class)(class$jp$sourceforge$cabos$AqDispatcher == null ? (class$jp$sourceforge$cabos$AqDispatcher = AqDispatcher.class$("jp.sourceforge.cabos.AqDispatcher")) : class$jp$sourceforge$cabos$AqDispatcher));
    private static int currentQueryIndex = -1;
    static /* synthetic */ Class class$jp$sourceforge$cabos$AqDispatcher;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void dispatchCommand(List list) throws Throwable {
        block146: {
            int n;
            String string = (String)list.get(0);
            String string2 = list.size() > 1 ? (String)list.get(1) : "";
            try {
                n = new Integer(string2);
            }
            catch (NumberFormatException numberFormatException) {
                n = 0;
            }
            if (string.equals("")) {
                return;
            }
            if (string.equals("query")) {
                GUID gUID = new GUID(RouterService.newQueryGUID());
                Integer n2 = new Integer(++currentQueryIndex);
                AqEventHandler.queries.put((Object)gUID, (Object)n2);
                AqEventHandler.indices.put((Object)n2, (Object)gUID);
                try {
                    RouterService.query(gUID.bytes(), string2, "", null);
                }
                catch (Throwable throwable) {
                    LOG.error((Object)throwable);
                }
            } else if (string.equals("queryFindMoreSources")) {
                GUID gUID = new GUID(RouterService.newQueryGUID());
                Integer n3 = new Integer(++currentQueryIndex);
                AqEventHandler.queries.put((Object)gUID, (Object)n3);
                AqEventHandler.indices.put((Object)n3, (Object)gUID);
                MediaType mediaType = null;
                String string3 = FileUtils.getFileExtension(string2);
                if (string3 != null) {
                    mediaType = MediaType.getMediaTypeForExtension(string3);
                }
                try {
                    RouterService.query(gUID.bytes(), string2, "", mediaType);
                }
                catch (Throwable throwable) {
                    LOG.error((Object)throwable);
                }
            } else if (string.equals("queryWhatIsNew")) {
                GUID gUID = new GUID(RouterService.newQueryGUID());
                Integer n4 = new Integer(++currentQueryIndex);
                AqEventHandler.queries.put((Object)gUID, (Object)n4);
                AqEventHandler.indices.put((Object)n4, (Object)gUID);
                RouterService.queryWhatIsNew(gUID.bytes(), null);
            } else if (string.equals("doBrowseHost")) {
                int n5;
                String string4;
                GUID gUID = new GUID(RouterService.newQueryGUID());
                Integer n6 = new Integer(++currentQueryIndex);
                AqEventHandler.queries.put((Object)gUID, (Object)n6);
                AqEventHandler.indices.put((Object)n6, (Object)gUID);
                if (string2.equals("localhost")) {
                    string4 = NetworkUtils.ip2string(RouterService.getExternalAddress());
                    n5 = RouterService.getPort();
                } else {
                    string4 = string2;
                    try {
                        n5 = new Integer((String)list.get(2));
                    }
                    catch (NumberFormatException numberFormatException) {
                        n5 = 6346;
                    }
                }
                HostData hostData = (HostData)AqEventHandler.hosts.get((Object)(string4 + ":" + n5));
                if (hostData != null) {
                    RouterService.doAsynchronousBrowseHost(string4, n5, gUID, new GUID(hostData.getClientGUID()), hostData.getPushProxies());
                } else {
                    RouterService.doAsynchronousBrowseHost(string4, n5, gUID, null, null);
                }
            } else if (string.equals("removeQuery")) {
                for (int i = 1; i < list.size(); ++i) {
                    Integer n7 = new Integer((String)list.get(i));
                    GUID gUID = (GUID)AqEventHandler.indices.get((Object)n7);
                    RouterService.stopQuery(gUID);
                    AqEventHandler.queries.remove((Object)gUID);
                    AqEventHandler.indices.remove((Object)n7);
                }
            } else if (string.equals("removeAllQueries")) {
                Map map = AqEventHandler.queries;
                synchronized (map) {
                    Iterator iterator = AqEventHandler.queries.keySet().iterator();
                    while (iterator.hasNext()) {
                        RouterService.stopQuery((GUID)iterator.next());
                    }
                }
                AqEventHandler.queries.clear();
                AqEventHandler.indices.clear();
                AqEventHandler.responses.clear();
            } else if (string.equals("clearAllResults")) {
                for (int i = 1; i < list.size(); ++i) {
                    String string5 = (String)list.get(i) + ":";
                    Map map = AqEventHandler.responses;
                    synchronized (map) {
                        Iterator iterator = AqEventHandler.responses.keySet().iterator();
                        while (iterator.hasNext()) {
                            String string6 = (String)iterator.next();
                            if (!string6.startsWith(string5)) continue;
                            iterator.remove();
                        }
                        continue;
                    }
                }
            } else if (string.equals("download")) {
                RemoteFileDesc remoteFileDesc;
                Object object;
                HashSet hashSet = new HashSet();
                HashSet hashSet2 = new HashSet();
                GUID gUID = null;
                for (int i = 1; i < list.size(); ++i) {
                    object = (String)list.get(i);
                    AqResponse aqResponse = (AqResponse)AqEventHandler.responses.get(object);
                    gUID = new GUID(aqResponse.getData().getMessageGUID());
                    hashSet.add((Object)aqResponse.getRFD());
                    hashSet2.addAll((Collection)aqResponse.getLocs());
                }
                RemoteFileDesc[] remoteFileDescArray = (RemoteFileDesc[])hashSet.toArray((Object[])new RemoteFileDesc[hashSet.size()]);
                object = null;
                for (int i = 0; i < remoteFileDescArray.length; ++i) {
                    remoteFileDesc = remoteFileDescArray[i];
                    remoteFileDesc.setDownloading(true);
                    remoteFileDesc.setRetryAfter(0);
                    if (remoteFileDesc.getSHA1Urn() != null) {
                        object = remoteFileDesc;
                    }
                    hashSet2.remove((Object)new Endpoint(remoteFileDesc.getHost(), remoteFileDesc.getPort()));
                }
                if (object == null) {
                    object = remoteFileDescArray[0];
                }
                LinkedList linkedList = new LinkedList();
                remoteFileDesc = hashSet2.iterator();
                while (remoteFileDesc.hasNext()) {
                    Endpoint endpoint = (Endpoint)remoteFileDesc.next();
                    linkedList.add((Object)new RemoteFileDesc((RemoteFileDesc)object, endpoint));
                }
                try {
                    RouterService.download(remoteFileDescArray, (List)linkedList, true, gUID);
                }
                catch (AlreadyDownloadingException alreadyDownloadingException) {
                }
                catch (FileExistsException fileExistsException) {
                }
                catch (FileNotFoundException fileNotFoundException) {}
            } else if (string.equals("retryDownload")) {
                Iterator iterator = RouterService.getDownloadManager().getDownloads();
                while (iterator.hasNext()) {
                    ManagedDownloader managedDownloader = (ManagedDownloader)iterator.next();
                    if (managedDownloader.hashCode() != n) continue;
                    try {
                        managedDownloader.resume();
                    }
                    catch (AlreadyDownloadingException alreadyDownloadingException) {}
                }
            } else if (string.equals("cancelDownload")) {
                Iterator iterator = RouterService.getDownloadManager().getDownloads();
                while (iterator.hasNext()) {
                    ManagedDownloader managedDownloader = (ManagedDownloader)iterator.next();
                    if (managedDownloader.hashCode() != n) continue;
                    managedDownloader.cancel();
                }
            } else if (string.equals("cancelUpload")) {
                Iterator iterator = RouterService.getUploadManager().getUploads();
                while (iterator.hasNext()) {
                    Uploader uploader = (Uploader)iterator.next();
                    if (uploader.hashCode() != n) continue;
                    uploader.stop();
                }
            } else if (string.equals("closeConnection")) {
                int n8 = new Integer((String)list.get(2));
                Iterator iterator = RouterService.getConnectionManager().getConnections().iterator();
                while (iterator.hasNext()) {
                    ManagedConnection managedConnection = (ManagedConnection)iterator.next();
                    if (!managedConnection.getAddress().equals(string2) || managedConnection.getPort() != n8) continue;
                    RouterService.removeConnection(managedConnection);
                }
            } else if (string.equals("awakeConnection")) {
                RouterService.disconnect();
                RouterService.connect();
            } else if (string.equals("setMaxSimDownload")) {
                DownloadSettings.MAX_SIM_DOWNLOAD.setValue(n);
            } else if (string.equals("setMaxUploads")) {
                UploadSettings.HARD_MAX_UPLOADS.setValue(n);
            } else if (string.equals("setUploadsPerPerson")) {
                UploadSettings.UPLOADS_PER_PERSON.setValue(n);
            } else if (string.equals("setUploadSpeed")) {
                UploadSettings.UPLOAD_SPEED.setValue(n);
            } else if (string.equals("setAllowPartialSharing")) {
                UploadSettings.ALLOW_PARTIAL_SHARING.setValue(n == 1);
            } else if (string.equals("setConnectionSpeed")) {
                ConnectionSettings.CONNECTION_SPEED.setValue(n);
            } else if (string.equals("setPort")) {
                if (NetworkUtils.isValidPort(n)) {
                    ConnectionSettings.PORT.setValue(n);
                } else {
                    ConnectionSettings.PORT.revertToDefault();
                }
            } else if (string.equals("setUPnPType")) {
                if (n == 0 || n == 1) {
                    ConnectionSettings.FORCE_IP_ADDRESS.setValue(true);
                } else if (n == 2) {
                    ConnectionSettings.FORCE_IP_ADDRESS.setValue(false);
                }
            } else if (string.equals("setUsesLocalePreferencing")) {
                ConnectionSettings.USE_LOCALE_PREF.setValue(n == 1);
            } else if (string.equals("setProxyType")) {
                ConnectionSettings.CONNECTION_METHOD.setValue(n);
            } else if (string.equals("setProxyServer")) {
                ConnectionSettings.PROXY_HOST.setValue(string2);
            } else if (string.equals("setProxyPort")) {
                ConnectionSettings.PROXY_PORT.setValue(n);
            } else if (string.equals("setProxyUsername")) {
                ConnectionSettings.PROXY_USERNAME.setValue(string2);
            } else if (string.equals("setProxyPassword")) {
                ConnectionSettings.PROXY_PASS.setValue(string2);
            } else if (string.equals("setProxyPrivate")) {
                ConnectionSettings.USE_PROXY_FOR_PRIVATE.setValue(n == 1);
            } else if (string.equals("setRequiresAuthentication")) {
                ConnectionSettings.PROXY_AUTHENTICATE.setValue(n == 1);
            } else if (string.equals("setEnableUltrapeer")) {
                UltrapeerSettings.DISABLE_ULTRAPEER_MODE.setValue(n == 0);
            } else if (string.equals("setAdultFilter")) {
                FilterSettings.FILTER_WHATS_NEW_ADULT.setValue(n == 1);
                FilterSettings.FILTER_ADULT.setValue(n == 1);
            } else if (string.equals("setBannedIPs")) {
                ArrayList arrayList = new ArrayList();
                for (int i = 1; i < list.size(); ++i) {
                    arrayList.add(list.get(i));
                }
                String[] stringArray = (String[])arrayList.toArray((Object[])new String[arrayList.size()]);
                FilterSettings.BLACK_LISTED_IP_ADDRESSES.setValue(stringArray);
            } else if (string.equals("setBannedKeywords")) {
                ArrayList arrayList = new ArrayList();
                for (int i = 1; i < list.size(); ++i) {
                    String string7 = (String)list.get(i);
                    if (string7.length() == 0) continue;
                    arrayList.add((Object)string7);
                }
                String[] stringArray = (String[])arrayList.toArray((Object[])new String[arrayList.size()]);
                FilterSettings.BANNED_WORDS.setValue(stringArray);
            } else if (string.equals("applyFilterSettings")) {
                RouterService.adjustSpamFilters();
            } else if (string.equals("setDirectories")) {
                HashSet hashSet = new HashSet();
                for (int i = 1; i < list.size(); ++i) {
                    File file;
                    String string8 = (String)list.get(i);
                    if (string8.equals("") || (file = new File(string8)) == null) continue;
                    hashSet.add((Object)file);
                }
                File[] fileArray = (File[])hashSet.toArray((Object[])new File[hashSet.size()]);
                SharingSettings.DIRECTORIES_TO_SHARE.setValue(fileArray);
            } else if (string.equals("applyDirectories")) {
                RouterService.getFileManager().loadSettings(false);
            } else if (string.equals("setSaveDirectory")) {
                try {
                    if (string2.equals("")) {
                        SharingSettings.setSaveDirectory(SharingSettings.DEFAULT_SAVE_DIR);
                        break block146;
                    }
                    SharingSettings.setSaveDirectory(new File(string2));
                }
                catch (IOException iOException) {
                    LOG.error((Object)iOException);
                    SharingSettings.DIRECTORY_FOR_SAVING_FILES.revertToDefault();
                }
            } else if (string.equals("applySaveDirectory")) {
                File[] fileArray = SharingSettings.INCOMPLETE_DIRECTORY.getValue().listFiles();
                for (int i = 0; i < fileArray.length; ++i) {
                    try {
                        RouterService.download(fileArray[i]);
                        continue;
                    }
                    catch (AlreadyDownloadingException alreadyDownloadingException) {
                        continue;
                    }
                    catch (CantResumeException cantResumeException) {
                        // empty catch block
                    }
                }
            } else if (string.equals("setIncompletePurgeTime")) {
                SharingSettings.INCOMPLETE_PURGE_TIME.setValue(n);
            } else if (string.equals("setAllowFreeloaders")) {
                if (n == 1) {
                    SharingSettings.FREELOADER_ALLOWED.setValue(100);
                } else {
                    SharingSettings.FREELOADER_ALLOWED.setValue(0);
                }
            } else if (string.equals("setFreeloaderFiles")) {
                SharingSettings.FREELOADER_FILES.setValue(n);
            } else if (string.equals("setLanguage")) {
                if (string2.equals("")) {
                    ApplicationSettings.LANGUAGE.revertToDefault();
                } else {
                    ApplicationSettings.LANGUAGE.setValue(string2);
                }
            } else if (string.equals("start")) {
                AqMain.start();
            } else if (string.equals("shutdown")) {
                RouterService.shutdown();
                AqMain.shutdown();
            } else {
                LOG.warn((Object)("Unhandled command: " + list));
            }
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

