/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.xml;

import com.limegroup.gnutella.Assert;
import com.limegroup.gnutella.CreationTimeCache;
import com.limegroup.gnutella.ErrorService;
import com.limegroup.gnutella.FileDesc;
import com.limegroup.gnutella.FileManager;
import com.limegroup.gnutella.Response;
import com.limegroup.gnutella.RouterService;
import com.limegroup.gnutella.messages.QueryRequest;
import com.limegroup.gnutella.mp3.ID3Reader;
import com.limegroup.gnutella.util.NameValue;
import com.limegroup.gnutella.xml.LimeXMLDocument;
import com.limegroup.gnutella.xml.LimeXMLReplyCollection;
import com.limegroup.gnutella.xml.LimeXMLSchema;
import com.limegroup.gnutella.xml.LimeXMLSchemaRepository;
import com.limegroup.gnutella.xml.LimeXMLUtils;
import com.limegroup.gnutella.xml.RichQueryHandler;
import com.limegroup.gnutella.xml.SchemaNotFoundException;
import com.limegroup.gnutella.xml.SchemaReplyCollectionMapper;
import com.sun.java.util.collections.ArrayList;
import com.sun.java.util.collections.Collection;
import com.sun.java.util.collections.HashSet;
import com.sun.java.util.collections.Iterator;
import com.sun.java.util.collections.LinkedList;
import com.sun.java.util.collections.List;
import java.io.File;
import java.io.IOException;

public class MetaFileManager
extends FileManager {
    private final Object META_LOCK = new Object();

    public synchronized Response[] query(QueryRequest queryRequest) {
        Response[] responseArray;
        LimeXMLDocument limeXMLDocument;
        Response[] responseArray2 = super.query(queryRequest);
        if (this.shouldIncludeXMLInResponse(queryRequest) && (limeXMLDocument = queryRequest.getRichQuery()) != null && (responseArray = RichQueryHandler.instance().query(limeXMLDocument)) != null) {
            responseArray2 = this.union(responseArray2, responseArray);
        }
        return responseArray2;
    }

    protected boolean shouldIncludeXMLInResponse(QueryRequest queryRequest) {
        return queryRequest.desiresXMLResponses() || queryRequest.desiresOutOfBandReplies();
    }

    protected void addXMLToResponse(Response response, FileDesc fileDesc) {
        List list = fileDesc.getLimeXMLDocuments();
        if (list.size() == 0) {
            return;
        }
        if (list.size() == 1) {
            response.setDocument((LimeXMLDocument)list.get(0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FileDesc fileChanged(File file) {
        Object object;
        FileDesc fileDesc = this.getFileDescForFile(file);
        if (fileDesc == null) {
            return null;
        }
        CreationTimeCache creationTimeCache = CreationTimeCache.instance();
        Long l = creationTimeCache.getCreationTime(fileDesc.getSHA1Urn());
        List list = fileDesc.getLimeXMLDocuments();
        if (LimeXMLUtils.isMP3File(file)) {
            try {
                object = ID3Reader.readDocument(file);
                list = this.resolveAudioDocs(list, (LimeXMLDocument)object);
            }
            catch (IOException iOException) {
                return super.fileChanged(file);
            }
        }
        if (fileDesc != (object = this.removeFileIfShared(file))) {
            Assert.that(false, "wanted to remove: " + fileDesc + "\ndid remove: " + object);
        }
        FileManager._needRebuild = true;
        fileDesc = this.addFileIfShared(file, list);
        if (fileDesc != null && l != null) {
            CreationTimeCache creationTimeCache2 = creationTimeCache;
            synchronized (creationTimeCache2) {
                creationTimeCache.removeTime(fileDesc.getSHA1Urn());
                creationTimeCache.addTime(fileDesc.getSHA1Urn(), l);
                creationTimeCache.commitTime(fileDesc.getSHA1Urn());
            }
        }
        return fileDesc;
    }

    private List resolveAudioDocs(List list, LimeXMLDocument limeXMLDocument) {
        LimeXMLDocument limeXMLDocument2;
        LimeXMLDocument limeXMLDocument3 = null;
        LimeXMLSchema limeXMLSchema = LimeXMLSchemaRepository.instance().getSchema("http://www.limewire.com/schemas/audio.xsd");
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            limeXMLDocument2 = (LimeXMLDocument)iterator.next();
            if (limeXMLDocument2.getSchema() != limeXMLSchema) continue;
            limeXMLDocument3 = limeXMLDocument2;
            break;
        }
        if (limeXMLDocument.equals(limeXMLDocument3)) {
            return list;
        }
        iterator = new ArrayList();
        iterator.addAll((Collection)list);
        if (limeXMLDocument3 == null) {
            iterator.add((Object)limeXMLDocument);
            return iterator;
        }
        iterator.remove((Object)limeXMLDocument3);
        limeXMLDocument2 = null;
        List list2 = null;
        try {
            limeXMLDocument2 = limeXMLDocument3.getOrderedNameValueList();
            list2 = limeXMLDocument.getOrderedNameValueList();
        }
        catch (SchemaNotFoundException schemaNotFoundException) {
            ErrorService.error(schemaNotFoundException);
        }
        for (int i = 0; i < limeXMLDocument2.size(); ++i) {
            NameValue nameValue = (NameValue)limeXMLDocument2.get(i);
            if (!ID3Reader.isNonID3Field(nameValue.getName())) continue;
            list2.add((Object)nameValue);
        }
        limeXMLDocument3 = new LimeXMLDocument((Collection)list2, "http://www.limewire.com/schemas/audio.xsd");
        iterator.add((Object)limeXMLDocument3);
        return iterator;
    }

    public FileDesc removeFileIfShared(File file) {
        FileDesc fileDesc = super.removeFileIfShared(file);
        if (fileDesc == null) {
            return null;
        }
        SchemaReplyCollectionMapper schemaReplyCollectionMapper = SchemaReplyCollectionMapper.instance();
        List list = fileDesc.getLimeXMLDocuments();
        LinkedList linkedList = new LinkedList();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            linkedList.add((Object)((LimeXMLDocument)iterator.next()).getSchemaURI());
        }
        iterator = linkedList.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            LimeXMLReplyCollection limeXMLReplyCollection = schemaReplyCollectionMapper.getReplyCollection(string);
            if (limeXMLReplyCollection == null) continue;
            limeXMLReplyCollection.removeDoc(fileDesc);
        }
        FileManager._needRebuild = true;
        return fileDesc;
    }

    public FileDesc addFileIfShared(File file, List list) {
        Object object;
        FileDesc fileDesc = super.addFileIfShared(file);
        if (fileDesc == null) {
            return null;
        }
        if (list == null || list.size() == 0) {
            if (!LimeXMLUtils.isMP3File(file)) {
                return fileDesc;
            }
            try {
                object = ID3Reader.readDocument(file);
            }
            catch (IOException iOException) {
                return fileDesc;
            }
            list = new LinkedList();
            list.add(object);
        }
        object = SchemaReplyCollectionMapper.instance();
        LinkedList linkedList = new LinkedList();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            LimeXMLDocument limeXMLDocument = (LimeXMLDocument)iterator.next();
            String string = limeXMLDocument.getSchemaURI();
            LimeXMLReplyCollection limeXMLReplyCollection = ((SchemaReplyCollectionMapper)object).getReplyCollection(string);
            if (limeXMLReplyCollection == null || linkedList.contains((Object)string)) continue;
            linkedList.add((Object)string);
            if (ID3Reader.isCorrupted(limeXMLDocument)) {
                limeXMLDocument = ID3Reader.fixCorruption(limeXMLDocument);
            }
            limeXMLReplyCollection.addReplyWithCommit(file, fileDesc, limeXMLDocument, true);
        }
        FileManager._needRebuild = true;
        return fileDesc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void loadSettingsBlocking(boolean bl) {
        RouterService.getCallback().setAnnotateEnabled(false);
        super.loadSettingsBlocking(bl);
        if (this.loadThreadInterrupted()) {
            return;
        }
        Object object = this.META_LOCK;
        synchronized (object) {
            SchemaReplyCollectionMapper schemaReplyCollectionMapper = SchemaReplyCollectionMapper.instance();
            LimeXMLSchemaRepository limeXMLSchemaRepository = LimeXMLSchemaRepository.instance();
            if (this.loadThreadInterrupted()) {
                return;
            }
            String[] stringArray = limeXMLSchemaRepository.getAvailableSchemaURIs();
            int n = stringArray.length;
            FileDesc[] fileDescArray = super.getAllSharedFileDescriptors();
            for (int i = 0; i < n && !this.loadThreadInterrupted(); ++i) {
                String string = LimeXMLSchema.getDisplayString(stringArray[i]);
                LimeXMLReplyCollection limeXMLReplyCollection = new LimeXMLReplyCollection(fileDescArray, stringArray[i], string.equalsIgnoreCase("audio"));
                schemaReplyCollectionMapper.add(stringArray[i], limeXMLReplyCollection);
            }
        }
        RouterService.getCallback().setAnnotateEnabled(true);
    }

    private Response[] union(Response[] responseArray, Response[] responseArray2) {
        int n;
        if (responseArray == null) {
            return responseArray2;
        }
        if (responseArray2 == null) {
            return responseArray;
        }
        HashSet hashSet = new HashSet();
        for (n = 0; n < responseArray2.length; ++n) {
            hashSet.add((Object)responseArray2[n]);
        }
        for (n = 0; n < responseArray.length; ++n) {
            hashSet.add((Object)responseArray[n]);
        }
        Object[] objectArray = new Response[hashSet.size()];
        objectArray = (Response[])hashSet.toArray(objectArray);
        return objectArray;
    }

    protected void buildQRT() {
        super.buildQRT();
        Iterator iterator = this.getXMLKeyWords().iterator();
        while (iterator.hasNext()) {
            FileManager._queryRouteTable.add((String)iterator.next());
        }
        iterator = this.getXMLIndivisibleKeyWords().iterator();
        while (iterator.hasNext()) {
            FileManager._queryRouteTable.addIndivisible((String)iterator.next());
        }
    }

    private List getXMLKeyWords() {
        ArrayList arrayList = new ArrayList();
        SchemaReplyCollectionMapper schemaReplyCollectionMapper = SchemaReplyCollectionMapper.instance();
        LimeXMLSchemaRepository limeXMLSchemaRepository = LimeXMLSchemaRepository.instance();
        String[] stringArray = limeXMLSchemaRepository.getAvailableSchemaURIs();
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            LimeXMLReplyCollection limeXMLReplyCollection = schemaReplyCollectionMapper.getReplyCollection(stringArray[i]);
            if (limeXMLReplyCollection == null) continue;
            arrayList.addAll((Collection)limeXMLReplyCollection.getKeyWords());
        }
        return arrayList;
    }

    private List getXMLIndivisibleKeyWords() {
        ArrayList arrayList = new ArrayList();
        LimeXMLSchemaRepository limeXMLSchemaRepository = LimeXMLSchemaRepository.instance();
        String[] stringArray = limeXMLSchemaRepository.getAvailableSchemaURIs();
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i] == null) continue;
            arrayList.add((Object)stringArray[i]);
        }
        return arrayList;
    }
}

