/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.util;

import com.limegroup.gnutella.Assert;
import com.limegroup.gnutella.util.Function;
import com.limegroup.gnutella.util.TrieEdge;
import com.limegroup.gnutella.util.TrieNode;
import com.limegroup.gnutella.util.UnmodifiableIterator;
import com.sun.java.util.collections.ArrayList;
import com.sun.java.util.collections.Iterator;
import com.sun.java.util.collections.NoSuchElementException;
import java.util.Locale;

public class Trie {
    private TrieNode root;
    private boolean ignoreCase;
    private static final Iterator EMPTY_ITERATOR = new EmptyIterator();

    public Trie(boolean bl) {
        this.ignoreCase = bl;
        this.clear();
    }

    public void clear() {
        this.root = new TrieNode();
    }

    public String canonicalCase(String string) {
        if (!this.ignoreCase) {
            return string;
        }
        return string.toUpperCase(Locale.US).toLowerCase(Locale.US);
    }

    private final int match(String string, int n, int n2, String string2) {
        int n3 = n;
        for (int i = 0; i < string2.length(); ++i) {
            if (n3 >= n2) {
                return i;
            }
            if (string.charAt(n3) != string2.charAt(i)) {
                return i;
            }
            ++n3;
        }
        return -1;
    }

    public Object add(String string, Object object) {
        Object object2;
        Object object3;
        string = this.canonicalCase(string);
        TrieNode trieNode = this.root;
        for (int i = 0; i < string.length(); i += ((String)object3).length()) {
            object2 = trieNode.get(string.charAt(i));
            if (object2 == null) {
                object3 = new TrieNode(object);
                trieNode.put(string.substring(i), (TrieNode)object3);
                return null;
            }
            object3 = ((TrieEdge)object2).getLabel();
            int n = this.match(string, i, string.length(), (String)object3);
            Assert.that(n != 0, "Label didn't start with prefix[0].");
            if (n >= 0) {
                TrieNode trieNode2 = ((TrieEdge)object2).getChild();
                TrieNode trieNode3 = new TrieNode();
                String string2 = ((String)object3).substring(0, n);
                String string3 = ((String)object3).substring(n);
                String string4 = string.substring(i + n);
                if (string4.length() > 0) {
                    TrieNode trieNode4 = new TrieNode(object);
                    trieNode.remove(((String)object3).charAt(0));
                    trieNode.put(string2, trieNode3);
                    trieNode3.put(string3, trieNode2);
                    trieNode3.put(string4, trieNode4);
                } else {
                    trieNode.remove(((String)object3).charAt(0));
                    trieNode.put(string2, trieNode3);
                    trieNode3.put(string3, trieNode2);
                    trieNode3.setValue(object);
                }
                return null;
            }
            Assert.that(n == -1, "Bad return value from match: " + i);
            trieNode = ((TrieEdge)object2).getChild();
        }
        object2 = trieNode.getValue();
        trieNode.setValue(object);
        return object2;
    }

    private TrieNode fetch(String string) {
        String string2;
        TrieNode trieNode = this.root;
        for (int i = 0; i < string.length(); i += string2.length()) {
            TrieEdge trieEdge = trieNode.get(string.charAt(i));
            if (trieEdge == null) {
                return null;
            }
            string2 = trieEdge.getLabel();
            int n = this.match(string, i, string.length(), string2);
            Assert.that(n != 0, "Label didn't start with prefix[0].");
            if (n != -1) {
                return null;
            }
            trieNode = trieEdge.getChild();
        }
        return trieNode;
    }

    public Object get(String string) {
        TrieNode trieNode = this.fetch(string = this.canonicalCase(string));
        if (trieNode == null) {
            return null;
        }
        return trieNode.getValue();
    }

    public boolean remove(String string) {
        TrieNode trieNode = this.fetch(string = this.canonicalCase(string));
        if (trieNode == null) {
            return false;
        }
        boolean bl = trieNode.getValue() != null;
        trieNode.setValue(null);
        return bl;
    }

    public Iterator getPrefixedBy(String string) {
        string = this.canonicalCase(string);
        return this.getPrefixedBy(string, 0, string.length());
    }

    public Iterator getPrefixedBy(String string, int n, int n2) {
        String string2;
        TrieNode trieNode = this.root;
        for (int i = n; i < n2; i += string2.length()) {
            TrieEdge trieEdge = trieNode.get(string.charAt(i));
            if (trieEdge == null) {
                return EMPTY_ITERATOR;
            }
            trieNode = trieEdge.getChild();
            string2 = trieEdge.getLabel();
            int n3 = this.match(string, i, n2, string2);
            Assert.that(n3 != 0, "Label didn't start with prefix[0].");
            if (i + n3 == n2) break;
            if (n3 >= 0) {
                trieNode = null;
                break;
            }
            Assert.that(n3 == -1, "Bad return value from match: " + i);
        }
        if (trieNode == null) {
            return EMPTY_ITERATOR;
        }
        return new ValueIterator(trieNode);
    }

    public void trim(Function function) throws IllegalArgumentException, ClassCastException {
        if (function != null) {
            NodeIterator nodeIterator = new NodeIterator(this.root, true);
            while (nodeIterator.hasNext()) {
                TrieNode trieNode = (TrieNode)nodeIterator.next();
                trieNode.trim();
                Object object = trieNode.getValue();
                if (object == null) continue;
                trieNode.setValue(function.apply(object));
            }
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<root>");
        this.toStringHelper(this.root, stringBuffer, 1);
        return stringBuffer.toString();
    }

    private void toStringHelper(TrieNode trieNode, StringBuffer stringBuffer, int n) {
        if (trieNode.getValue() != null) {
            stringBuffer.append(" -> ");
            stringBuffer.append(trieNode.getValue().toString());
        }
        stringBuffer.append("\n");
        Iterator iterator = trieNode.labelsForward();
        while (iterator.hasNext()) {
            for (int i = 0; i < n; ++i) {
                stringBuffer.append(" ");
            }
            String string = (String)iterator.next();
            stringBuffer.append(string);
            TrieNode trieNode2 = trieNode.get(string.charAt(0)).getChild();
            this.toStringHelper(trieNode2, stringBuffer, n + 1);
        }
    }

    public class NodeIterator
    extends UnmodifiableIterator {
        private ArrayList stack = new ArrayList();
        private boolean withNulls;

        public NodeIterator(TrieNode trieNode, boolean bl) {
            this.withNulls = bl;
            if (bl || trieNode.getValue() != null) {
                this.stack.add((Object)trieNode);
            } else {
                this.advance(trieNode);
            }
        }

        public boolean hasNext() {
            return !this.stack.isEmpty();
        }

        public Object next() {
            int n = this.stack.size();
            if (n == 0) {
                throw new NoSuchElementException();
            }
            TrieNode trieNode = (TrieNode)this.stack.remove(n - 1);
            this.advance(trieNode);
            return trieNode;
        }

        private void advance(TrieNode trieNode) {
            Iterator iterator = trieNode.childrenForward();
            while (true) {
                if (iterator.hasNext()) {
                    trieNode = (TrieNode)iterator.next();
                    if (iterator.hasNext()) {
                        this.stack.add((Object)iterator);
                    }
                    if (this.withNulls || trieNode.getValue() == null) {
                        iterator = trieNode.childrenForward();
                        continue;
                    }
                    this.stack.add((Object)trieNode);
                    return;
                }
                int n = this.stack.size();
                if (n == 0) {
                    return;
                }
                iterator = (Iterator)this.stack.remove(n - 1);
            }
        }
    }

    private static class EmptyIterator
    extends UnmodifiableIterator {
        private EmptyIterator() {
        }

        public boolean hasNext() {
            return false;
        }

        public Object next() {
            throw new NoSuchElementException();
        }
    }

    private class ValueIterator
    extends NodeIterator {
        ValueIterator(TrieNode trieNode) {
            super(trieNode, false);
        }

        public Object next() {
            return ((TrieNode)super.next()).getValue();
        }
    }
}

