/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.util;

import com.limegroup.gnutella.ErrorService;
import com.limegroup.gnutella.settings.ConnectionSettings;
import com.limegroup.gnutella.util.CommonUtils;
import com.limegroup.gnutella.util.ManagedThread;
import com.limegroup.gnutella.util.NetworkUtils;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;

public class Sockets {
    private static Constructor _inetAddressConstructor;
    private static Class _socketClass;
    private static Class _socketAddressClass;
    private static Method _setKeepAliveMethod;
    private static Method _connectMethod;
    private static volatile int _attempts;
    static /* synthetic */ Class class$java$lang$String;

    private Sockets() {
    }

    public static int getAttempts() {
        return _attempts;
    }

    public static void clearAttempts() {
        _attempts = 0;
    }

    public static boolean setKeepAlive(Socket socket, boolean bl) {
        if (CommonUtils.isJava13OrLater()) {
            try {
                _setKeepAliveMethod.invoke((Object)socket, bl ? Boolean.TRUE : Boolean.FALSE);
                return true;
            }
            catch (IllegalAccessException illegalAccessException) {
                ErrorService.error(illegalAccessException);
            }
            catch (InvocationTargetException invocationTargetException) {
                // empty catch block
            }
        }
        return false;
    }

    public static Socket connect(String string, int n, int n2) throws IOException {
        if (!NetworkUtils.isValidPort(n)) {
            throw new IllegalArgumentException("port out of range: " + n);
        }
        int n3 = ConnectionSettings.CONNECTION_METHOD.getValue();
        if (n3 != 0) {
            InetAddress inetAddress = null;
            try {
                inetAddress = InetAddress.getByName(string);
            }
            catch (UnknownHostException unknownHostException) {
                throw new IOException();
            }
            if (!NetworkUtils.isPrivateAddress(inetAddress) || ConnectionSettings.USE_PROXY_FOR_PRIVATE.getValue()) {
                if (n3 == 1) {
                    return Sockets.connectHTTP(string, n, n2);
                }
                if (n3 == 4) {
                    return Sockets.connectSocksV4(string, n, n2);
                }
                if (n3 == 5) {
                    return Sockets.connectSocksV5(string, n, n2);
                }
            }
        }
        ++_attempts;
        return Sockets.connectPlain(string, n, n2);
    }

    private static Socket connectPlain(String string, int n, int n2) throws IOException {
        if (CommonUtils.isJava14OrLater()) {
            try {
                Socket socket = (Socket)_socketClass.newInstance();
                Object t = _inetAddressConstructor.newInstance(string, new Integer(n));
                _connectMethod.invoke((Object)socket, t, new Integer(n2));
                return socket;
            }
            catch (InvocationTargetException invocationTargetException) {
                Throwable throwable = invocationTargetException.getTargetException();
                if (!(throwable instanceof IOException)) {
                    ErrorService.error(throwable);
                }
                throw (IOException)throwable;
            }
            catch (InstantiationException instantiationException) {
                ErrorService.error(instantiationException);
            }
            catch (IllegalAccessException illegalAccessException) {
                ErrorService.error(illegalAccessException);
            }
        }
        if (n2 != 0) {
            return new SocketOpener(string, n).connect(n2);
        }
        return new Socket(string, n);
    }

    private static Socket connectSocksV4(String string, int n, int n2) throws IOException {
        byte[] byArray;
        try {
            byArray = InetAddress.getByName(string).getAddress();
        }
        catch (UnknownHostException unknownHostException) {
            throw new IOException("invalid host name");
        }
        byte[] byArray2 = new byte[]{(byte)(n >> 8), (byte)n};
        String string2 = ConnectionSettings.PROXY_HOST.getValue();
        int n3 = ConnectionSettings.PROXY_PORT.getValue();
        OutputStream outputStream = null;
        InputStream inputStream = null;
        Socket socket = Sockets.connectPlain(string2, n3, n2);
        socket.setSoTimeout(n2);
        outputStream = socket.getOutputStream();
        inputStream = socket.getInputStream();
        outputStream.write(4);
        outputStream.write(1);
        outputStream.write(byArray2);
        outputStream.write(byArray);
        if (ConnectionSettings.PROXY_AUTHENTICATE.getValue()) {
            outputStream.write(ConnectionSettings.PROXY_USERNAME.getValue().getBytes());
        }
        outputStream.write(0);
        outputStream.flush();
        int n4 = inputStream.read();
        if (n4 != 0 && n4 != 4) {
            socket.close();
            throw new IOException("Invalid version from socks proxy: " + n4 + " expected 0 or 4");
        }
        int n5 = inputStream.read();
        if (n5 != 90) {
            socket.close();
            throw new IOException("Request rejected with status: " + n5);
        }
        byte[] byArray3 = new byte[2];
        byte[] byArray4 = new byte[4];
        if (inputStream.read(byArray3) == -1 || inputStream.read(byArray4) == -1) {
            socket.close();
            throw new IOException("Connection failed");
        }
        socket.setSoTimeout(0);
        return socket;
    }

    private static Socket connectSocksV5(String string, int n, int n2) throws IOException {
        int n3;
        byte[] byArray;
        try {
            byArray = InetAddress.getByName(string).getAddress();
        }
        catch (UnknownHostException unknownHostException) {
            throw new IOException("invalid host name");
        }
        byte[] byArray2 = new byte[]{(byte)(n >> 8), (byte)n};
        String string2 = ConnectionSettings.PROXY_HOST.getValue();
        int n4 = ConnectionSettings.PROXY_PORT.getValue();
        OutputStream outputStream = null;
        InputStream inputStream = null;
        Socket socket = Sockets.connectPlain(string2, n4, n2);
        socket.setSoTimeout(n2);
        outputStream = socket.getOutputStream();
        inputStream = socket.getInputStream();
        outputStream.write(5);
        if (ConnectionSettings.PROXY_AUTHENTICATE.getValue()) {
            outputStream.write(2);
            outputStream.write(0);
            outputStream.write(2);
        } else {
            outputStream.write(1);
            outputStream.write(0);
        }
        outputStream.flush();
        int n5 = inputStream.read();
        if (n5 != 5) {
            socket.close();
            throw new IOException("Invalid version from socks proxy: " + n5 + " expected 5");
        }
        int n6 = inputStream.read();
        if (n6 != 0 && n6 == 2) {
            String string3 = ConnectionSettings.PROXY_USERNAME.getValue();
            String string4 = ConnectionSettings.PROXY_PASS.getValue();
            outputStream.write(1);
            outputStream.write((byte)string3.length());
            outputStream.write(string3.getBytes());
            outputStream.write((byte)string4.length());
            outputStream.write(string4.getBytes());
            outputStream.flush();
            n5 = inputStream.read();
            if (n5 != 1) {
                socket.close();
                throw new IOException("Invalid version for authentication: " + n5 + " expected 1");
            }
            n3 = inputStream.read();
            if (n3 != 0) {
                socket.close();
                throw new IOException("Authentication failed with status: " + n3);
            }
        }
        outputStream.write(5);
        outputStream.write(1);
        outputStream.write(0);
        outputStream.write(1);
        outputStream.write(byArray);
        outputStream.write(byArray2);
        outputStream.flush();
        n5 = inputStream.read();
        if (n5 != 5) {
            socket.close();
            throw new IOException("Invalid version from socks proxy: " + n5 + " expected 5");
        }
        int n7 = inputStream.read();
        if (n7 != 0) {
            socket.close();
            throw new IOException("Request rejected with status: " + n7);
        }
        inputStream.read();
        int n8 = inputStream.read();
        n3 = 0;
        if (n8 == 1) {
            n3 = 6;
        } else if (n8 == 3) {
            n3 = inputStream.read() + 2;
        } else if (n8 == 4) {
            n3 = 18;
        }
        for (int i = 0; i < n3; ++i) {
            if (inputStream.read() != -1) continue;
            throw new IOException("Connection failed");
        }
        socket.setSoTimeout(0);
        return socket;
    }

    private static Socket connectHTTP(String string, int n, int n2) throws IOException {
        String string2 = "CONNECT " + string + ":" + n + " HTTP/1.0\r\n\r\n";
        String string3 = ConnectionSettings.PROXY_HOST.getValue();
        int n3 = ConnectionSettings.PROXY_PORT.getValue();
        OutputStream outputStream = null;
        InputStream inputStream = null;
        Socket socket = Sockets.connectPlain(string3, n3, n2);
        socket.setSoTimeout(n2);
        outputStream = socket.getOutputStream();
        inputStream = socket.getInputStream();
        outputStream.write(string2.getBytes());
        outputStream.flush();
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
        String string4 = bufferedReader.readLine();
        if (string4 == null || string4.indexOf("200") == -1) {
            throw new IOException("HTTP connection failed");
        }
        while (!string4.equals("")) {
            string4 = bufferedReader.readLine();
            if (string4 != null) continue;
            throw new IOException("end of stream");
        }
        socket.setSoTimeout(0);
        return socket;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        _attempts = 0;
        try {
            if (CommonUtils.isJava13OrLater()) {
                _socketClass = Class.forName("java.net.Socket");
                _setKeepAliveMethod = _socketClass.getMethod("setKeepAlive", Boolean.TYPE);
            }
            if (CommonUtils.isJava14OrLater()) {
                Class<?> clazz = Class.forName("java.net.InetSocketAddress");
                _inetAddressConstructor = clazz.getConstructor(class$java$lang$String == null ? (class$java$lang$String = Sockets.class$("java.lang.String")) : class$java$lang$String, Integer.TYPE);
                _socketAddressClass = Class.forName("java.net.SocketAddress");
                _connectMethod = _socketClass.getMethod("connect", _socketAddressClass, Integer.TYPE);
            }
        }
        catch (Exception exception) {
            ErrorService.error(exception);
        }
    }

    private static class SocketOpener {
        private String host;
        private int port;
        private Socket socket = null;
        private boolean timedOut = false;
        private boolean completed = false;

        public SocketOpener(String string, int n) {
            if ((n & 0xFFFF0000) != 0) {
                throw new IllegalArgumentException("port out of range: " + n);
            }
            this.host = string;
            this.port = n;
        }

        public synchronized Socket connect(int n) throws IOException {
            ManagedThread managedThread = new ManagedThread(new SocketOpenerThread(), "SocketOpener");
            managedThread.setDaemon(true);
            managedThread.start();
            try {
                this.wait(n);
            }
            catch (InterruptedException interruptedException) {
                if (this.socket == null) {
                    this.timedOut = true;
                } else {
                    try {
                        this.socket.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                throw new IOException();
            }
            if (!this.completed) {
                managedThread.interrupt();
            }
            if (this.socket != null) {
                return this.socket;
            }
            this.timedOut = true;
            throw new IOException();
        }

        private class SocketOpenerThread
        implements Runnable {
            private SocketOpenerThread() {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                block11: {
                    Socket socket = null;
                    try {
                        try {
                            socket = new Socket(SocketOpener.this.host, SocketOpener.this.port);
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                        SocketOpener socketOpener = SocketOpener.this;
                        synchronized (socketOpener) {
                            SocketOpener.this.completed = true;
                            if (SocketOpener.this.timedOut && socket != null) {
                                try {
                                    socket.close();
                                }
                                catch (IOException iOException) {}
                            } else {
                                SocketOpener.this.socket = socket;
                                SocketOpener.this.notify();
                            }
                        }
                    }
                    catch (Throwable throwable) {
                        if (throwable instanceof InterruptedException) break block11;
                        ErrorService.error(throwable);
                    }
                }
            }
        }
    }
}

