/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.util;

import com.limegroup.gnutella.util.AbstractI18NConverter;
import com.limegroup.gnutella.util.CommonUtils;
import com.limegroup.gnutella.util.StringUtils;
import com.limegroup.gnutella.util.Trie;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.util.BitSet;

final class I18NConvert118
extends AbstractI18NConverter {
    private Trie _convert = new Trie(false);
    private Trie _kc = new Trie(false);
    BitSet _ex;

    I18NConvert118() throws IOException, ClassNotFoundException {
        String string;
        InputStream inputStream = CommonUtils.getResourceStream("nudata.txt");
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
        while ((string = bufferedReader.readLine()) != null) {
            String[] stringArray = StringUtils.splitNoCoalesce(string, ";");
            this._convert.add(this.code2char(stringArray[0]), this.code2char(stringArray[1]));
            if (stringArray[2].equals("")) continue;
            this._kc.add(this.code2char(stringArray[1]), this.code2char(stringArray[2]));
        }
        inputStream = CommonUtils.getResourceStream("excluded.dat");
        ObjectInputStream objectInputStream = new ObjectInputStream(inputStream);
        this._ex = (BitSet)objectInputStream.readObject();
    }

    public String getNorm(String string) {
        return this.blockSplit(this.kmp(this.dekmp(string)));
    }

    private String dekmp(String string) {
        if (string.length() == 0) {
            return string;
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            stringBuffer.append(this.getDK(string.charAt(i)));
        }
        return stringBuffer.toString();
    }

    private String kmp(String string) {
        if (string.length() == 0) {
            return string;
        }
        char c = string.charAt(0);
        StringBuffer stringBuffer = new StringBuffer();
        String string2 = "";
        int n = string.length();
        for (int i = 1; i < n; ++i) {
            string2 = this.getKC(String.valueOf(c) + String.valueOf(string.charAt(i)));
            if (string2 != null) {
                c = string2.charAt(0);
                continue;
            }
            stringBuffer.append(c);
            c = string.charAt(i);
        }
        stringBuffer.append(c);
        return stringBuffer.toString();
    }

    private String code2char(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        if (string.indexOf(" ") > -1) {
            String[] stringArray = StringUtils.split(string, " ");
            for (int i = 0; i < stringArray.length; ++i) {
                stringBuffer.append((char)Integer.parseInt(stringArray[i], 16));
            }
        } else {
            stringBuffer.append((char)Integer.parseInt(string, 16));
        }
        return stringBuffer.toString();
    }

    private String getDK(char c) {
        if (this._ex.get(c)) {
            return "";
        }
        String string = (String)this._convert.get(String.valueOf(c));
        return string == null ? String.valueOf(c) : string;
    }

    private String getKC(String string) {
        return (String)this._kc.get(string);
    }

    public String compose(String string) {
        return this.kmp(string);
    }
}

