/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.util;

import com.limegroup.gnutella.Assert;
import com.sun.java.util.collections.Collection;
import com.sun.java.util.collections.Comparator;
import com.sun.java.util.collections.HashMap;
import com.sun.java.util.collections.Iterator;
import com.sun.java.util.collections.Map;
import com.sun.java.util.collections.SortedSet;
import com.sun.java.util.collections.TreeSet;

public class FixedSizeSortedSet {
    private SortedSet _sortedSet;
    private Map _map;
    private int _maxSize;

    public FixedSizeSortedSet() {
        this(50);
    }

    public FixedSizeSortedSet(int n) {
        this._maxSize = n;
        this._sortedSet = new TreeSet();
        this._map = new HashMap();
    }

    public FixedSizeSortedSet(Comparator comparator) {
        this(comparator, 50);
    }

    public FixedSizeSortedSet(Comparator comparator, int n) {
        this._maxSize = n;
        this._sortedSet = new TreeSet(comparator);
        this._map = new HashMap();
    }

    public Object clone() {
        FixedSizeSortedSet fixedSizeSortedSet = new FixedSizeSortedSet(this._maxSize);
        fixedSizeSortedSet._sortedSet = (SortedSet)((TreeSet)this._sortedSet).clone();
        fixedSizeSortedSet._map = (Map)((HashMap)this._map).clone();
        return fixedSizeSortedSet;
    }

    public boolean add(Object object) {
        if (object == null) {
            return false;
        }
        Object object2 = this._map.get(object);
        if (object2 != null) {
            boolean bl = this._sortedSet.remove(object2);
            if (!bl) {
                this.invariantsBroken(object, object2);
            }
            this._sortedSet.add(object);
            this._map.put(object, object);
            return false;
        }
        if (this._map.size() >= this._maxSize) {
            boolean bl;
            Object object3 = this._sortedSet.last();
            boolean bl2 = bl = this._map.remove(object3) != null;
            if (!bl) {
                this.invariantsBroken(object3, object3);
            }
            if (!(bl = this._sortedSet.remove(object3))) {
                this.invariantsBroken(object3, object3);
            }
        }
        this._map.put(object, object);
        boolean bl = this._sortedSet.add(object);
        if (!bl) {
            this.invariantsBroken(object, object);
        }
        return true;
    }

    public boolean addAll(Collection collection) {
        boolean bl = false;
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            bl |= this.add(iterator.next());
        }
        return bl;
    }

    public Object get(Object object) {
        return this._map.get(object);
    }

    public Object last() {
        return this._sortedSet.last();
    }

    public Object first() {
        return this._sortedSet.first();
    }

    public boolean remove(Object object) {
        boolean bl;
        Object object2 = this._map.remove(object);
        boolean bl2 = object2 != null;
        if (bl2 != (bl = this._sortedSet.remove(object2))) {
            this.invariantsBroken(object, object2);
        }
        return bl2;
    }

    public void clear() {
        this._sortedSet.clear();
        this._map.clear();
    }

    public boolean contains(Object object) {
        return this._map.get(object) != null;
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (object == this) {
            return true;
        }
        if (!(object instanceof FixedSizeSortedSet)) {
            return false;
        }
        FixedSizeSortedSet fixedSizeSortedSet = (FixedSizeSortedSet)object;
        return this._sortedSet.equals(fixedSizeSortedSet._sortedSet) && this._map.equals(fixedSizeSortedSet._map);
    }

    public int hashCode() {
        return this._sortedSet.hashCode() + 37 * this._map.hashCode();
    }

    public boolean isEmpty() {
        Assert.that(this._sortedSet.isEmpty() == this._map.isEmpty());
        return this._sortedSet.isEmpty();
    }

    public Iterator iterator() {
        return this._sortedSet.iterator();
    }

    public int size() {
        if (this._sortedSet.size() != this._map.size()) {
            this.invariantsBroken(null, null);
        }
        return this._sortedSet.size();
    }

    private void invariantsBroken(Object object, Object object2) {
        String string = this._map.toString();
        String string2 = this._sortedSet.toString();
        String string3 = "" + this._map.size();
        String string4 = "" + this._sortedSet.size();
        this.stabilize();
        String string5 = this._map.toString();
        String string6 = this._sortedSet.toString();
        String string7 = "" + this._map.size();
        String string8 = "" + this._sortedSet.size();
        Assert.silent(false, "key: " + object + ", value: " + object2 + "\nbefore stabilization: " + "\nsize of map: " + string3 + ", set: " + string4 + "\nmap: " + string + "\nset: " + string2 + "\nafter stabilization: " + "\nsize of map " + string7 + ", set: " + string8 + "\nmap: " + string5 + "\nset: " + string6);
    }

    private void stabilize() {
        Map.Entry entry;
        Iterator iterator = this._map.entrySet().iterator();
        while (iterator.hasNext()) {
            entry = (Map.Entry)iterator.next();
            if (this._sortedSet.contains(entry.getValue())) continue;
            iterator.remove();
        }
        iterator = this._map.values();
        entry = this._sortedSet.iterator();
        while (entry.hasNext()) {
            Object object = entry.next();
            if (iterator.contains(object)) continue;
            entry.remove();
        }
    }
}

