/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.util;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

public final class CountingInputStream
extends FilterInputStream {
    private int _count = 0;

    public CountingInputStream(InputStream inputStream) {
        super(inputStream);
    }

    public int read() throws IOException {
        int n = super.read();
        ++this._count;
        return n;
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        int n3;
        try {
            n3 = super.read(byArray, n, n2);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new IOException();
        }
        this._count += n3;
        return n3;
    }

    public long skip(long l) throws IOException {
        long l2 = super.skip(l);
        this._count += (int)l2;
        return l2;
    }

    public void close() throws IOException {
        this.in.close();
    }

    public int getAmountRead() {
        return this._count;
    }
}

