/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.util;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;

public class BitSet
implements Cloneable,
Serializable {
    private static final int ADDRESS_BITS_PER_UNIT = 6;
    private static final int BITS_PER_UNIT = 64;
    private static final int BIT_INDEX_MASK = 63;
    private static final long WORD_MASK = -1L;
    private long[] bits;
    private transient int unitsInUse = 0;
    private static final long serialVersionUID = 7997698588986878753L;
    private static final byte[] trailingZeroTable = new byte[]{-25, 0, 1, 0, 2, 0, 1, 0, 3, 0, 1, 0, 2, 0, 1, 0, 4, 0, 1, 0, 2, 0, 1, 0, 3, 0, 1, 0, 2, 0, 1, 0, 5, 0, 1, 0, 2, 0, 1, 0, 3, 0, 1, 0, 2, 0, 1, 0, 4, 0, 1, 0, 2, 0, 1, 0, 3, 0, 1, 0, 2, 0, 1, 0, 6, 0, 1, 0, 2, 0, 1, 0, 3, 0, 1, 0, 2, 0, 1, 0, 4, 0, 1, 0, 2, 0, 1, 0, 3, 0, 1, 0, 2, 0, 1, 0, 5, 0, 1, 0, 2, 0, 1, 0, 3, 0, 1, 0, 2, 0, 1, 0, 4, 0, 1, 0, 2, 0, 1, 0, 3, 0, 1, 0, 2, 0, 1, 0, 7, 0, 1, 0, 2, 0, 1, 0, 3, 0, 1, 0, 2, 0, 1, 0, 4, 0, 1, 0, 2, 0, 1, 0, 3, 0, 1, 0, 2, 0, 1, 0, 5, 0, 1, 0, 2, 0, 1, 0, 3, 0, 1, 0, 2, 0, 1, 0, 4, 0, 1, 0, 2, 0, 1, 0, 3, 0, 1, 0, 2, 0, 1, 0, 6, 0, 1, 0, 2, 0, 1, 0, 3, 0, 1, 0, 2, 0, 1, 0, 4, 0, 1, 0, 2, 0, 1, 0, 3, 0, 1, 0, 2, 0, 1, 0, 5, 0, 1, 0, 2, 0, 1, 0, 3, 0, 1, 0, 2, 0, 1, 0, 4, 0, 1, 0, 2, 0, 1, 0, 3, 0, 1, 0, 2, 0, 1, 0};

    private static int unitIndex(int n) {
        return n >> 6;
    }

    private static long bit(int n) {
        return 1L << (n & 0x3F);
    }

    private void recalculateUnitsInUse() {
        int n;
        for (n = this.unitsInUse - 1; n >= 0 && this.bits[n] == 0L; --n) {
        }
        this.unitsInUse = n + 1;
    }

    public BitSet() {
        this(64);
    }

    public BitSet(int n) {
        if (n < 0) {
            throw new NegativeArraySizeException("nbits < 0: " + n);
        }
        this.bits = new long[BitSet.unitIndex(n - 1) + 1];
    }

    private void ensureCapacity(int n) {
        if (this.bits.length < n) {
            int n2 = Math.max(2 * this.bits.length, n);
            long[] lArray = new long[n2];
            System.arraycopy(this.bits, 0, lArray, 0, this.unitsInUse);
            this.bits = lArray;
        }
    }

    public void flip(int n) {
        if (n < 0) {
            throw new IndexOutOfBoundsException("bitIndex < 0: " + n);
        }
        int n2 = BitSet.unitIndex(n);
        int n3 = n2 + 1;
        if (this.unitsInUse < n3) {
            this.ensureCapacity(n3);
            int n4 = n2;
            this.bits[n4] = this.bits[n4] ^ BitSet.bit(n);
            this.unitsInUse = n3;
        } else {
            int n5 = n2;
            this.bits[n5] = this.bits[n5] ^ BitSet.bit(n);
            if (this.bits[this.unitsInUse - 1] == 0L) {
                this.recalculateUnitsInUse();
            }
        }
    }

    public void flip(int n, int n2) {
        if (n < 0) {
            throw new IndexOutOfBoundsException("fromIndex < 0: " + n);
        }
        if (n2 < 0) {
            throw new IndexOutOfBoundsException("toIndex < 0: " + n2);
        }
        if (n > n2) {
            throw new IndexOutOfBoundsException("fromIndex: " + n + " > toIndex: " + n2);
        }
        int n3 = BitSet.unitIndex(n2);
        int n4 = n3 + 1;
        if (this.unitsInUse < n4) {
            this.ensureCapacity(n4);
            this.unitsInUse = n4;
        }
        int n5 = BitSet.unitIndex(n);
        long l = 0L;
        if (n5 == n3) {
            l = (1L << (n2 & 0x3F)) - (1L << (n & 0x3F));
            int n6 = n5;
            this.bits[n6] = this.bits[n6] ^ l;
            if (this.bits[this.unitsInUse - 1] == 0L) {
                this.recalculateUnitsInUse();
            }
            return;
        }
        l = BitSet.bitsLeftOf(n & 0x3F);
        int n7 = n5;
        this.bits[n7] = this.bits[n7] ^ l;
        if (n3 - n5 > 1) {
            int n8 = n5 + 1;
            while (n8 < n3) {
                int n9 = n8++;
                this.bits[n9] = this.bits[n9] ^ 0xFFFFFFFFFFFFFFFFL;
            }
        }
        l = BitSet.bitsRightOf(n2 & 0x3F);
        int n10 = n3;
        this.bits[n10] = this.bits[n10] ^ l;
        if (this.bits[this.unitsInUse - 1] == 0L) {
            this.recalculateUnitsInUse();
        }
    }

    private static long bitsRightOf(int n) {
        return n == 0 ? 0L : -1L >>> 64 - n;
    }

    private static long bitsLeftOf(int n) {
        return -1L << n;
    }

    public void set(int n) {
        if (n < 0) {
            throw new IndexOutOfBoundsException("bitIndex < 0: " + n);
        }
        int n2 = BitSet.unitIndex(n);
        int n3 = n2 + 1;
        if (this.unitsInUse < n3) {
            this.ensureCapacity(n3);
            int n4 = n2;
            this.bits[n4] = this.bits[n4] | BitSet.bit(n);
            this.unitsInUse = n3;
        } else {
            int n5 = n2;
            this.bits[n5] = this.bits[n5] | BitSet.bit(n);
        }
    }

    public void set(int n, boolean bl) {
        if (bl) {
            this.set(n);
        } else {
            this.clear(n);
        }
    }

    public void set(int n, int n2) {
        if (n < 0) {
            throw new IndexOutOfBoundsException("fromIndex < 0: " + n);
        }
        if (n2 < 0) {
            throw new IndexOutOfBoundsException("toIndex < 0: " + n2);
        }
        if (n > n2) {
            throw new IndexOutOfBoundsException("fromIndex: " + n + " > toIndex: " + n2);
        }
        int n3 = BitSet.unitIndex(n2);
        int n4 = n3 + 1;
        if (this.unitsInUse < n4) {
            this.ensureCapacity(n4);
            this.unitsInUse = n4;
        }
        int n5 = BitSet.unitIndex(n);
        long l = 0L;
        if (n5 == n3) {
            l = (1L << (n2 & 0x3F)) - (1L << (n & 0x3F));
            int n6 = n5;
            this.bits[n6] = this.bits[n6] | l;
            return;
        }
        l = BitSet.bitsLeftOf(n & 0x3F);
        int n7 = n5;
        this.bits[n7] = this.bits[n7] | l;
        if (n3 - n5 > 1) {
            int n8 = n5 + 1;
            while (n8 < n3) {
                int n9 = n8++;
                this.bits[n9] = this.bits[n9] | 0xFFFFFFFFFFFFFFFFL;
            }
        }
        l = BitSet.bitsRightOf(n2 & 0x3F);
        int n10 = n3;
        this.bits[n10] = this.bits[n10] | l;
    }

    public void set(int n, int n2, boolean bl) {
        if (bl) {
            this.set(n, n2);
        } else {
            this.clear(n, n2);
        }
    }

    public void clear(int n) {
        if (n < 0) {
            throw new IndexOutOfBoundsException("bitIndex < 0: " + n);
        }
        int n2 = BitSet.unitIndex(n);
        if (n2 >= this.unitsInUse) {
            return;
        }
        int n3 = n2;
        this.bits[n3] = this.bits[n3] & (BitSet.bit(n) ^ 0xFFFFFFFFFFFFFFFFL);
        if (this.bits[this.unitsInUse - 1] == 0L) {
            this.recalculateUnitsInUse();
        }
    }

    public void clear(int n, int n2) {
        if (n < 0) {
            throw new IndexOutOfBoundsException("fromIndex < 0: " + n);
        }
        if (n2 < 0) {
            throw new IndexOutOfBoundsException("toIndex < 0: " + n2);
        }
        if (n > n2) {
            throw new IndexOutOfBoundsException("fromIndex: " + n + " > toIndex: " + n2);
        }
        int n3 = BitSet.unitIndex(n);
        if (n3 >= this.unitsInUse) {
            return;
        }
        int n4 = BitSet.unitIndex(n2);
        long l = 0L;
        if (n3 == n4) {
            l = (1L << (n2 & 0x3F)) - (1L << (n & 0x3F));
            int n5 = n3;
            this.bits[n5] = this.bits[n5] & (l ^ 0xFFFFFFFFFFFFFFFFL);
            if (this.bits[this.unitsInUse - 1] == 0L) {
                this.recalculateUnitsInUse();
            }
            return;
        }
        l = BitSet.bitsLeftOf(n & 0x3F);
        int n6 = n3;
        this.bits[n6] = this.bits[n6] & (l ^ 0xFFFFFFFFFFFFFFFFL);
        if (n4 - n3 > 1) {
            for (int i = n3 + 1; i < n4; ++i) {
                if (i >= this.unitsInUse) continue;
                this.bits[i] = 0L;
            }
        }
        if (n4 < this.unitsInUse) {
            l = BitSet.bitsRightOf(n2 & 0x3F);
            int n7 = n4;
            this.bits[n7] = this.bits[n7] & (l ^ 0xFFFFFFFFFFFFFFFFL);
        }
        if (this.bits[this.unitsInUse - 1] == 0L) {
            this.recalculateUnitsInUse();
        }
    }

    public void clear() {
        while (this.unitsInUse > 0) {
            this.bits[--this.unitsInUse] = 0L;
        }
    }

    public boolean get(int n) {
        if (n < 0) {
            throw new IndexOutOfBoundsException("bitIndex < 0: " + n);
        }
        boolean bl = false;
        int n2 = BitSet.unitIndex(n);
        if (n2 < this.unitsInUse) {
            bl = (this.bits[n2] & BitSet.bit(n)) != 0L;
        }
        return bl;
    }

    public BitSet get(int n, int n2) {
        if (n < 0) {
            throw new IndexOutOfBoundsException("fromIndex < 0: " + n);
        }
        if (n2 < 0) {
            throw new IndexOutOfBoundsException("toIndex < 0: " + n2);
        }
        if (n > n2) {
            throw new IndexOutOfBoundsException("fromIndex: " + n + " > toIndex: " + n2);
        }
        if (this.length() <= n || n == n2) {
            return new BitSet(0);
        }
        if (this.length() < n2) {
            n2 = this.length();
        }
        BitSet bitSet = new BitSet(n2 - n);
        int n3 = n & 0x3F;
        int n4 = n2 & 0x3F;
        int n5 = (n2 - n + 63) / 64;
        int n6 = BitSet.unitIndex(n2) - BitSet.unitIndex(n) + 1;
        int n7 = 64 - n3;
        int n8 = 0;
        int n9 = BitSet.unitIndex(n);
        while (n8 < n5 - 1) {
            bitSet.bits[n8++] = this.bits[n9++] >>> n3 | (n7 == 64 ? 0L : this.bits[n9] << n7);
        }
        bitSet.bits[n8] = n6 == n5 ? (this.bits[n9] & BitSet.bitsRightOf(n4)) >>> n3 : this.bits[n9++] >>> n3 | (n7 == 64 ? 0L : (this.getBits(n9) & BitSet.bitsRightOf(n4)) << n7);
        bitSet.unitsInUse = n5;
        bitSet.recalculateUnitsInUse();
        return bitSet;
    }

    private long getBits(int n) {
        return n < this.unitsInUse ? this.bits[n] : 0L;
    }

    public int nextSetBit(int n) {
        if (n < 0) {
            throw new IndexOutOfBoundsException("fromIndex < 0: " + n);
        }
        int n2 = BitSet.unitIndex(n);
        if (n2 >= this.unitsInUse) {
            return -1;
        }
        int n3 = n & 0x3F;
        long l = this.bits[n2] >> n3;
        if (l == 0L) {
            n3 = 0;
        }
        while (l == 0L && n2 < this.unitsInUse - 1) {
            l = this.bits[++n2];
        }
        if (l == 0L) {
            return -1;
        }
        return n2 * 64 + (n3 += BitSet.trailingZeroCnt(l));
    }

    private static int trailingZeroCnt(long l) {
        int n = (int)l & 0xFF;
        if (n != 0) {
            return trailingZeroTable[n];
        }
        n = (int)(l >>> 8) & 0xFF;
        if (n != 0) {
            return trailingZeroTable[n] + 8;
        }
        n = (int)(l >>> 16) & 0xFF;
        if (n != 0) {
            return trailingZeroTable[n] + 16;
        }
        n = (int)(l >>> 24) & 0xFF;
        if (n != 0) {
            return trailingZeroTable[n] + 24;
        }
        n = (int)(l >>> 32) & 0xFF;
        if (n != 0) {
            return trailingZeroTable[n] + 32;
        }
        n = (int)(l >>> 40) & 0xFF;
        if (n != 0) {
            return trailingZeroTable[n] + 40;
        }
        n = (int)(l >>> 48) & 0xFF;
        if (n != 0) {
            return trailingZeroTable[n] + 48;
        }
        n = (int)(l >>> 56) & 0xFF;
        return trailingZeroTable[n] + 56;
    }

    public int nextClearBit(int n) {
        if (n < 0) {
            throw new IndexOutOfBoundsException("fromIndex < 0: " + n);
        }
        int n2 = BitSet.unitIndex(n);
        if (n2 >= this.unitsInUse) {
            return n;
        }
        int n3 = n & 0x3F;
        long l = this.bits[n2] >> n3;
        if (l == -1L >> n3) {
            n3 = 0;
        }
        while (l == -1L && n2 < this.unitsInUse - 1) {
            l = this.bits[++n2];
        }
        if (l == -1L) {
            return this.length();
        }
        if (l == 0L) {
            return n2 * 64 + n3;
        }
        return n2 * 64 + (n3 += BitSet.trailingZeroCnt(l ^ 0xFFFFFFFFFFFFFFFFL));
    }

    public int length() {
        if (this.unitsInUse == 0) {
            return 0;
        }
        long l = this.bits[this.unitsInUse - 1];
        int n = (int)(l >>> 32);
        return 64 * (this.unitsInUse - 1) + (n == 0 ? BitSet.bitLen((int)l) : 32 + BitSet.bitLen(n));
    }

    private static int bitLen(int n) {
        return n < 32768 ? (n < 128 ? (n < 8 ? (n < 2 ? (n < 1 ? (n < 0 ? 32 : 0) : 1) : (n < 4 ? 2 : 3)) : (n < 32 ? (n < 16 ? 4 : 5) : (n < 64 ? 6 : 7))) : (n < 2048 ? (n < 512 ? (n < 256 ? 8 : 9) : (n < 1024 ? 10 : 11)) : (n < 8192 ? (n < 4096 ? 12 : 13) : (n < 16384 ? 14 : 15)))) : (n < 0x800000 ? (n < 524288 ? (n < 131072 ? (n < 65536 ? 16 : 17) : (n < 262144 ? 18 : 19)) : (n < 0x200000 ? (n < 0x100000 ? 20 : 21) : (n < 0x400000 ? 22 : 23))) : (n < 0x8000000 ? (n < 0x2000000 ? (n < 0x1000000 ? 24 : 25) : (n < 0x4000000 ? 26 : 27)) : (n < 0x20000000 ? (n < 0x10000000 ? 28 : 29) : (n < 0x40000000 ? 30 : 31))));
    }

    public boolean isEmpty() {
        return this.unitsInUse == 0;
    }

    public boolean intersects(BitSet bitSet) {
        for (int i = Math.min(this.unitsInUse, bitSet.unitsInUse) - 1; i >= 0; --i) {
            if ((this.bits[i] & bitSet.bits[i]) == 0L) continue;
            return true;
        }
        return false;
    }

    public int cardinality() {
        int n = 0;
        for (int i = 0; i < this.unitsInUse; ++i) {
            n += BitSet.bitCount(this.bits[i]);
        }
        return n;
    }

    private static int bitCount(long l) {
        l -= (l & 0xAAAAAAAAAAAAAAAAL) >>> 1;
        l = (l & 0x3333333333333333L) + (l >>> 2 & 0x3333333333333333L);
        l = l + (l >>> 4) & 0xF0F0F0F0F0F0F0FL;
        l += l >>> 8;
        l += l >>> 16;
        return (int)l + (int)(l >>> 32) & 0xFF;
    }

    public void and(BitSet bitSet) {
        int n;
        if (this == bitSet) {
            return;
        }
        int n2 = this.unitsInUse;
        this.unitsInUse = Math.min(this.unitsInUse, bitSet.unitsInUse);
        for (n = 0; n < this.unitsInUse; ++n) {
            int n3 = n;
            this.bits[n3] = this.bits[n3] & bitSet.bits[n];
        }
        while (n < n2) {
            this.bits[n] = 0L;
            ++n;
        }
        if (this.unitsInUse > 0 && this.bits[this.unitsInUse - 1] == 0L) {
            this.recalculateUnitsInUse();
        }
    }

    public void or(BitSet bitSet) {
        int n;
        if (this == bitSet) {
            return;
        }
        this.ensureCapacity(bitSet.unitsInUse);
        int n2 = Math.min(this.unitsInUse, bitSet.unitsInUse);
        for (n = 0; n < n2; ++n) {
            int n3 = n;
            this.bits[n3] = this.bits[n3] | bitSet.bits[n];
        }
        while (n < bitSet.unitsInUse) {
            this.bits[n] = bitSet.bits[n];
            ++n;
        }
        if (this.unitsInUse < bitSet.unitsInUse) {
            this.unitsInUse = bitSet.unitsInUse;
        }
    }

    public void xor(BitSet bitSet) {
        int n;
        int n2;
        if (this.unitsInUse >= bitSet.unitsInUse) {
            n2 = bitSet.unitsInUse;
        } else {
            n2 = this.unitsInUse;
            n = bitSet.unitsInUse;
            this.ensureCapacity(n);
            this.unitsInUse = n;
        }
        for (n = 0; n < n2; ++n) {
            int n3 = n;
            this.bits[n3] = this.bits[n3] ^ bitSet.bits[n];
        }
        while (n < bitSet.unitsInUse) {
            this.bits[n] = bitSet.bits[n];
            ++n;
        }
        this.recalculateUnitsInUse();
    }

    public void andNot(BitSet bitSet) {
        int n = Math.min(this.unitsInUse, bitSet.unitsInUse);
        for (int i = 0; i < n; ++i) {
            int n2 = i;
            this.bits[n2] = this.bits[n2] & (bitSet.bits[i] ^ 0xFFFFFFFFFFFFFFFFL);
        }
        this.recalculateUnitsInUse();
    }

    public int hashCode() {
        long l = 1234L;
        int n = this.bits.length;
        while (--n >= 0) {
            l ^= this.bits[n] * (long)(n + 1);
        }
        return (int)(l >> 32 ^ l);
    }

    public int size() {
        return this.bits.length << 6;
    }

    public boolean equals(Object object) {
        int n;
        if (!(object instanceof BitSet)) {
            return false;
        }
        if (this == object) {
            return true;
        }
        BitSet bitSet = (BitSet)object;
        int n2 = Math.min(this.unitsInUse, bitSet.unitsInUse);
        for (n = 0; n < n2; ++n) {
            if (this.bits[n] == bitSet.bits[n]) continue;
            return false;
        }
        if (this.unitsInUse > n2) {
            for (n = n2; n < this.unitsInUse; ++n) {
                if (this.bits[n] == 0L) continue;
                return false;
            }
        } else {
            for (n = n2; n < bitSet.unitsInUse; ++n) {
                if (bitSet.bits[n] == 0L) continue;
                return false;
            }
        }
        return true;
    }

    public Object clone() {
        BitSet bitSet = null;
        try {
            bitSet = (BitSet)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
        bitSet.bits = new long[this.bits.length];
        System.arraycopy(this.bits, 0, bitSet.bits, 0, this.unitsInUse);
        return bitSet;
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.unitsInUse = this.bits.length;
        this.recalculateUnitsInUse();
    }

    public String toString() {
        int n = this.unitsInUse << 6;
        StringBuffer stringBuffer = new StringBuffer(8 * n + 2);
        String string = "";
        stringBuffer.append('{');
        for (int i = 0; i < n; ++i) {
            if (!this.get(i)) continue;
            stringBuffer.append(string);
            string = ", ";
            stringBuffer.append(i);
        }
        stringBuffer.append('}');
        return stringBuffer.toString();
    }
}

