/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.uploader;

import com.limegroup.gnutella.FileDesc;
import com.limegroup.gnutella.http.ConstantHTTPHeaderValue;
import com.limegroup.gnutella.http.HTTPHeaderName;
import com.limegroup.gnutella.http.HTTPHeaderValue;
import com.limegroup.gnutella.http.HTTPMessage;
import com.limegroup.gnutella.http.HTTPUtils;
import com.limegroup.gnutella.tigertree.HashTree;
import com.limegroup.gnutella.uploader.HTTPUploader;
import com.limegroup.gnutella.uploader.StalledUploadWatchdog;
import com.limegroup.gnutella.util.BandwidthThrottle;
import com.limegroup.gnutella.util.ThrottledOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.Writer;

public class THEXUploadState
implements HTTPMessage {
    private final FileDesc FILE_DESC;
    private final HTTPUploader UPLOADER;
    private final HashTree TREE;
    private final StalledUploadWatchdog WATCHDOG;
    private static final BandwidthThrottle THROTTLE = new BandwidthThrottle(512.0f);

    public THEXUploadState(HTTPUploader hTTPUploader, StalledUploadWatchdog stalledUploadWatchdog) {
        this.UPLOADER = hTTPUploader;
        this.FILE_DESC = hTTPUploader.getFileDesc();
        this.TREE = this.FILE_DESC.getHashTree();
        if (this.TREE == null) {
            throw new NullPointerException("null TREE in THEXUploadState");
        }
        this.WATCHDOG = stalledUploadWatchdog;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeMessageHeaders(OutputStream outputStream) throws IOException {
        StringWriter stringWriter = new StringWriter();
        stringWriter.write("HTTP/1.1 200 OK\r\n");
        HTTPUtils.writeHeader(HTTPHeaderName.SERVER, ConstantHTTPHeaderValue.SERVER_VALUE, (Writer)stringWriter);
        HTTPUtils.writeHeader(HTTPHeaderName.GNUTELLA_CONTENT_URN, (HTTPHeaderValue)this.FILE_DESC.getSHA1Urn(), (Writer)stringWriter);
        HTTPUtils.writeHeader(HTTPHeaderName.CONTENT_LENGTH, this.TREE.getOutputLength(), (Writer)stringWriter);
        HTTPUtils.writeHeader(HTTPHeaderName.CONTENT_TYPE, this.TREE.getOutputType(), (Writer)stringWriter);
        stringWriter.write("\r\n");
        this.WATCHDOG.activate(outputStream);
        try {
            outputStream.write(stringWriter.toString().getBytes());
            Object var4_3 = null;
            this.WATCHDOG.deactivate();
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.WATCHDOG.deactivate();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeMessageBody(OutputStream outputStream) throws IOException {
        ThrottledOutputStream throttledOutputStream = new ThrottledOutputStream(outputStream, THROTTLE);
        this.WATCHDOG.activate(outputStream);
        try {
            this.TREE.write(throttledOutputStream);
            Object var4_3 = null;
            this.WATCHDOG.deactivate();
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.WATCHDOG.deactivate();
            throw throwable;
        }
    }

    public boolean getCloseConnection() {
        return false;
    }
}

