/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.uploader;

import com.limegroup.gnutella.GUID;
import com.limegroup.gnutella.RouterService;
import com.limegroup.gnutella.http.HTTPMessage;
import com.limegroup.gnutella.messages.PushRequest;
import com.limegroup.gnutella.statistics.UploadStat;
import com.limegroup.gnutella.uploader.HTTPUploader;
import com.limegroup.gnutella.util.CommonUtils;
import com.limegroup.gnutella.util.NetworkUtils;
import com.sun.java.util.collections.Map;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.InetAddress;

public final class PushProxyUploadState
implements HTTPMessage {
    public static final String P_SERVER_ID = "ServerId";
    public static final String P_GUID = "guid";
    public static final String P_FILE = "file";
    private final HTTPUploader _uploader;
    private final ByteArrayOutputStream BAOS = new ByteArrayOutputStream();
    private static final boolean debugOn = false;

    public PushProxyUploadState(HTTPUploader hTTPUploader) {
        this._uploader = hTTPUploader;
    }

    public void writeMessageHeaders(OutputStream outputStream) throws IOException {
        byte[] byArray = GUID.fromHexString(this._uploader.getFileName());
        InetAddress inetAddress = this._uploader.getNodeAddress();
        int n = this._uploader.getNodePort();
        if (byArray.length != 16 || inetAddress == null || !NetworkUtils.isValidPort(n) || !NetworkUtils.isValidAddress(inetAddress)) {
            String string = "HTTP/1.1 400 Push Proxy: Bad Request\r\n\r\n";
            outputStream.write(string.getBytes());
            outputStream.flush();
            this.debug("PPUS.doUpload(): unknown host.");
            UploadStat.PUSH_PROXY_REQ_BAD.incrementStat();
            return;
        }
        Map map = this._uploader.getParameters();
        int n2 = 0;
        Object object = map.get((Object)P_FILE);
        if (object != null) {
            n2 = (Integer)object;
        }
        PushRequest pushRequest = new PushRequest(GUID.makeGuid(), 0, byArray, n2, inetAddress.getAddress(), n);
        try {
            RouterService.getMessageRouter().sendPushRequest(pushRequest);
        }
        catch (IOException iOException) {
            String string = "HTTP/1.1 410 Push Proxy: Servent not connected\r\n\r\n";
            outputStream.write(string.getBytes());
            outputStream.flush();
            this.debug("PPUS.doUpload(): push failed.");
            this.debug(iOException);
            UploadStat.PUSH_PROXY_REQ_FAILED.incrementStat();
            return;
        }
        UploadStat.PUSH_PROXY_REQ_SUCCESS.incrementStat();
        String string = "HTTP/1.1 202 Push Proxy: Message Sent\r\n";
        outputStream.write(string.getBytes());
        string = "Server: " + CommonUtils.getHttpServer() + "\r\n";
        outputStream.write(string.getBytes());
        string = "Content-Type: application/x-gnutella-packets\r\n";
        outputStream.write(string.getBytes());
        string = "Content-Length: " + this.BAOS.size() + "\r\n";
        outputStream.write(string.getBytes());
        string = "\r\n";
        outputStream.write(string.getBytes());
    }

    public void writeMessageBody(OutputStream outputStream) throws IOException {
        outputStream.write(this.BAOS.toByteArray());
        this._uploader.setAmountUploaded(this.BAOS.size());
        this.debug("PPUS.doUpload(): returning.");
    }

    public boolean getCloseConnection() {
        return false;
    }

    private final void debug(String string) {
    }

    private final void debug(Exception exception) {
    }
}

