/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.uploader;

import com.limegroup.gnutella.CreationTimeCache;
import com.limegroup.gnutella.FileDesc;
import com.limegroup.gnutella.IncompleteFileDesc;
import com.limegroup.gnutella.RouterService;
import com.limegroup.gnutella.URN;
import com.limegroup.gnutella.http.ConstantHTTPHeaderValue;
import com.limegroup.gnutella.http.HTTPHeaderName;
import com.limegroup.gnutella.http.HTTPHeaderValue;
import com.limegroup.gnutella.http.HTTPHeaderValueCollection;
import com.limegroup.gnutella.http.HTTPMessage;
import com.limegroup.gnutella.http.HTTPUtils;
import com.limegroup.gnutella.settings.ConnectionSettings;
import com.limegroup.gnutella.settings.UploadSettings;
import com.limegroup.gnutella.uploader.HTTPUploader;
import com.limegroup.gnutella.uploader.StalledUploadWatchdog;
import com.limegroup.gnutella.util.BandwidthThrottle;
import com.sun.java.util.collections.Collection;
import com.sun.java.util.collections.Set;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.Writer;

public final class NormalUploadState
implements HTTPMessage {
    private static final int BLOCK_SIZE = 1024;
    private final HTTPUploader _uploader;
    private final int _index;
    private final String _fileName;
    private final int _fileSize;
    private InputStream _fis;
    private int _amountWritten;
    private int _uploadBegin;
    private int _uploadEnd;
    private int _amountRequested;
    private StalledUploadWatchdog _stalledChecker;
    private static final BandwidthThrottle THROTTLE = new BandwidthThrottle(NormalUploadState.getUploadSpeed(), false);
    private final FileDesc FILE_DESC;

    public NormalUploadState(HTTPUploader hTTPUploader, StalledUploadWatchdog stalledUploadWatchdog) {
        this._uploader = hTTPUploader;
        this.FILE_DESC = this._uploader.getFileDesc();
        this._index = this._uploader.getIndex();
        this._fileName = this._uploader.getFileName();
        this._fileSize = this._uploader.getFileSize();
        this._amountWritten = 0;
        this._stalledChecker = stalledUploadWatchdog;
    }

    public static void setThrottleSwitching(boolean bl) {
        THROTTLE.setSwitching(bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeMessageHeaders(OutputStream outputStream) throws IOException {
        try {
            StringWriter stringWriter = new StringWriter();
            this._fis = this._uploader.getInputStream();
            this._uploadBegin = this._uploader.getUploadBegin();
            this._uploadEnd = this._uploader.getUploadEnd();
            this._amountRequested = this._uploader.getAmountRequested();
            if (this._fileSize < this._uploadBegin) {
                throw new IOException("Invalid Range");
            }
            if (this._uploadBegin == 0 && this._amountRequested == this._fileSize) {
                ((Writer)stringWriter).write("HTTP/1.1 200 OK\r\n");
            } else {
                ((Writer)stringWriter).write("HTTP/1.1 206 Partial Content\r\n");
            }
            HTTPUtils.writeHeader(HTTPHeaderName.SERVER, ConstantHTTPHeaderValue.SERVER_VALUE, (Writer)stringWriter);
            HTTPUtils.writeHeader(HTTPHeaderName.CONTENT_TYPE, this.getMimeType(), (Writer)stringWriter);
            HTTPUtils.writeHeader(HTTPHeaderName.CONTENT_LENGTH, this._amountRequested, (Writer)stringWriter);
            HTTPUtils.writeDate(stringWriter);
            if (this._uploadBegin != 0 || this._amountRequested != this._fileSize) {
                ((Writer)stringWriter).write("Content-Range: bytes " + this._uploadBegin + "-" + (this._uploadEnd - 1) + "/" + this._fileSize + "\r\n");
            }
            if (this.FILE_DESC != null) {
                CreationTimeCache creationTimeCache;
                Set set;
                URN uRN = this.FILE_DESC.getSHA1Urn();
                if (uRN != null) {
                    HTTPUtils.writeHeader(HTTPHeaderName.GNUTELLA_CONTENT_URN, (HTTPHeaderValue)uRN, (Writer)stringWriter);
                }
                if ((set = this._uploader.getNextSetOfAltsToSend()).size() > 0) {
                    HTTPUtils.writeHeader(HTTPHeaderName.ALT_LOCATION, (HTTPHeaderValue)new HTTPHeaderValueCollection((Collection)set), (Writer)stringWriter);
                }
                if (this.FILE_DESC instanceof IncompleteFileDesc) {
                    HTTPUtils.writeHeader(HTTPHeaderName.AVAILABLE_RANGES, (HTTPHeaderValue)((IncompleteFileDesc)this.FILE_DESC), (Writer)stringWriter);
                }
                if (this._uploader.isFirstReply() && (creationTimeCache = CreationTimeCache.instance()).getCreationTime(uRN) != null) {
                    HTTPUtils.writeHeader(HTTPHeaderName.CREATION_TIME, creationTimeCache.getCreationTime(uRN).toString(), (Writer)stringWriter);
                }
            }
            if (this._uploader.isFirstReply()) {
                HTTPUtils.writeFeatures(stringWriter);
            }
            if (this.FILE_DESC.getHashTree() != null) {
                HTTPUtils.writeHeader(HTTPHeaderName.THEX_URI, (HTTPHeaderValue)this.FILE_DESC.getHashTree(), (Writer)stringWriter);
            }
            ((Writer)stringWriter).write("\r\n");
            this._stalledChecker.activate(outputStream);
            outputStream.write(((Object)stringWriter).toString().getBytes());
            Object var7_6 = null;
            this._stalledChecker.deactivate();
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            this._stalledChecker.deactivate();
            throw throwable;
        }
    }

    public void writeMessageBody(OutputStream outputStream) throws IOException {
        try {
            this._fis.skip(this._uploadBegin);
            this.upload(outputStream);
        }
        catch (IOException iOException) {
            this._stalledChecker.deactivate();
            throw iOException;
        }
    }

    private void upload(OutputStream outputStream) throws IOException {
        byte[] byArray = new byte[1024];
        do {
            THROTTLE.setRate(NormalUploadState.getUploadSpeed());
            int n = -1;
            int n2 = THROTTLE.request(1024);
            int n3 = 0;
            n = this._fis.read(byArray, 0, n2);
            if (n == -1) {
                return;
            }
            if (n > this._amountRequested - this._amountWritten) {
                n = this._amountRequested - this._amountWritten;
            }
            this._stalledChecker.activate(outputStream);
            outputStream.write(byArray, 0, n);
            this._stalledChecker.deactivate();
            this._amountWritten += n;
            this._uploader.setAmountUploaded(this._amountWritten);
            n3 += n;
        } while (this._amountWritten < this._amountRequested);
    }

    private String getMimeType() {
        return "application/binary";
    }

    private static float getUploadSpeed() {
        int n = UploadSettings.UPLOAD_SPEED.getValue();
        float f = n == 100 ? Float.MAX_VALUE : Math.max((float)ConnectionSettings.CONNECTION_SPEED.getValue() / 8.0f * (float)n / 100.0f - RouterService.getConnectionManager().getMeasuredUpstreamBandwidth() * 1.0f, 1.0f) * 1024.0f;
        return f;
    }

    public boolean getCloseConnection() {
        return false;
    }

    public String toString() {
        return "NormalUploadState:\r\nFile Name:  " + this._fileName + "\r\n" + "File Size:  " + this._fileSize + "\r\n" + "File Index: " + this._index + "\r\n" + "File Desc:  " + this.FILE_DESC;
    }
}

