/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.tigertree;

import com.limegroup.gnutella.ErrorService;
import com.limegroup.gnutella.FileDesc;
import com.limegroup.gnutella.RouterService;
import com.limegroup.gnutella.URN;
import com.limegroup.gnutella.tigertree.HashTree;
import com.limegroup.gnutella.util.CommonUtils;
import com.limegroup.gnutella.util.ProcessingQueue;
import com.sun.java.util.collections.HashMap;
import com.sun.java.util.collections.Iterator;
import com.sun.java.util.collections.Map;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class TigerTreeCache
implements Serializable {
    private static TigerTreeCache instance = null;
    private static final ProcessingQueue QUEUE = new ProcessingQueue("TreeHashTread");
    private static final transient Log LOG = LogFactory.getLog((Class)(class$com$limegroup$gnutella$tigertree$TigerTreeCache == null ? (class$com$limegroup$gnutella$tigertree$TigerTreeCache = TigerTreeCache.class$("com.limegroup.gnutella.tigertree.TigerTreeCache")) : class$com$limegroup$gnutella$tigertree$TigerTreeCache));
    private static Map TREE_MAP;
    private static final File CACHE_FILE;
    static /* synthetic */ Class class$com$limegroup$gnutella$tigertree$TigerTreeCache;

    public static synchronized TigerTreeCache instance() {
        if (instance == null) {
            instance = new TigerTreeCache();
        }
        return instance;
    }

    public synchronized HashTree getHashTree(FileDesc fileDesc) {
        HashTree hashTree = (HashTree)TREE_MAP.get((Object)fileDesc.getSHA1Urn());
        if (hashTree == null) {
            QUEUE.add(new HashRunner(fileDesc));
        }
        return hashTree;
    }

    public synchronized HashTree getHashTree(URN uRN) {
        HashTree hashTree = (HashTree)TREE_MAP.get((Object)uRN);
        return hashTree;
    }

    public synchronized void purgeTree(URN uRN) {
        TREE_MAP.remove((Object)uRN);
    }

    public static synchronized void addHashTree(URN uRN, HashTree hashTree) {
        if (hashTree.isGoodDepth()) {
            TREE_MAP.put((Object)uRN, (Object)hashTree);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("added hashtree for urn " + uRN + ";" + hashTree.getRootHash()));
            }
        } else if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("hashtree for urn " + uRN + " had bad depth"));
        }
    }

    private TigerTreeCache() {
        TREE_MAP = TigerTreeCache.createMap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static Map createMap() {
        var0 = null;
        try {
            try {
                var0 = new ObjectInputStream(new FileInputStream(TigerTreeCache.CACHE_FILE));
                var1_1 = (Map)var0.readObject();
                var4_10 = null;
                if (var0 == null) return var1_1;
            }
            catch (IOException var1_2) {
                var2_30 = new HashMap();
                var4_11 = null;
                if (var0 == null) return var2_30;
                try {
                    var0.close();
                    return var2_30;
                }
                catch (IOException var5_21) {
                    // empty catch block
                }
                return var2_30;
            }
            catch (ClassCastException var1_3) {
                var2_31 = new HashMap();
                var4_12 = null;
                if (var0 == null) return var2_31;
                ** try [egrp 2[TRYBLOCK] [18 : 157->164)] { 
lbl27:
                // 1 sources

                var0.close();
                return var2_31;
lbl29:
                // 1 sources

                catch (IOException var5_22) {
                    // empty catch block
                }
                return var2_31;
            }
            catch (ClassNotFoundException var1_4) {
                var2_32 = new HashMap();
                var4_13 = null;
                if (var0 == null) return var2_32;
                ** try [egrp 2[TRYBLOCK] [18 : 157->164)] { 
lbl38:
                // 1 sources

                var0.close();
                return var2_32;
lbl40:
                // 1 sources

                catch (IOException var5_23) {
                    // empty catch block
                }
                return var2_32;
            }
            catch (ArrayStoreException var1_5) {
                var2_33 = new HashMap();
                var4_14 = null;
                if (var0 == null) return var2_33;
                ** try [egrp 2[TRYBLOCK] [18 : 157->164)] { 
lbl49:
                // 1 sources

                var0.close();
                return var2_33;
lbl51:
                // 1 sources

                catch (IOException var5_24) {
                    // empty catch block
                }
                return var2_33;
            }
            catch (IndexOutOfBoundsException var1_6) {
                var2_34 = new HashMap();
                var4_15 = null;
                if (var0 == null) return var2_34;
                ** try [egrp 2[TRYBLOCK] [18 : 157->164)] { 
lbl60:
                // 1 sources

                var0.close();
                return var2_34;
lbl62:
                // 1 sources

                catch (IOException var5_25) {
                    // empty catch block
                }
                return var2_34;
            }
            catch (NegativeArraySizeException var1_7) {
                var2_35 = new HashMap();
                var4_16 = null;
                if (var0 == null) return var2_35;
                ** try [egrp 2[TRYBLOCK] [18 : 157->164)] { 
lbl71:
                // 1 sources

                var0.close();
                return var2_35;
lbl73:
                // 1 sources

                catch (IOException var5_26) {
                    // empty catch block
                }
                return var2_35;
            }
            catch (IllegalStateException var1_8) {
                var2_36 = new HashMap();
                var4_17 = null;
                if (var0 == null) return var2_36;
                ** try [egrp 2[TRYBLOCK] [18 : 157->164)] { 
lbl82:
                // 1 sources

                var0.close();
                return var2_36;
lbl84:
                // 1 sources

                catch (IOException var5_27) {
                    // empty catch block
                }
                return var2_36;
            }
            catch (SecurityException var1_9) {
                var2_37 = new HashMap();
                var4_18 = null;
                if (var0 == null) return var2_37;
                ** try [egrp 2[TRYBLOCK] [18 : 157->164)] { 
lbl93:
                // 1 sources

                var0.close();
                return var2_37;
lbl95:
                // 1 sources

                catch (IOException var5_28) {
                    // empty catch block
                }
                return var2_37;
            }
        }
        catch (Throwable var3_38) {
            var4_19 = null;
            if (var0 == null) throw var3_38;
            try {}
            catch (IOException var5_29) {
                throw var3_38;
            }
            var0.close();
            throw var3_38;
        }
        try {}
        catch (IOException var5_20) {
            // empty catch block
            return var1_1;
        }
        var0.close();
        return var1_1;
    }

    private static void removeOldEntries(Map map) {
        Iterator iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            URN uRN = (URN)iterator.next();
            if (RouterService.getFileManager().getFileDescForUrn(uRN) != null || RouterService.getDownloadManager().getIncompleteFileManager().getFileForUrn(uRN) != null || Math.random() > (double)(map.size() / 200)) continue;
            map.remove((Object)uRN);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public synchronized void persistCache() {
        TigerTreeCache.removeOldEntries(TREE_MAP);
        ObjectOutputStream objectOutputStream = null;
        objectOutputStream = new ObjectOutputStream(new FileOutputStream(CACHE_FILE));
        objectOutputStream.writeObject(TREE_MAP);
        Object var4_2 = null;
        if (objectOutputStream == null) return;
        try {
            objectOutputStream.close();
            return;
        }
        catch (IOException iOException) {}
        return;
        {
            catch (Exception exception) {
                ErrorService.error(exception);
                Object var4_3 = null;
                if (objectOutputStream == null) return;
                try {
                    objectOutputStream.close();
                    return;
                }
                catch (IOException iOException) {}
                return;
            }
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            if (objectOutputStream == null) throw throwable;
            try {
                objectOutputStream.close();
                throw throwable;
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw throwable;
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        CACHE_FILE = new File(CommonUtils.getUserSettingsDir(), "ttree.cache");
    }

    private static class HashRunner
    implements Runnable {
        private final FileDesc FD;

        HashRunner(FileDesc fileDesc) {
            this.FD = fileDesc;
        }

        public void run() {
            try {
                URN uRN = this.FD.getSHA1Urn();
                if (TigerTreeCache.instance().getHashTree(uRN) == null) {
                    HashTree hashTree = HashTree.createHashTree(this.FD);
                    TigerTreeCache.addHashTree(uRN, hashTree);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

