/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.routing;

import com.limegroup.gnutella.util.I18NConvert;
import com.limegroup.gnutella.util.StringUtils;

public class HashFunction {
    private static final int A_INT = 1327217884;

    private static int hashFast(int n, byte by) {
        return n * 1327217884 >>> 32 - by;
    }

    public static int hash(String string, byte by) {
        return HashFunction.hash(string, 0, string.length(), by);
    }

    public static int hash(String string, int n, int n2, byte by) {
        int n3 = 0;
        int n4 = 0;
        for (int i = n; i < n2; ++i) {
            n3 ^= (Character.toLowerCase(string.charAt(i)) & 0xFF) << n4;
            n4 = n4 + 8 & 0x18;
        }
        return HashFunction.hashFast(n3, by);
    }

    public static String[] keywords(String string) {
        return StringUtils.split(I18NConvert.instance().getNorm(string), " -._+/*()\\");
    }

    public static int keywordStart(String string, int n) {
        while (n < string.length()) {
            char c = string.charAt(n);
            if (" -._+/*()\\".indexOf(c) < 0) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    public static int keywordEnd(String string, int n) {
        while (n < string.length()) {
            char c = string.charAt(n);
            if (" -._+/*()\\".indexOf(c) >= 0) {
                return n;
            }
            ++n;
        }
        return string.length();
    }

    public static String[] getPrefixes(String[] stringArray) {
        int n = 0;
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].length() <= 4) continue;
            ++n;
        }
        if (n == 0) {
            return stringArray;
        }
        String[] stringArray2 = new String[stringArray.length + n * 2];
        int n2 = 0;
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i];
            stringArray2[n2++] = string;
            int n3 = string.length();
            if (n3 <= 4) continue;
            stringArray2[n2++] = string.substring(0, n3 - 1);
            stringArray2[n2++] = string.substring(0, n3 - 2);
        }
        return stringArray2;
    }
}

