/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.mp3;

import com.limegroup.gnutella.ByteOrder;
import com.limegroup.gnutella.mp3.MP3Info;
import com.limegroup.gnutella.util.NameValue;
import com.limegroup.gnutella.xml.LimeXMLDocument;
import com.limegroup.gnutella.xml.LimeXMLSchemaRepository;
import com.sun.java.util.collections.ArrayList;
import com.sun.java.util.collections.Collection;
import com.sun.java.util.collections.Iterator;
import com.sun.java.util.collections.List;
import com.sun.java.util.collections.Map;
import com.sun.java.util.collections.Set;
import com.sun.java.util.collections.Vector;
import de.vdheide.mp3.ID3v2;
import de.vdheide.mp3.ID3v2Exception;
import de.vdheide.mp3.ID3v2Frame;
import de.vdheide.mp3.NoID3v2TagException;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.io.UnsupportedEncodingException;

public final class ID3Reader {
    public static final String schemaURI = "http://www.limewire.com/schemas/audio.xsd";
    private static final String ISO_LATIN_1 = "8859_1";
    private static final String UNICODE = "Unicode";
    private static final String KEY_PREFIX = "audios__audio__";
    private static final String TRACK_KEY = "audios__audio__track__";
    private static final String ARTIST_KEY = "audios__audio__artist__";
    private static final String ALBUM_KEY = "audios__audio__album__";
    private static final String TITLE_KEY = "audios__audio__title__";
    private static final String GENRE_KEY = "audios__audio__genre__";
    private static final String YEAR_KEY = "audios__audio__year__";
    private static final String COMMENTS_KEY = "audios__audio__comments__";
    private static final String BITRATE_KEY = "audios__audio__bitrate__";
    private static final String SECONDS_KEY = "audios__audio__seconds__";

    private ID3Reader() {
    }

    public static boolean isCorrupted(LimeXMLDocument limeXMLDocument) {
        if (!schemaURI.equals(limeXMLDocument.getSchemaURI())) {
            return false;
        }
        Set set = limeXMLDocument.getNameValueSet();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = (Map.Entry)iterator.next();
            String string = (String)entry.getKey();
            String string2 = (String)entry.getValue();
            if (!string.equals(ALBUM_KEY) && !string.equals(ARTIST_KEY) || string2.length() != 30 || string2.charAt(29) == ' ' || string2.charAt(28) != ' ') continue;
            return true;
        }
        return false;
    }

    public static LimeXMLDocument fixCorruption(LimeXMLDocument limeXMLDocument) {
        Set set = limeXMLDocument.getNameValueSet();
        ArrayList arrayList = new ArrayList(set.size());
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = (Map.Entry)iterator.next();
            String string = (String)entry.getKey();
            String string2 = (String)entry.getValue();
            if ((string.equals(ALBUM_KEY) || string.equals(ARTIST_KEY)) && string2.length() == 30 && string2.charAt(29) != ' ' && string2.charAt(28) == ' ') {
                string2 = string2.substring(0, 29).trim();
            }
            arrayList.add((Object)new NameValue(string, string2));
        }
        return new LimeXMLDocument((Collection)arrayList, limeXMLDocument.getSchemaURI());
    }

    public static String readDocument(File file, boolean bl) throws IOException {
        ID3Data iD3Data = ID3Reader.parseFile(file);
        return iD3Data.toXML(file.getCanonicalPath(), bl);
    }

    public static LimeXMLDocument readDocument(File file) throws IOException {
        ID3Data iD3Data = ID3Reader.parseFile(file);
        List list = iD3Data.toNameValueList();
        if (list.isEmpty()) {
            throw new IOException("invalid/no data.");
        }
        if (LimeXMLSchemaRepository.instance().getSchema(schemaURI) == null) {
            throw new IOException("no audio schema");
        }
        return new LimeXMLDocument((Collection)list, schemaURI);
    }

    private static ID3Data parseFile(File file) throws IOException {
        ID3Data iD3Data = ID3Reader.parseID3v2Data(file);
        MP3Info mP3Info = new MP3Info(file.getCanonicalPath());
        iD3Data.setBitrate(mP3Info.getBitRate());
        iD3Data.setLength((int)mP3Info.getLengthInSeconds());
        if (iD3Data.isComplete()) {
            return iD3Data;
        }
        ID3Data iD3Data2 = ID3Reader.parseID3v1Data(file);
        iD3Data.mergeID3Data(iD3Data2);
        return iD3Data;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static ID3Data parseID3v1Data(File file) {
        int n;
        byte[] byArray;
        RandomAccessFile randomAccessFile;
        ID3Data iD3Data;
        block13: {
            iD3Data = new ID3Data();
            if (file.length() < 128L) {
                return iD3Data;
            }
            randomAccessFile = null;
            randomAccessFile = new RandomAccessFile(file, "r");
            long l = randomAccessFile.length();
            randomAccessFile.seek(l - 128L);
            byArray = new byte[30];
            randomAccessFile.readFully(byArray, 0, 3);
            String string = new String(byArray, 0, 3);
            if (string.equals("TAG")) break block13;
            ID3Data iD3Data2 = iD3Data;
            Object var9_9 = null;
            if (randomAccessFile == null) return iD3Data2;
            try {
                randomAccessFile.close();
                return iD3Data2;
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return iD3Data2;
        }
        randomAccessFile.readFully(byArray, 0, 30);
        iD3Data.setTitle(ID3Reader.getString(byArray, 30));
        randomAccessFile.readFully(byArray, 0, 30);
        iD3Data.setArtist(ID3Reader.getString(byArray, 30));
        randomAccessFile.readFully(byArray, 0, 30);
        iD3Data.setAlbum(ID3Reader.getString(byArray, 30));
        randomAccessFile.readFully(byArray, 0, 4);
        iD3Data.setYear(ID3Reader.getString(byArray, 4));
        randomAccessFile.readFully(byArray, 0, 30);
        if (byArray[28] == 0) {
            iD3Data.setTrack((short)ByteOrder.ubyte2int(byArray[29]));
            n = 28;
        } else {
            iD3Data.setTrack((short)0);
            n = 3;
        }
        iD3Data.setComment(ID3Reader.getString(byArray, n));
        randomAccessFile.readFully(byArray, 0, 1);
        iD3Data.setGenre(ID3Reader.getGenreString((short)ByteOrder.ubyte2int(byArray[0])));
        Object var9_10 = null;
        if (randomAccessFile == null) return iD3Data;
        try {
            randomAccessFile.close();
            return iD3Data;
        }
        catch (IOException iOException) {}
        return iD3Data;
        {
            catch (IOException iOException) {
                Object var9_11 = null;
                if (randomAccessFile == null) return iD3Data;
                try {
                    randomAccessFile.close();
                    return iD3Data;
                }
                catch (IOException iOException2) {}
                return iD3Data;
            }
        }
        catch (Throwable throwable) {
            Object var9_12 = null;
            if (randomAccessFile == null) throw throwable;
            try {
                randomAccessFile.close();
                throw throwable;
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw throwable;
        }
    }

    private static String getString(byte[] byArray, int n) {
        try {
            return new String(byArray, 0, ID3Reader.getTrimmedLength(byArray, n), ISO_LATIN_1);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return null;
        }
    }

    private static ID3Data parseID3v2Data(File file) {
        ID3Data iD3Data = new ID3Data();
        ID3v2 iD3v2 = null;
        try {
            iD3v2 = new ID3v2(file);
        }
        catch (ID3v2Exception iD3v2Exception) {
            return iD3Data;
        }
        catch (IOException iOException) {
            return iD3Data;
        }
        Vector vector = null;
        try {
            vector = iD3v2.getFrames();
        }
        catch (NoID3v2TagException noID3v2TagException) {
            return iD3Data;
        }
        Iterator iterator = vector.iterator();
        while (iterator.hasNext()) {
            int n;
            int n2;
            Object object;
            ID3v2Frame iD3v2Frame = (ID3v2Frame)iterator.next();
            String string = iD3v2Frame.getID();
            byte[] byArray = iD3v2Frame.getContent();
            String string2 = null;
            if (byArray.length > 0) {
                try {
                    object = iD3v2Frame.isISOLatin1() ? ISO_LATIN_1 : UNICODE;
                    string2 = new String(byArray, (String)object).trim();
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    // empty catch block
                }
            }
            if (string2 == null || string2.trim().equals("")) continue;
            if ("TIT2".equals(string)) {
                iD3Data.setTitle(string2);
                continue;
            }
            if ("TPE1".equals(string)) {
                iD3Data.setArtist(string2);
                continue;
            }
            if ("TALB".equals(string)) {
                iD3Data.setAlbum(string2);
                continue;
            }
            if ("TYER".equals(string)) {
                iD3Data.setYear(string2);
                continue;
            }
            if ("COMM".equals(string)) {
                object = iD3v2Frame.getContent();
                n2 = 0;
                for (n = ((Object)object).length - 1; n >= 0; --n) {
                    if (object[n] != false) continue;
                    n2 = n;
                    break;
                }
                string2 = new String((byte[])object, n2, ((Object)object).length - n2).trim();
                iD3Data.setComment(string2);
                continue;
            }
            if ("TRCK".equals(string)) {
                try {
                    iD3Data.setTrack(Short.parseShort(string2));
                }
                catch (NumberFormatException numberFormatException) {}
                continue;
            }
            if (!"TCON".equals(string)) continue;
            int n3 = string2.indexOf("(");
            n2 = string2.indexOf(")");
            n = -1;
            if (n3 > -1 && n2 > -1 && n3 < string2.length()) {
                String string3 = string2.substring(n3 + 1, n2);
                try {
                    n = Integer.parseInt(string3);
                }
                catch (NumberFormatException numberFormatException) {
                    n = -1;
                }
            }
            if (n >= 0 && n <= 127) {
                iD3Data.setGenre(ID3Reader.getGenreString((short)n));
                continue;
            }
            iD3Data.setGenre(string2);
        }
        return iD3Data;
    }

    private static void appendStrings(String string, String string2, StringBuffer stringBuffer) {
        stringBuffer.append(string);
        stringBuffer.append(string2);
        stringBuffer.append("\"");
    }

    private static int getTrimmedLength(byte[] byArray, int n) {
        int n2;
        for (n2 = n - 1; n2 >= 0 && (byArray[n2] == 0 || byArray[n2] == 32); --n2) {
        }
        for (int i = 0; i <= n2; ++i) {
            if (byArray[i] != 0) continue;
            byArray[i] = 32;
        }
        return n2 + 1;
    }

    public static boolean isNonID3Field(String string) {
        return !string.equals(TRACK_KEY) && !string.equals(ARTIST_KEY) && !string.equals(ALBUM_KEY) && !string.equals(TITLE_KEY) && !string.equals(GENRE_KEY) && !string.equals(YEAR_KEY) && !string.equals(COMMENTS_KEY) && !string.equals(BITRATE_KEY) && !string.equals(SECONDS_KEY);
    }

    public static String getGenreString(short s) {
        switch (s) {
            case 0: {
                return "Blues";
            }
            case 1: {
                return "Classic Rock";
            }
            case 2: {
                return "Country";
            }
            case 3: {
                return "Dance";
            }
            case 4: {
                return "Disco";
            }
            case 5: {
                return "Funk";
            }
            case 6: {
                return "Grunge";
            }
            case 7: {
                return "Hip-Hop";
            }
            case 8: {
                return "Jazz";
            }
            case 9: {
                return "Metal";
            }
            case 10: {
                return "New Age";
            }
            case 11: {
                return "Oldies";
            }
            case 12: {
                return "Other";
            }
            case 13: {
                return "Pop";
            }
            case 14: {
                return "R &amp; B";
            }
            case 15: {
                return "Rap";
            }
            case 16: {
                return "Reggae";
            }
            case 17: {
                return "Rock";
            }
            case 18: {
                return "Techno";
            }
            case 19: {
                return "Industrial";
            }
            case 20: {
                return "Alternative";
            }
            case 21: {
                return "Ska";
            }
            case 22: {
                return "Death Metal";
            }
            case 23: {
                return "Pranks";
            }
            case 24: {
                return "Soundtrack";
            }
            case 25: {
                return "Euro-Techno";
            }
            case 26: {
                return "Ambient";
            }
            case 27: {
                return "Trip-Hop";
            }
            case 28: {
                return "Vocal";
            }
            case 29: {
                return "Jazz+Funk";
            }
            case 30: {
                return "Fusion";
            }
            case 31: {
                return "Trance";
            }
            case 32: {
                return "Classical";
            }
            case 33: {
                return "Instrumental";
            }
            case 34: {
                return "Acid";
            }
            case 35: {
                return "House";
            }
            case 36: {
                return "Game";
            }
            case 37: {
                return "Sound Clip";
            }
            case 38: {
                return "Gospel";
            }
            case 39: {
                return "Noise";
            }
            case 40: {
                return "AlternRock";
            }
            case 41: {
                return "Bass";
            }
            case 42: {
                return "Soul";
            }
            case 43: {
                return "Punk";
            }
            case 44: {
                return "Space";
            }
            case 45: {
                return "Meditative";
            }
            case 46: {
                return "Instrumental Pop";
            }
            case 47: {
                return "Instrumental Rock";
            }
            case 48: {
                return "Ethnic";
            }
            case 49: {
                return "Gothic";
            }
            case 50: {
                return "Darkwave";
            }
            case 51: {
                return "Techno-Industrial";
            }
            case 52: {
                return "Electronic";
            }
            case 53: {
                return "Pop-Folk";
            }
            case 54: {
                return "Eurodance";
            }
            case 55: {
                return "Dream";
            }
            case 56: {
                return "Southern Rock";
            }
            case 57: {
                return "Comedy";
            }
            case 58: {
                return "Cult";
            }
            case 59: {
                return "Gangsta";
            }
            case 60: {
                return "Top 40";
            }
            case 61: {
                return "Christian Rap";
            }
            case 62: {
                return "Pop/Funk";
            }
            case 63: {
                return "Jungle";
            }
            case 64: {
                return "Native American";
            }
            case 65: {
                return "Cabaret";
            }
            case 66: {
                return "New Wave";
            }
            case 67: {
                return "Psychadelic";
            }
            case 68: {
                return "Rave";
            }
            case 69: {
                return "Showtunes";
            }
            case 70: {
                return "Trailer";
            }
            case 71: {
                return "Lo-Fi";
            }
            case 72: {
                return "Tribal";
            }
            case 73: {
                return "Acid Punk";
            }
            case 74: {
                return "Acid Jazz";
            }
            case 75: {
                return "Polka";
            }
            case 76: {
                return "Retro";
            }
            case 77: {
                return "Musical";
            }
            case 78: {
                return "Rock &amp; Roll";
            }
            case 79: {
                return "Hard Rock";
            }
            case 80: {
                return "Folk";
            }
            case 81: {
                return "Folk-Rock";
            }
            case 82: {
                return "National Folk";
            }
            case 83: {
                return "Swing";
            }
            case 84: {
                return "Fast Fusion";
            }
            case 85: {
                return "Bebob";
            }
            case 86: {
                return "Latin";
            }
            case 87: {
                return "Revival";
            }
            case 88: {
                return "Celtic";
            }
            case 89: {
                return "Bluegrass";
            }
            case 90: {
                return "Avantgarde";
            }
            case 91: {
                return "Gothic Rock";
            }
            case 92: {
                return "Progressive Rock";
            }
            case 93: {
                return "Psychedelic Rock";
            }
            case 94: {
                return "Symphonic Rock";
            }
            case 95: {
                return "Slow Rock";
            }
            case 96: {
                return "Big Band";
            }
            case 97: {
                return "Chorus";
            }
            case 98: {
                return "Easy Listening";
            }
            case 99: {
                return "Acoustic";
            }
            case 100: {
                return "Humour";
            }
            case 101: {
                return "Speech";
            }
            case 102: {
                return "Chanson";
            }
            case 103: {
                return "Opera";
            }
            case 104: {
                return "Chamber Music";
            }
            case 105: {
                return "Sonata";
            }
            case 106: {
                return "Symphony";
            }
            case 107: {
                return "Booty Bass";
            }
            case 108: {
                return "Primus";
            }
            case 109: {
                return "Porn Groove";
            }
            case 110: {
                return "Satire";
            }
            case 111: {
                return "Slow Jam";
            }
            case 112: {
                return "Club";
            }
            case 113: {
                return "Tango";
            }
            case 114: {
                return "Samba";
            }
            case 115: {
                return "Folklore";
            }
            case 116: {
                return "Ballad";
            }
            case 117: {
                return "Power Ballad";
            }
            case 118: {
                return "Rhythmic Soul";
            }
            case 119: {
                return "Freestyle";
            }
            case 120: {
                return "Duet";
            }
            case 121: {
                return "Punk Rock";
            }
            case 122: {
                return "Drum Solo";
            }
            case 123: {
                return "A capella";
            }
            case 124: {
                return "Euro-House";
            }
            case 125: {
                return "Dance Hall";
            }
        }
        return "";
    }

    static class ID3Data {
        private String title;
        private String artist;
        private String album;
        private String year;
        private String comment;
        private short track = (short)-1;
        private String genre;
        private int bitrate = -1;
        private int length = -1;

        ID3Data() {
        }

        public String toString() {
            return "ID3Data: title[" + this.title + "], artist[" + this.artist + "], album[" + this.album + "], year[" + this.year + "], comment[" + this.comment + "], track[" + this.track + "], genre[" + this.genre + "], bitrate[" + this.bitrate + "], length[" + this.length + "]";
        }

        String getTitle() {
            return this.title;
        }

        String getArtist() {
            return this.artist;
        }

        String getAlbum() {
            return this.album;
        }

        String getYear() {
            return this.year;
        }

        String getComment() {
            return this.comment;
        }

        short getTrack() {
            return this.track;
        }

        String getGenre() {
            return this.genre;
        }

        int getBitrate() {
            return this.bitrate;
        }

        int getLength() {
            return this.length;
        }

        void setTitle(String string) {
            this.title = string;
        }

        void setArtist(String string) {
            this.artist = string;
        }

        void setAlbum(String string) {
            this.album = string;
        }

        void setYear(String string) {
            this.year = string;
        }

        void setComment(String string) {
            this.comment = string;
        }

        void setTrack(short s) {
            this.track = s;
        }

        void setGenre(String string) {
            this.genre = string;
        }

        void setBitrate(int n) {
            this.bitrate = n;
        }

        void setLength(int n) {
            this.length = n;
        }

        void mergeID3Data(ID3Data iD3Data) {
            if (!this.isValid(this.title)) {
                this.title = iD3Data.title;
            }
            if (!this.isValid(this.artist)) {
                this.artist = iD3Data.artist;
            }
            if (!this.isValid(this.album)) {
                this.album = iD3Data.album;
            }
            if (!this.isValid(this.year)) {
                this.year = iD3Data.year;
            }
            if (!this.isValid(this.comment)) {
                this.comment = iD3Data.comment;
            }
            if (!this.isValid(this.track)) {
                this.track = iD3Data.track;
            }
            if (!this.isValid(this.genre)) {
                this.genre = iD3Data.genre;
            }
            if (!this.isValid(this.bitrate)) {
                this.bitrate = iD3Data.bitrate;
            }
            if (!this.isValid(this.length)) {
                this.length = iD3Data.length;
            }
        }

        boolean isComplete() {
            return this.isValid(this.title) && this.isValid(this.artist) && this.isValid(this.album) && this.isValid(this.year) && this.isValid(this.comment) && this.isValid(this.track) && this.isValid(this.genre) && this.isValid(this.bitrate) && this.isValid(this.length);
        }

        List toNameValueList() {
            ArrayList arrayList = new ArrayList();
            this.add((List)arrayList, this.title, ID3Reader.TITLE_KEY);
            this.add((List)arrayList, this.artist, ID3Reader.ARTIST_KEY);
            this.add((List)arrayList, this.album, ID3Reader.ALBUM_KEY);
            this.add((List)arrayList, this.year, ID3Reader.YEAR_KEY);
            this.add((List)arrayList, this.comment, ID3Reader.COMMENTS_KEY);
            this.add((List)arrayList, this.track, ID3Reader.TRACK_KEY);
            this.add((List)arrayList, this.genre, ID3Reader.GENRE_KEY);
            this.add((List)arrayList, this.bitrate, ID3Reader.BITRATE_KEY);
            this.add((List)arrayList, this.length, ID3Reader.SECONDS_KEY);
            return arrayList;
        }

        String toXML(String string, boolean bl) {
            StringBuffer stringBuffer = new StringBuffer();
            if (bl) {
                ID3Reader.appendStrings("<audios noNamespaceSchemaLocation=\"", ID3Reader.schemaURI, stringBuffer);
                stringBuffer.append("><audio ");
                ID3Reader.appendStrings(" identifier=\"", string, stringBuffer);
            }
            if (this.isValid(this.title)) {
                ID3Reader.appendStrings(" title=\"", this.title, stringBuffer);
            }
            if (this.isValid(this.artist)) {
                ID3Reader.appendStrings(" artist=\"", this.artist, stringBuffer);
            }
            if (this.isValid(this.album)) {
                ID3Reader.appendStrings(" album=\"", this.album, stringBuffer);
            }
            if (this.isValid(this.track)) {
                ID3Reader.appendStrings(" track=\"", "" + this.track, stringBuffer);
            }
            if (this.isValid(this.genre)) {
                ID3Reader.appendStrings(" genre=\"", this.genre, stringBuffer);
            }
            if (this.isValid(this.year)) {
                ID3Reader.appendStrings(" year=\"", this.year, stringBuffer);
            }
            if (this.isValid(this.comment)) {
                ID3Reader.appendStrings(" comments=\"", this.comment, stringBuffer);
            }
            if (this.isValid(this.bitrate)) {
                ID3Reader.appendStrings(" bitrate=\"", "" + this.bitrate, stringBuffer);
            }
            if (this.isValid(this.length)) {
                ID3Reader.appendStrings(" seconds=\"", "" + this.length, stringBuffer);
            }
            if (bl) {
                stringBuffer.append("/>");
                stringBuffer.append("</audios>");
            }
            return stringBuffer.toString();
        }

        private void add(List list, String string, String string2) {
            if (this.isValid(string)) {
                list.add((Object)new NameValue(string2, string.trim()));
            }
        }

        private void add(List list, int n, String string) {
            if (this.isValid(n)) {
                list.add((Object)new NameValue(string, "" + n));
            }
        }

        private boolean isValid(String string) {
            return string != null && !string.trim().equals("");
        }

        private boolean isValid(int n) {
            return n >= 0;
        }
    }
}

