/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.messages.vendor;

import com.limegroup.gnutella.ByteOrder;
import com.limegroup.gnutella.GUID;
import com.limegroup.gnutella.messages.BadPacketException;
import com.limegroup.gnutella.messages.vendor.VendorMessage;

public class UDPCrawlerPing
extends VendorMessage {
    public static final int VERSION = 1;
    public static final int ALL = -1;
    private int _numberUP;
    private int _numberLeaves;
    private byte _format;
    public static final byte PLAIN = 0;
    public static final byte CONNECTION_TIME = 1;
    public static final byte LOCALE_INFO = 2;
    public static final byte NEW_ONLY = 4;
    public static final byte FEATURE_MASK = 7;

    public UDPCrawlerPing(GUID gUID, int n, int n2, byte by) {
        super(VendorMessage.F_LIME_VENDOR_ID, 5, 1, UDPCrawlerPing.derivePayload(n, n2, by));
        this.setGUID(gUID);
        this._numberUP = n;
        this._numberLeaves = n2;
        this._format = (byte)(by & 7);
    }

    public UDPCrawlerPing(GUID gUID) {
        this(gUID, -1, -1, 0);
    }

    private static byte[] derivePayload(int n, int n2, byte by) {
        if (n > 255) {
            n = 255;
        }
        if (n2 > 255) {
            n2 = 255;
        }
        by = (byte)(by & 7);
        byte[] byArray = new byte[2];
        byte[] byArray2 = new byte[3];
        ByteOrder.short2leb((short)n, byArray, 0);
        byArray2[0] = byArray[0];
        ByteOrder.short2leb((short)n2, byArray, 0);
        byArray2[1] = byArray[0];
        byArray2[2] = by;
        return byArray2;
    }

    protected UDPCrawlerPing(byte[] byArray, byte by, byte by2, int n, byte[] byArray2) throws BadPacketException {
        super(byArray, by, by2, VendorMessage.F_LIME_VENDOR_ID, 5, n, byArray2);
        if (this.getVersion() == 1 && (byArray2 == null || byArray2.length != 3)) {
            throw new BadPacketException();
        }
        this._numberUP = ByteOrder.ubyte2int(byArray2[0]);
        this._numberLeaves = ByteOrder.ubyte2int(byArray2[1]);
        this._format = byArray2[2];
        this._format = (byte)(this._format & 7);
    }

    public int getNumberUP() {
        return this._numberUP;
    }

    public int getNumberLeaves() {
        return this._numberLeaves;
    }

    public boolean hasConnectionTime() {
        return (byte)(1 & this._format) == 1;
    }

    public boolean hasLocaleInfo() {
        return (byte)(2 & this._format) == 2;
    }

    public boolean hasNewOnly() {
        return (byte)(4 & this._format) == 4;
    }

    public boolean hasFeature(byte by) {
        return (byte)(by & this._format) == by;
    }

    public byte getFormat() {
        return this._format;
    }
}

