/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.messages.vendor;

import com.limegroup.gnutella.ByteOrder;
import com.limegroup.gnutella.ErrorService;
import com.limegroup.gnutella.messages.BadPacketException;
import com.limegroup.gnutella.messages.Message;
import com.limegroup.gnutella.messages.vendor.VendorMessage;
import com.limegroup.gnutella.statistics.SentMessageStatHandler;
import com.sun.java.util.collections.Arrays;
import com.sun.java.util.collections.HashSet;
import com.sun.java.util.collections.Iterator;
import com.sun.java.util.collections.Set;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public final class MessagesSupportedVendorMessage
extends VendorMessage {
    public static final int VERSION = 0;
    private final Set _messagesSupported = new HashSet();
    private static MessagesSupportedVendorMessage _instance;

    MessagesSupportedVendorMessage(byte[] byArray, byte by, byte by2, int n, byte[] byArray2) throws BadPacketException {
        super(byArray, by, by2, VendorMessage.F_NULL_VENDOR_ID, 0, n, byArray2);
        if (this.getVersion() > 0) {
            throw new BadPacketException("UNSUPPORTED VERSION");
        }
        try {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(this.getPayload());
            int n2 = ByteOrder.ubytes2int(ByteOrder.leb2short(byteArrayInputStream));
            for (int i = 0; i < n2; ++i) {
                this._messagesSupported.add((Object)new SupportedMessageBlock(byteArrayInputStream));
            }
        }
        catch (IOException iOException) {
            ErrorService.error(iOException);
        }
    }

    private MessagesSupportedVendorMessage() {
        super(VendorMessage.F_NULL_VENDOR_ID, 0, 0, MessagesSupportedVendorMessage.derivePayload());
        MessagesSupportedVendorMessage.addSupportedMessages(this._messagesSupported);
    }

    private static byte[] derivePayload() {
        HashSet hashSet = new HashSet();
        MessagesSupportedVendorMessage.addSupportedMessages((Set)hashSet);
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            ByteOrder.short2leb((short)hashSet.size(), byteArrayOutputStream);
            Iterator iterator = hashSet.iterator();
            while (iterator.hasNext()) {
                SupportedMessageBlock supportedMessageBlock = (SupportedMessageBlock)iterator.next();
                supportedMessageBlock.encode(byteArrayOutputStream);
            }
            return byteArrayOutputStream.toByteArray();
        }
        catch (IOException iOException) {
            ErrorService.error(iOException);
            return null;
        }
    }

    private static void addSupportedMessages(Set set) {
        SupportedMessageBlock supportedMessageBlock = null;
        supportedMessageBlock = new SupportedMessageBlock(VendorMessage.F_BEAR_VENDOR_ID, 7, 1);
        set.add((Object)supportedMessageBlock);
        supportedMessageBlock = new SupportedMessageBlock(VendorMessage.F_GTKG_VENDOR_ID, 7, 2);
        set.add((Object)supportedMessageBlock);
        supportedMessageBlock = new SupportedMessageBlock(VendorMessage.F_BEAR_VENDOR_ID, 4, 1);
        set.add((Object)supportedMessageBlock);
        supportedMessageBlock = new SupportedMessageBlock(VendorMessage.F_LIME_VENDOR_ID, 14, 1);
        set.add((Object)supportedMessageBlock);
        supportedMessageBlock = new SupportedMessageBlock(VendorMessage.F_LIME_VENDOR_ID, 21, 1);
        set.add((Object)supportedMessageBlock);
        supportedMessageBlock = new SupportedMessageBlock(VendorMessage.F_BEAR_VENDOR_ID, 11, 1);
        set.add((Object)supportedMessageBlock);
        supportedMessageBlock = new SupportedMessageBlock(VendorMessage.F_LIME_VENDOR_ID, 7, 1);
        set.add((Object)supportedMessageBlock);
        supportedMessageBlock = new SupportedMessageBlock(VendorMessage.F_LIME_VENDOR_ID, 8, 1);
        set.add((Object)supportedMessageBlock);
        supportedMessageBlock = new SupportedMessageBlock(VendorMessage.F_LIME_VENDOR_ID, 6, 1);
        set.add((Object)supportedMessageBlock);
    }

    public static MessagesSupportedVendorMessage instance() {
        if (_instance == null) {
            _instance = new MessagesSupportedVendorMessage();
        }
        return _instance;
    }

    public int supportsMessage(byte[] byArray, int n) {
        Iterator iterator = this._messagesSupported.iterator();
        while (iterator.hasNext()) {
            SupportedMessageBlock supportedMessageBlock = (SupportedMessageBlock)iterator.next();
            int n2 = supportedMessageBlock.matches(byArray, n);
            if (n2 <= -1) continue;
            return n2;
        }
        return -1;
    }

    public int supportsTCPConnectBack() {
        return this.supportsMessage(VendorMessage.F_BEAR_VENDOR_ID, 7);
    }

    public int supportsUDPConnectBack() {
        return this.supportsMessage(VendorMessage.F_GTKG_VENDOR_ID, 7);
    }

    public int supportsTCPConnectBackRedirect() {
        return this.supportsMessage(VendorMessage.F_LIME_VENDOR_ID, 7);
    }

    public int supportsUDPConnectBackRedirect() {
        return this.supportsMessage(VendorMessage.F_LIME_VENDOR_ID, 8);
    }

    public int supportsHopsFlow() {
        return this.supportsMessage(VendorMessage.F_BEAR_VENDOR_ID, 4);
    }

    public int supportsPushProxy() {
        return this.supportsMessage(VendorMessage.F_LIME_VENDOR_ID, 21);
    }

    public int supportsGiveStatsVM() {
        return this.supportsMessage(VendorMessage.F_LIME_VENDOR_ID, 14);
    }

    public int supportsLeafGuidance() {
        return this.supportsMessage(VendorMessage.F_BEAR_VENDOR_ID, 11);
    }

    public int supportsUDPCrawling() {
        return this.supportsMessage(VendorMessage.F_LIME_VENDOR_ID, 6);
    }

    public boolean equals(Object object) {
        if (object instanceof MessagesSupportedVendorMessage) {
            MessagesSupportedVendorMessage messagesSupportedVendorMessage = (MessagesSupportedVendorMessage)object;
            return this._messagesSupported.equals(messagesSupportedVendorMessage._messagesSupported);
        }
        return false;
    }

    public int hashCode() {
        return 17 * this._messagesSupported.hashCode();
    }

    protected void writePayload(OutputStream outputStream) throws IOException {
        super.writePayload(outputStream);
        if (Message.RECORD_STATS) {
            SentMessageStatHandler.TCP_MESSAGES_SUPPORTED.addMessage(this);
        }
    }

    public void recordDrop() {
        super.recordDrop();
    }

    static class SupportedMessageBlock {
        final byte[] _vendorID;
        final int _selector;
        final int _version;
        final int _hashCode;

        public SupportedMessageBlock(byte[] byArray, int n, int n2) {
            this._vendorID = byArray;
            this._selector = n;
            this._version = n2;
            this._hashCode = SupportedMessageBlock.computeHashCode(this._vendorID, this._selector, this._version);
        }

        public SupportedMessageBlock(InputStream inputStream) throws BadPacketException, IOException {
            if (inputStream.available() < 8) {
                throw new BadPacketException("invalid data.");
            }
            this._vendorID = new byte[4];
            inputStream.read(this._vendorID, 0, this._vendorID.length);
            this._selector = ByteOrder.ubytes2int(ByteOrder.leb2short(inputStream));
            this._version = ByteOrder.ubytes2int(ByteOrder.leb2short(inputStream));
            this._hashCode = SupportedMessageBlock.computeHashCode(this._vendorID, this._selector, this._version);
        }

        public void encode(OutputStream outputStream) throws IOException {
            outputStream.write(this._vendorID);
            ByteOrder.short2leb((short)this._selector, outputStream);
            ByteOrder.short2leb((short)this._version, outputStream);
        }

        public int matches(byte[] byArray, int n) {
            if (Arrays.equals((byte[])this._vendorID, (byte[])byArray) && this._selector == n) {
                return this._version;
            }
            return -1;
        }

        public boolean equals(Object object) {
            if (object instanceof SupportedMessageBlock) {
                SupportedMessageBlock supportedMessageBlock = (SupportedMessageBlock)object;
                return this._selector == supportedMessageBlock._selector && this._version == supportedMessageBlock._version && Arrays.equals((byte[])this._vendorID, (byte[])supportedMessageBlock._vendorID);
            }
            return false;
        }

        public int hashCode() {
            return this._hashCode;
        }

        private static int computeHashCode(byte[] byArray, int n, int n2) {
            int n3 = 0;
            n3 += 37 * n2;
            n3 += 37 * n;
            for (int i = 0; i < byArray.length; ++i) {
                n3 += 37 * byArray[i];
            }
            return n3;
        }
    }
}

