/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.http;

import com.limegroup.gnutella.settings.ConnectionSettings;
import com.limegroup.gnutella.util.CommonUtils;
import java.io.IOException;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HostConfiguration;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpConnectionManager;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.MultiThreadedHttpConnectionManager;
import org.apache.commons.httpclient.URI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class HttpClientManager {
    private static final Log LOG = LogFactory.getLog((Class)(class$com$limegroup$gnutella$http$HttpClientManager == null ? (class$com$limegroup$gnutella$http$HttpClientManager = HttpClientManager.class$("com.limegroup.gnutella.http.HttpClientManager")) : class$com$limegroup$gnutella$http$HttpClientManager));
    private static final int CONNECTION_TIMEOUT = 5000;
    private static final int TIMEOUT = 8000;
    private static final int MAXIMUM_REDIRECTS = 10;
    private static final long IDLE_TIME = 30000L;
    private static final HttpConnectionManager MANAGER;
    static /* synthetic */ Class class$com$limegroup$gnutella$http$HttpClientManager;

    public static HttpClient getNewClient() {
        return HttpClientManager.getNewClient(5000, 8000);
    }

    public static HttpClient getNewClient(int n, int n2) {
        HttpClient httpClient = CommonUtils.isJava118() ? new HttpClient() : new HttpClient(MANAGER);
        httpClient.setConnectionTimeout(n);
        httpClient.setTimeout(n2);
        int n3 = ConnectionSettings.CONNECTION_METHOD.getValue();
        if (n3 == 1) {
            httpClient.getHostConfiguration().setProxy(ConnectionSettings.PROXY_HOST.getValue(), ConnectionSettings.PROXY_PORT.getValue());
        } else if (n3 == 4 || n3 == 5) {
            HostConfiguration hostConfiguration = httpClient.getHostConfiguration();
            String string = ConnectionSettings.PROXY_HOST.getValue();
            int n4 = ConnectionSettings.PROXY_PORT.getValue();
            String string2 = null;
            String string3 = null;
            if (ConnectionSettings.PROXY_AUTHENTICATE.getValue()) {
                string2 = ConnectionSettings.PROXY_USERNAME.getValue();
                string3 = ConnectionSettings.PROXY_PASS.getValue();
            }
            if (n3 == 4) {
                hostConfiguration.setSOCKSProxySettings(4, string, n4, string2, string3);
            } else {
                hostConfiguration.setSOCKSProxySettings(5, string, n4, string2, string3);
            }
        }
        return httpClient;
    }

    public static void executeMethodRedirecting(HttpClient httpClient, HttpMethod httpMethod) throws IOException, HttpException {
        HttpClientManager.executeMethodRedirecting(httpClient, httpMethod, 10);
    }

    public static void executeMethodRedirecting(HttpClient httpClient, HttpMethod httpMethod, int n) throws IOException, HttpException {
        block3: for (int i = 0; i < n; ++i) {
            if (LOG.isInfoEnabled()) {
                LOG.info((Object)("Attempting connection (" + i + ") to " + httpMethod.getURI().getEscapedURI()));
            }
            httpClient.executeMethod(httpMethod);
            switch (httpMethod.getStatusCode()) {
                case 301: 
                case 302: 
                case 303: 
                case 307: {
                    if (!httpMethod.getFollowRedirects()) {
                        if (LOG.isInfoEnabled()) {
                            LOG.warn((Object)"Redirect requested but not supported");
                        }
                        throw new HttpException("Redirect requested");
                    }
                    Header header = httpMethod.getResponseHeader("location");
                    if (header == null) {
                        if (LOG.isInfoEnabled()) {
                            LOG.warn((Object)"Redirect requested, no location header");
                        }
                        throw new HttpException("Redirected without a location");
                    }
                    String string = header.getValue();
                    if (LOG.isInfoEnabled()) {
                        LOG.info((Object)("Redirected requested to: " + string));
                    }
                    URI uRI = new URI(string.toCharArray());
                    Header[] headerArray = httpMethod.getRequestHeaders();
                    httpMethod.recycle();
                    HostConfiguration hostConfiguration = httpMethod.getHostConfiguration();
                    hostConfiguration.setHost(uRI.getHost(), uRI.getPort(), uRI.getScheme());
                    httpMethod.setFollowRedirects(true);
                    for (int j = 0; j < headerArray.length; ++j) {
                        if (headerArray[j].getName().equals("Host")) continue;
                        httpMethod.addRequestHeader(headerArray[j]);
                    }
                    httpMethod.setPath(uRI.getEscapedPath());
                    httpMethod.setQueryString(uRI.getEscapedQuery());
                    httpMethod.removeRequestHeader("Authorization");
                    continue block3;
                }
                default: {
                    return;
                }
            }
        }
        throw new HttpException("Maximum redirects encountered, bailing");
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        if (!CommonUtils.isJava118()) {
            MANAGER = new MultiThreadedHttpConnectionManager();
            ((MultiThreadedHttpConnectionManager)MANAGER).setIdleConnectionTime(30000L);
        } else {
            MANAGER = null;
        }
    }
}

