/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.http;

import com.limegroup.gnutella.http.ConstantHTTPHeaderValue;
import com.limegroup.gnutella.http.HTTPHeaderName;
import com.limegroup.gnutella.http.HTTPHeaderValue;
import com.limegroup.gnutella.http.HTTPHeaderValueCollection;
import com.limegroup.gnutella.settings.ChatSettings;
import com.limegroup.gnutella.statistics.BandwidthStat;
import com.limegroup.gnutella.util.CommonUtils;
import com.sun.java.util.collections.Collection;
import com.sun.java.util.collections.HashSet;
import com.sun.java.util.collections.Set;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;

public final class HTTPUtils {
    private static final String CRLF = "\r\n";
    private static final String COLON_SPACE = ": ";
    private static final String COLON = ":";

    private HTTPUtils() {
    }

    public static void writeHeader(HTTPHeaderName hTTPHeaderName, String string, OutputStream outputStream) throws IOException {
        if (hTTPHeaderName == null) {
            throw new NullPointerException("null name in writing http header");
        }
        if (string == null) {
            throw new NullPointerException("null value in writing http header: " + hTTPHeaderName);
        }
        if (outputStream == null) {
            throw new NullPointerException("null os in writing http header: " + hTTPHeaderName);
        }
        String string2 = HTTPUtils.createHeader(hTTPHeaderName, string);
        outputStream.write(string2.getBytes());
        if (!CommonUtils.isJava118()) {
            BandwidthStat.HTTP_HEADER_UPSTREAM_BANDWIDTH.addData(string2.length());
        }
    }

    public static void writeHeader(HTTPHeaderName hTTPHeaderName, String string, Writer writer) throws IOException {
        if (hTTPHeaderName == null) {
            throw new NullPointerException("null name in writing http header");
        }
        if (string == null) {
            throw new NullPointerException("null value in writing http header: " + hTTPHeaderName);
        }
        if (writer == null) {
            throw new NullPointerException("null os in writing http header: " + hTTPHeaderName);
        }
        String string2 = HTTPUtils.createHeader(hTTPHeaderName, string);
        writer.write(string2);
        if (!CommonUtils.isJava118()) {
            BandwidthStat.HTTP_HEADER_UPSTREAM_BANDWIDTH.addData(string2.length());
        }
    }

    public static void writeHeader(HTTPHeaderName hTTPHeaderName, HTTPHeaderValue hTTPHeaderValue, OutputStream outputStream) throws IOException {
        if (hTTPHeaderName == null) {
            throw new NullPointerException("null name in writing http header");
        }
        if (hTTPHeaderValue == null) {
            throw new NullPointerException("null value in writing http header: " + hTTPHeaderName);
        }
        if (outputStream == null) {
            throw new NullPointerException("null os in writing http header: " + hTTPHeaderName);
        }
        String string = HTTPUtils.createHeader(hTTPHeaderName, hTTPHeaderValue.httpStringValue());
        outputStream.write(string.getBytes());
        if (!CommonUtils.isJava118()) {
            BandwidthStat.HTTP_HEADER_UPSTREAM_BANDWIDTH.addData(string.length());
        }
    }

    public static void writeHeader(HTTPHeaderName hTTPHeaderName, HTTPHeaderValue hTTPHeaderValue, Writer writer) throws IOException {
        if (hTTPHeaderName == null) {
            throw new NullPointerException("null name in writing http header");
        }
        if (hTTPHeaderValue == null) {
            throw new NullPointerException("null value in writing http header: " + hTTPHeaderName);
        }
        if (writer == null) {
            throw new NullPointerException("null os in writing http header: " + hTTPHeaderName);
        }
        String string = HTTPUtils.createHeader(hTTPHeaderName, hTTPHeaderValue.httpStringValue());
        writer.write(string);
        if (!CommonUtils.isJava118()) {
            BandwidthStat.HTTP_HEADER_UPSTREAM_BANDWIDTH.addData(string.length());
        }
    }

    private static String createHeader(HTTPHeaderName hTTPHeaderName, String string) throws IOException {
        if (hTTPHeaderName == null || string == null) {
            throw new NullPointerException("null value in creating http header");
        }
        String string2 = hTTPHeaderName.httpStringValue();
        if (string2 == null) {
            throw new NullPointerException("null value in creating http header");
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(string2);
        stringBuffer.append(COLON_SPACE);
        stringBuffer.append(string);
        stringBuffer.append(CRLF);
        return stringBuffer.toString();
    }

    public static String extractHeaderValue(String string) {
        int n = string.indexOf(COLON);
        if (n <= 0) {
            return null;
        }
        return string.substring(n + 1).trim();
    }

    public static void writeHeader(HTTPHeaderName hTTPHeaderName, int n, Writer writer) throws IOException {
        HTTPUtils.writeHeader(hTTPHeaderName, String.valueOf(n), writer);
    }

    public static void writeHeader(HTTPHeaderName hTTPHeaderName, int n, OutputStream outputStream) throws IOException {
        HTTPUtils.writeHeader(hTTPHeaderName, String.valueOf(n), outputStream);
    }

    public static void writeDate(Writer writer) throws IOException {
        HTTPUtils.writeHeader(HTTPHeaderName.DATE, HTTPUtils.getDateValue(), writer);
    }

    public static void writeDate(OutputStream outputStream) throws IOException {
        HTTPUtils.writeHeader(HTTPHeaderName.DATE, HTTPUtils.getDateValue(), outputStream);
    }

    public static void writeFeatures(Writer writer) throws IOException {
        Set set = HTTPUtils.getFeaturesValue();
        if (set.size() > 0) {
            HTTPUtils.writeHeader(HTTPHeaderName.FEATURES, (HTTPHeaderValue)new HTTPHeaderValueCollection((Collection)set), writer);
        }
    }

    public static void writeFeatures(OutputStream outputStream) throws IOException {
        Set set = HTTPUtils.getFeaturesValue();
        if (set.size() > 0) {
            HTTPUtils.writeHeader(HTTPHeaderName.FEATURES, (HTTPHeaderValue)new HTTPHeaderValueCollection((Collection)set), outputStream);
        }
    }

    private static Set getFeaturesValue() {
        HashSet hashSet = new HashSet(2);
        hashSet.add((Object)ConstantHTTPHeaderValue.BROWSE_FEATURE);
        if (ChatSettings.CHAT_ENABLED.getValue()) {
            hashSet.add((Object)ConstantHTTPHeaderValue.CHAT_FEATURE);
        }
        return hashSet;
    }

    private static String getDateValue() {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("EEE, d MMM yyyy HH:mm:ss z", Locale.US);
        simpleDateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
        return simpleDateFormat.format(new Date());
    }
}

