/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.downloader;

import com.limegroup.gnutella.downloader.Interval;
import com.limegroup.gnutella.downloader.ManagedDownloader;
import com.limegroup.gnutella.tigertree.HashTree;
import com.limegroup.gnutella.util.FileUtils;
import com.limegroup.gnutella.util.IntervalSet;
import com.sun.java.util.collections.Iterator;
import com.sun.java.util.collections.List;
import com.sun.java.util.collections.NoSuchElementException;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class VerifyingFile {
    private static final Log LOG = LogFactory.getLog((Class)(class$com$limegroup$gnutella$downloader$VerifyingFile == null ? (class$com$limegroup$gnutella$downloader$VerifyingFile = VerifyingFile.class$("com.limegroup.gnutella.downloader.VerifyingFile")) : class$com$limegroup$gnutella$downloader$VerifyingFile));
    private RandomAccessFile fos;
    private final boolean checkOverlap;
    private volatile boolean isCorrupted;
    private ManagedDownloader managedDownloader;
    private final int completedSize;
    private final IntervalSet writtenBlocks;
    private IntervalSet leasedBlocks;
    static /* synthetic */ Class class$com$limegroup$gnutella$downloader$VerifyingFile;

    public VerifyingFile(boolean bl) {
        this(bl, -1);
    }

    public VerifyingFile(boolean bl, int n) {
        this.completedSize = n;
        this.checkOverlap = bl;
        this.writtenBlocks = new IntervalSet();
        this.leasedBlocks = new IntervalSet();
    }

    public void open(File file, ManagedDownloader managedDownloader) throws IOException {
        if (this.completedSize == -1) {
            throw new IllegalStateException("cannot open for unknown size.");
        }
        this.managedDownloader = managedDownloader;
        File file2 = FileUtils.getParentFile(file);
        if (file2 != null) {
            file2.mkdirs();
            FileUtils.setWriteable(file2);
        }
        FileUtils.setWriteable(file);
        this.fos = new RandomAccessFile(file, "rw");
        this.leasedBlocks = new IntervalSet();
    }

    public synchronized void addInterval(Interval interval) {
        this.writtenBlocks.add(interval);
        this.releaseBlock(interval);
    }

    public synchronized void writeBlock(long l, int n, byte[] byArray) throws IOException {
        if (n == 0) {
            return;
        }
        if (this.fos == null) {
            throw new IOException();
        }
        boolean bl = false;
        List list = null;
        Interval interval = new Interval((int)l, (int)l + n - 1);
        if (this.checkOverlap && (list = this.writtenBlocks.getOverlapIntervals(interval)).size() > 0) {
            bl = true;
        }
        if (bl) {
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                Interval interval2 = (Interval)iterator.next();
                int n2 = interval2.high - interval2.low + 1;
                byte[] byArray2 = new byte[n2];
                this.fos.seek(interval2.low);
                this.fos.readFully(byArray2, 0, n2);
                int n3 = this.findInitialPoint(interval2, l);
                int n4 = 0;
                while (n4 < n2) {
                    if (byArray[n3] != byArray2[n4]) {
                        this.isCorrupted = true;
                        if (this.managedDownloader != null) {
                            this.managedDownloader.promptAboutCorruptDownload();
                        }
                    }
                    ++n4;
                    ++n3;
                }
            }
        }
        this.fos.seek(l);
        this.fos.write(byArray, 0, n);
        this.writtenBlocks.add(interval);
        this.releaseBlock(interval);
    }

    public synchronized Interval leaseWhite() throws NoSuchElementException {
        IntervalSet intervalSet = this.writtenBlocks.invert(this.completedSize);
        intervalSet.delete(this.leasedBlocks);
        Interval interval = intervalSet.removeFirst();
        this.leaseBlock(interval);
        return interval;
    }

    public synchronized Interval leaseWhite(int n) throws NoSuchElementException {
        Interval interval = this.leaseWhite();
        return this.fixIntervalForChunk(interval, n);
    }

    public synchronized Interval leaseWhite(IntervalSet intervalSet) throws NoSuchElementException {
        intervalSet.delete(this.writtenBlocks);
        intervalSet.delete(this.leasedBlocks);
        Interval interval = intervalSet.removeFirst();
        while (interval != null && interval.high - interval.low <= 10) {
            interval = intervalSet.removeFirst();
        }
        Interval interval2 = new Interval(interval.low + 10, interval.high);
        this.leaseBlock(interval2);
        return interval2;
    }

    public synchronized Interval leaseWhite(IntervalSet intervalSet, int n) throws NoSuchElementException {
        Interval interval = this.leaseWhite(intervalSet);
        return this.fixIntervalForChunk(interval, n);
    }

    public synchronized void releaseBlock(Interval interval) {
        this.leasedBlocks.delete(interval);
    }

    public synchronized Iterator getBlocks() {
        return this.writtenBlocks.getAllIntervals();
    }

    public synchronized List getBlocksAsList() {
        return this.writtenBlocks.getAllIntervalsAsList();
    }

    public synchronized Iterator getFreeBlocks(int n) {
        return this.writtenBlocks.getNeededIntervals(n);
    }

    public synchronized int getBlockSize() {
        return this.writtenBlocks.getSize();
    }

    public synchronized boolean isComplete() {
        return this.writtenBlocks.getSize() == this.completedSize;
    }

    public synchronized boolean hasFreeBlocksToAssign() {
        return this.writtenBlocks.getSize() + this.leasedBlocks.getSize() < this.completedSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized int deleteCorruptedBlocks(HashTree hashTree, File file) throws IOException {
        InputStream inputStream = null;
        int n = 0;
        try {
            inputStream = new BufferedInputStream(new FileInputStream(file));
            List list = hashTree.getCorruptRanges(inputStream);
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                ++n;
                this.writtenBlocks.delete((Interval)iterator.next());
            }
            this.isCorrupted = false;
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
        return n;
    }

    public void close() {
        if (this.fos == null) {
            return;
        }
        try {
            this.fos.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void clearManagedDownloader() {
        this.managedDownloader = null;
    }

    public boolean isCorrupted() {
        return this.isCorrupted;
    }

    public ManagedDownloader getManagedDownloader() {
        return this.managedDownloader;
    }

    private int findInitialPoint(Interval interval, long l) {
        if ((long)interval.low <= l) {
            return 0;
        }
        return interval.low - (int)l;
    }

    private synchronized Interval fixIntervalForChunk(Interval interval, int n) {
        Interval interval2;
        if (interval.high - interval.low + 1 > n) {
            int n2 = interval.low + n - 1;
            interval2 = new Interval(interval.low, n2);
            interval = new Interval(n2 + 1, interval.high);
            this.releaseBlock(interval);
        } else {
            interval2 = interval;
        }
        return interval2;
    }

    private synchronized void leaseBlock(Interval interval) {
        this.leasedBlocks.add(interval);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

