/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.downloader;

import com.limegroup.gnutella.Assert;
import com.limegroup.gnutella.GUID;
import com.limegroup.gnutella.MediaType;
import com.limegroup.gnutella.RemoteFileDesc;
import com.limegroup.gnutella.downloader.AutoDownloadDetails;
import com.limegroup.gnutella.downloader.CantResumeException;
import com.limegroup.gnutella.downloader.IncompleteFileManager;
import com.limegroup.gnutella.downloader.ManagedDownloader;
import com.limegroup.gnutella.messages.QueryRequest;
import java.io.Serializable;

public class RequeryDownloader
extends ManagedDownloader
implements Serializable {
    static final long serialVersionUID = 8241301635419840924L;
    protected AutoDownloadDetails _add;
    private boolean _hasFile = false;
    static int MAX_WAIT_TIME = 300000;

    public RequeryDownloader(IncompleteFileManager incompleteFileManager, AutoDownloadDetails autoDownloadDetails, GUID gUID) {
        super(new RemoteFileDesc[0], incompleteFileManager, gUID);
        Assert.that(autoDownloadDetails != null, "Instantiated with a null AutoDownloadDetail!");
        this._add = autoDownloadDetails;
    }

    private String getQuery() {
        return this._add.getQuery();
    }

    private String getRichQuery() {
        return this._add.getRichQuery();
    }

    private final MediaType getMediaType() {
        return this._add.getMediaType();
    }

    public boolean conflicts(AutoDownloadDetails autoDownloadDetails) {
        return this.getQuery().equals(autoDownloadDetails.getQuery()) && this.getMediaType().toString().equals(autoDownloadDetails.getMediaType().toString());
    }

    protected long[] getFailedState(boolean bl, long l) {
        if (!bl && l < (long)MAX_WAIT_TIME) {
            long[] lArray = new long[]{8L, (long)MAX_WAIT_TIME - l};
            return lArray;
        }
        return super.getFailedState(bl, l);
    }

    protected int getQueryCount(boolean bl) {
        if (bl) {
            return 0;
        }
        return 1;
    }

    protected QueryRequest newRequery(int n) throws CantResumeException {
        if (this._hasFile) {
            return super.newRequery(n);
        }
        return QueryRequest.createQuery(this.getQuery());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean allowAddition(RemoteFileDesc remoteFileDesc) {
        if (this._hasFile) {
            return super.allowAddition(remoteFileDesc);
        }
        AutoDownloadDetails autoDownloadDetails = this._add;
        synchronized (autoDownloadDetails) {
            if (this._add.addDownload(remoteFileDesc)) {
                this._add.commitDownload(remoteFileDesc);
                this._hasFile = true;
                return true;
            }
            return false;
        }
    }

    public synchronized String getFileName() {
        if (this._hasFile) {
            return super.getFileName();
        }
        return "\"" + this.getQuery() + "\"";
    }

    public synchronized int getContentLength() {
        if (this._hasFile) {
            return super.getContentLength();
        }
        return -1;
    }

    boolean hasFile() {
        return this._hasFile;
    }
}

