/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.downloader;

import com.limegroup.gnutella.Assert;
import com.limegroup.gnutella.RemoteFileDesc;
import com.limegroup.gnutella.URN;
import com.limegroup.gnutella.downloader.IncompleteFileManager;
import com.sun.java.util.collections.ArrayList;
import com.sun.java.util.collections.Arrays;
import com.sun.java.util.collections.Collections;
import com.sun.java.util.collections.Comparable;
import com.sun.java.util.collections.Iterator;
import com.sun.java.util.collections.List;
import com.sun.java.util.collections.NoSuchElementException;
import com.sun.java.util.collections.UnsupportedOperationException;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;

class RemoteFileDescGrouper
implements Serializable {
    private List buckets = new ArrayList();
    private List incompletes = new ArrayList();
    private URN[] sha1s = new URN[0];
    private IncompleteFileManager incompleteFileManager;
    private static final int DECENT_QUALITY = 2;
    private static final int MAX_BUCKET_SIZE = 500;
    static boolean DEBUG = false;

    RemoteFileDescGrouper(RemoteFileDesc[] remoteFileDescArray, IncompleteFileManager incompleteFileManager) {
        Object object;
        int n;
        this.incompleteFileManager = incompleteFileManager;
        for (int i = 0; i < remoteFileDescArray.length; ++i) {
            this.add(remoteFileDescArray[i], false);
        }
        this.repOk();
        Object[] objectArray = new FileTuple[this.buckets.size()];
        for (n = 0; n < this.buckets.size(); ++n) {
            object = (File)this.incompletes.get(n);
            List list = (List)this.buckets.get(n);
            int n2 = ((RemoteFileDesc)list.get(0)).getSize() - incompleteFileManager.getBlockSize((File)object);
            int n3 = 1;
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                RemoteFileDesc remoteFileDesc = (RemoteFileDesc)iterator.next();
                if (remoteFileDesc.getQuality() < 2) continue;
                n3 += RemoteFileDescGrouper.normalize(remoteFileDesc.getSpeed());
            }
            float f = (float)n2 / (float)n3;
            objectArray[n] = new FileTuple(list, (File)object, this.sha1s[n], f);
        }
        Arrays.sort((Object[])objectArray);
        for (n = 0; n < objectArray.length; ++n) {
            object = objectArray[n];
            this.buckets.set(n, (Object)((FileTuple)object).bucket);
            this.incompletes.set(n, (Object)((FileTuple)object).incompleteFile);
            this.sha1s[n] = ((FileTuple)object).sha1;
        }
        this.repOk();
    }

    private static int normalize(int n) {
        if (n < 56) {
            return 3;
        }
        if (n < 350) {
            return 30;
        }
        if (n < 1000) {
            return 40;
        }
        return 50;
    }

    synchronized int add(RemoteFileDesc remoteFileDesc, boolean bl) {
        this.repOk();
        File file = null;
        try {
            file = this.incompleteFileManager.getFile(remoteFileDesc);
        }
        catch (IOException iOException) {
            return -1;
        }
        int n = this.buckets.size();
        Assert.that(this.incompletes.size() == n, "Length of buckets and incompletes different: " + n + "!=" + this.incompletes.size());
        for (int i = 0; i < n; ++i) {
            File file2 = (File)this.incompletes.get(i);
            if (!file2.equals(file) || !RemoteFileDescGrouper.hashEquals(remoteFileDesc.getSHA1Urn(), this.sha1s[i])) continue;
            if (this.sha1s[i] == null && remoteFileDesc.getSHA1Urn() != null) {
                this.sha1s[i] = remoteFileDesc.getSHA1Urn();
            }
            List list = (List)this.buckets.get(i);
            if (bl && list.contains((Object)remoteFileDesc)) {
                return -1;
            }
            if (list.size() > 500) {
                return -1;
            }
            list.add((Object)remoteFileDesc);
            this.repOk();
            return 1;
        }
        ArrayList arrayList = new ArrayList();
        arrayList.add((Object)remoteFileDesc);
        this.buckets.add((Object)arrayList);
        this.incompletes.add((Object)file);
        int n2 = this.incompletes.size();
        URN[] uRNArray = new URN[n2];
        System.arraycopy(this.sha1s, 0, uRNArray, 0, this.sha1s.length);
        uRNArray[n2 - 1] = remoteFileDesc.getSHA1Urn();
        this.sha1s = uRNArray;
        this.repOk();
        return 0;
    }

    synchronized List getURNs() {
        return Collections.unmodifiableList((List)Arrays.asList((Object[])this.sha1s));
    }

    synchronized URN getURNForBucket(int n) {
        if (n < 0 || n >= this.buckets.size()) {
            throw new IllegalArgumentException("index: " + n + ", size: " + this.buckets.size());
        }
        return this.sha1s[n];
    }

    synchronized URN getBestURN() {
        if (this.sha1s.length < 1) {
            return null;
        }
        int n = 0;
        int n2 = this.buckets.size();
        int n3 = 0;
        for (int i = 0; i < n2; ++i) {
            List list = (List)this.buckets.get(i);
            if (list.size() <= n3) continue;
            n3 = list.size();
            n = i;
        }
        if (n < this.sha1s.length) {
            return this.sha1s[n];
        }
        return null;
    }

    private static boolean hashEquals(URN uRN, URN uRN2) {
        if (uRN == null || uRN2 == null) {
            return true;
        }
        return uRN.equals(uRN2);
    }

    Iterator buckets() {
        return new BucketIterator();
    }

    protected void repOk() {
        Serializable serializable;
        int n;
        Serializable serializable2;
        List list;
        int n2;
        if (!DEBUG) {
            return;
        }
        Assert.that(this.buckets.size() == this.incompletes.size());
        Assert.that(this.buckets.size() == this.sha1s.length);
        for (n2 = 0; n2 < this.buckets.size(); ++n2) {
            list = (List)this.buckets.get(n2);
            serializable2 = (File)this.incompletes.get(n2);
            for (n = 0; n < list.size(); ++n) {
                try {
                    serializable = this.incompleteFileManager.getFile((RemoteFileDesc)list.get(n));
                    Assert.that(((File)serializable2).equals(serializable));
                    continue;
                }
                catch (IOException iOException) {
                    Assert.that(false, iOException.getMessage());
                }
            }
        }
        for (n2 = 0; n2 < this.buckets.size(); ++n2) {
            list = (List)this.buckets.get(n2);
            serializable2 = this.sha1s[n2];
            for (n = 0; n < list.size(); ++n) {
                serializable = ((RemoteFileDesc)list.get(n)).getSHA1Urn();
                if (serializable == null) continue;
                Assert.that(serializable2 != null);
                Assert.that(((URN)serializable2).equals(serializable));
            }
        }
    }

    private class BucketIterator
    implements Iterator {
        int i = 0;

        private BucketIterator() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean hasNext() {
            RemoteFileDescGrouper remoteFileDescGrouper = RemoteFileDescGrouper.this;
            synchronized (remoteFileDescGrouper) {
                return this.i < RemoteFileDescGrouper.this.buckets.size();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object next() {
            RemoteFileDescGrouper remoteFileDescGrouper = RemoteFileDescGrouper.this;
            synchronized (remoteFileDescGrouper) {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                return RemoteFileDescGrouper.this.buckets.get(this.i++);
            }
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private static class FileTuple
    implements Comparable {
        List bucket;
        File incompleteFile;
        URN sha1;
        float time;

        public FileTuple(List list, File file, URN uRN, float f) {
            this.bucket = list;
            this.incompleteFile = file;
            this.sha1 = uRN;
            this.time = f;
        }

        public int compareTo(Object object) {
            float f = this.time - ((FileTuple)object).time;
            if (f < 0.0f) {
                return -1;
            }
            if (f > 0.0f) {
                return 1;
            }
            return 0;
        }
    }
}

