/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.downloader;

import com.sun.java.util.collections.Comparable;
import java.io.Serializable;

public class Interval
implements Serializable,
Comparable {
    static final long serialVersionUID = -2562093104400487554L;
    public int low;
    public int high;

    public Interval(int n, int n2) {
        if (n2 < n) {
            throw new IllegalArgumentException("low: " + n + ", high: " + n2);
        }
        this.low = n;
        this.high = n2;
    }

    public Interval(int n) {
        this.low = n;
        this.high = n;
    }

    public int compareTo(Object object) {
        Interval interval = (Interval)object;
        if (this.low != interval.low) {
            return this.low - interval.low;
        }
        return this.high - interval.high;
    }

    public boolean adjacent(Interval interval) {
        return this.high == interval.low || this.low == interval.high;
    }

    public boolean overlaps(Interval interval) {
        return this.low < interval.high && interval.low < this.high || interval.low < this.high && this.low < interval.high;
    }

    public boolean isSubrange(Interval interval) {
        return this.low >= interval.low && this.high <= interval.high;
    }

    public String toString() {
        if (this.low == this.high) {
            return String.valueOf(this.low);
        }
        return String.valueOf(this.low) + "-" + String.valueOf(this.high);
    }

    public boolean equals(Object object) {
        if (!(object instanceof Interval)) {
            return false;
        }
        Interval interval = (Interval)object;
        return this.low == interval.low && this.high == interval.high;
    }
}

